<?php  
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Clever-Age                                        |
// +----------------------------------------------------------------------+
// | Author: Erwan LE BESCOND <elebescond@clever-age.com>                 |
// +----------------------------------------------------------------------+
//
// Base class for Indexer_Syndic.
// $Id$

require_once (dirname(__FILE__)."/../Indexer.php");
require_once (dirname(__FILE__)."/../../bd/inc_syndic_factory.php");
require_once (dirname(__FILE__)."/../../bd/inc_syndic_articles_factory.php");
require_once (dirname(__FILE__)."/../../bd/inc_index_syndic_factory.php");

require_once (dirname(__FILE__)."/../../../inc_sites.php3");

/**
 * Indexer_Syndic_common is an implementation for Common of syndic indexer.
 * @package	indexer/common
 * @author 	Erwan Le Bescond <elebescond@clever-age.com>
 * @access	public
 */
class Indexer_Syndic_common extends Indexer {

	// {{{ constructor

	/**
	 * ListeAction constructor.
	 *
	 * @access public
	 */

	function Indexer_Syndic_common() {

        /*
		$poids = array ();
		include (dirname(__FILE__)."/configurationSyndicPoids_common.php");
		if (file_exists(dirname(__FILE__)."/configurationSyndicPoids_".$GLOBALS['type_indexation'].".php")) {
			include (dirname(__FILE__)."/configurationSyndicPoids_".$GLOBALS['type_indexation'].".php");
		}
        if(file_exists(dirname(__FILE__)."/../".$GLOBALS['type_indexation']."/configurationSyndicPoids_".$GLOBALS['type_indexation'].".php")) {
            include(dirname(__FILE__)."/../".$GLOBALS['type_indexation']."/configurationSyndicPoids_".$GLOBALS['type_indexation'].".php");
        }
        */
        $this->_setPoids($this->_findConfigFile('configurationSyndicPoids', $GLOBALS['type_indexation']) );

		$this->_full = false;

		$this->_type = 'syndic';
        
        $this->_minlong = $min_long;

	}

	// }}}

	// {{{

	function alreadyIndex($id_objet) {

		$indexSyndicMetier = & recuperer_instance_index_syndic ();
		/*
		return ($indexSyndicMetier->howManyIndexSyndicForMotId($id_objet) > 0);
		*/
		return ($indexSyndicMetier->howManyIndexSyndicForSyndicId($id_objet) > 0);

	}

	// }}}

	// {{{

	function _indexData($id_objet) {
        include_once (dirname(__FILE__).'/../../bd/inc_syndic_factory.php');
		$syndicMetier = &recuperer_instance_syndic();
		$loadOK = $syndicMetier->load($id_objet);
		if (PEAR :: isError($loadOK)) {
			//die($loadOK->getMessage());
            PEAR::raiseError("indexer syndic $id_object : ".$loadOk->getMessage(), PEAR_LOG_ERR,
                null, null, null, null, false); 
		} else {
			$this->_indexer_chaine($syndicMetier->getNomSite(), $this->_poids['syndic']['nom_site'], $this->_minlong, 'nom_site');
			$this->_indexer_chaine($syndicMetier->getDescriptif(), $this->_poids['syndic']['descriptif'], $this->_minlong, 'descriptif');

			if ($this->_full) {
				// Ajouter les titres des articles syndiques de ce site, le cas echeant
				if ($syndicMetier->getSyndication() == "oui") {
					$syndicArticleMetier = & recuperer_instance_syndic_articles();
					$allSyndicArticleByDate = $syndicArticleMetier->getAllForSyndicId($id_objet, "date_heure");
					if (PEAR :: isError($allSyndicArticleByDate)) {
						die($allSyndicArticleByDate->getMessage());
					}
					while (list (, $syndicArticleMetier) = each($allSyndicArticleByDate)) {
						$titre = $this->_indexer_chaine($syndicArticleMetier->getTitre(), $this->_poids['syndication']['titre']);
					}
				}
				// Aller chercher la page d'accueil
				if (lire_meta("visiter_sites") == "oui") {
					//include_ecrire("inc_sites.php3");
					if (function_exists(spip_log)) {
						spip_log("indexation contenu syndic ".$syndicMetier->getUrlSite());
					}
					$this->_indexer_chaine(supprimer_tags(substr(recuperer_page($syndicMetier->getUrlSite()), 0, 50000)), $this->_poids['syndic']['page_accueil']);
				}
			}
		}

	}

	// }}}

	// {{{ 
/*
	function _createIndex($id_objet) {

		$indexSyndicCreateMetier = & recuperer_instance_index_syndic();

		//while (list ($hash, $points) = each($this->_index)) {
        foreach ($this->_index as $hash => $info1) {
            foreach ($info1 as $emplacement => $info) {
                $indexSyndicCreateMetier->setHash("0x$hash");
                //$indexArticleCreateMetier->setPoints("$points");
                $indexSyndicCreateMetier->setPoints($info['points']);
    			$indexSyndicCreateMetier->setSyndicId("$id_objet");
                $indexSyndicCreateMetier->setEmplacement($info['emplacement']);
    			$indexSyndicCreateMetier->create();
    			if (PEAR :: isError($createOK)) {
    				die($createOK->getMessage());
    			}
            }
		}

	}
*/
	// }}}

}

?>
