<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Clever-Age                                        |
// +----------------------------------------------------------------------+
// | Author: Erwan LE BESCOND <elebescond@clever-age.com>                 |
// +----------------------------------------------------------------------+
//
// Base class for Indexer_Article_exemple.
//

require_once dirname(__FILE__)."/../Indexer.php";
require_once dirname(__FILE__)."/../../bd/inc_article_factory.php";
require_once dirname(__FILE__)."/../../bd/inc_rubrique_factory.php";
require_once dirname(__FILE__)."/../../bd/inc_mot_factory.php";
require_once dirname(__FILE__)."/../../bd/inc_auteur_factory.php";
require_once dirname(__FILE__)."/../../bd/inc_index_articles_factory.php";


/**
 * Indexer_Article_exemple is an implementation for Exemple of article indexer.
 * @package	indexer/exemple
 * @author 	Erwan Le Bescond <elebescond@clever-age.com>
 * @access	public
 */
class Indexer_Article_exemple extends Indexer {
    
    
	// {{{ constructor

    /**
     * ListeAction constructor.
     *
     * @access public
     */

    function Indexer_Article_exemple() {
		
		$this->_full = false;
		
		$this->_type = 'article';
		
    }

    // }}}

	// {{{
	
	function alreadyIndex($id_objet) {

		$indexArticleMetier = &recuperer_instance_index_articles();
		return ( $indexArticleMetier->howManyIndexArticleForArticleId($id_objet) > 0 );
		
	}
		
	// }}}
    
    // {{{
    
    function _definitionPoids($article) {
    	
    	$poids = array();
		include_once(dirname(__FILE__)."/configurationArticlePoids_exemple.php");
		if(file_exists(dirname(__FILE__)."/configurationArticlePoids_".$GLOBALS['type_indexer'].".php")) {
			include_once(dirname(__FILE__)."/configurationArticlePoids_".$GLOBALS['type_indexer'].".php");
       	}
    	
		if(file_exists(dirname(__FILE__)."/configurationArticlePoids_".$GLOBALS['type_indexation']."=" . $article->getRubriqueId() . ".php")) {
			include_once(dirname(__FILE__)."/configurationArticlePoids_".$GLOBALS['type_indexation']."=" . $article->getRubriqueId() . ".php");
		}
		else {

			$rubriqueMetier = &recuperer_instance_rubrique();
			$hierarchie = $rubriqueMetier->getHierarchie($article->getRubriqueId());

			if (PEAR::isError($hierarchie)) {
				die ($hierarchie->getMessage());
			}
					
			foreach( $hierarchie as $rubriqueId) {
				if(file_exists(dirname(__FILE__)."/configurationArticlePoids_".$GLOBALS['type_indexation']."-" . $rubriqueId . ".php")) {
					include_once(dirname(__FILE__)."/configurationArticlePoids_".$GLOBALS['type_indexation']."-" . $rubriqueId . ".php");
				}
			}

		}
    	
		
		$this->_poids = $poids;
    }
    
    // }}}
    
    
    // {{{

    function _indexData($id_objet) {

		$articleMetier = &recuperer_instance_article();
		$loadOk = $articleMetier->load($id_objet);
		if (!PEAR::isError($loadOk)) {
		    $this->_definitionPoids($articleMetier);
		    $this->_indexer_chaine($articleMetier->getTitre(), $this->_poids['article']['titre']);
			$this->_indexer_chaine($articleMetier->getSoustitre(), $this->_poids['article']['soustitre']);
			$this->_indexer_chaine($articleMetier->getSurtitre(), $this->_poids['article']['surtitre']);
			$this->_indexer_chaine($articleMetier->getDescriptif(), $this->_poids['article']['descriptif']);
			if ($full) {
				$this->_indexer_chaine($articleMetier->getChapo(), $this->_poids['article']['chapo']);
				$this->_indexer_chaine($articleMetier->getTexte(), $this->_poids['article']['texte']);
				$this->_indexer_chaine($articleMetier->getPs(), $this->_poids['article']['ps']);
			}
		}

	    $motMetier = &recuperer_instance_mot();
	    
		$allMots = $motMetier->getAllFromMotsAndAnotherTable("articles", "id_article", $id_objet);
		if(!PEAR::isError($allMots)) {
			while (list(,$motMetier) = each($allMots)) {
	    		$this->_indexer_chaine($motMetier->getTitre(), $this->_poids['mot']['titre']);
				$this->_indexer_chaine($motMetier->getDescriptif(), $this->_poids['mot']['descriptif']);
			}
		}

    	$articleMetier = &recuperer_instance_article();
		$allAuteurs = $articleMetier->getAuteursForArticleId($id_objet);

		while (list(,$monAuteur) = each($allAuteurs)) {
 	   		$this->_indexer_chaine($monAuteur->getNom(), $this->_poids['auteur']['nom']);
    	}

		$indexArticleMetier = &recuperer_instance_index_articles();
    	$indexArticleMetier->deleteIndexArticleForArticleId($id_objet);
    	
    }

    // }}}
	
	// {{{ 

    function _createIndex($id_objet) {
    	
    	$indexArticleCreateMetier = &recuperer_instance_index_articles();
		
		while (list($hash, $points) = each($this->_index)) {
	    	$indexArticleCreateMetier->setHash("0x$hash");
	    	$indexArticleCreateMetier->setPoints("$points");
	    	$indexArticleCreateMetier->setArticleId("$id_objet");
        	$indexArticleCreateMetier->create();
		}
    	
    }

    // }}}

}

?>
