<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Antoine Angnieux <aangenieux@clever-age.com>                |
// +----------------------------------------------------------------------+
//
// Implementation class for Microsoft IndexServer.
//

require_once("SearchEngine.php");
require_once("tools.inc.php");
require_once("conf/indexserver.inc.php");

/**
 * Implementation class for Microsoft IndexServer.
 * This implementation posts a search query
 * to a .idq file served by Microst IIS server coupled
 * with Index Server.
 * Before calling search method, in any script, include
 * the configuration script defining the needed constants
 * to interface IndexServer. (Temporary solution).
 */
class SearchEngine_IndexServer extends SearchEngine {

    // {{{ constructor

    /**
     * Constructor for this implementation, used by the SearchEngine factory method
     * @access  private
     */
    function SearchEngine_IndexServer() {
        $par = get_parent_class($this);
        $res = $this->$par();
        if (PEAR::isError($res)) {
            die($res->getMessage());
        }
    }

    // }}}

    // {{{ _computeQuery()

    /**
     * Implementation for Index Server
     *
     * @param   Array       query parameters
     * @return  String      XML result stream validating the indexresults.xsd XML Schema
     * @access  private
     */
    function &_computeQuery($queryParameters) {
        $queryToPost = $this->_computePostFields($queryParameters);
        $xmlStream = &sendToHostNoHeader(IIS_ADDRESS, IIS_PORT, "POST",
                                IDX_SRVR_IDQ, $queryToPost);
        return $xmlStream;
    }

    // }}}

    // {{{ _computePostFields()

    /**
     * This method computes the data to post given the query parameters
     * @param   Array   $queryParameters containing the query parameters
     * @return  String  representing the data ready to be posted as is
     * @access  private
     */
    function _computePostFields($queryParameters) {
        $textQuery = $this->_prepareTextQuery($queryParameters["textquery"]);
        if (isset($queryParameters["maxresults"])) {
            $resultLimit = "&CiLimits=".urlencode($queryParameters["maxresults"]);
        } else {
            $resultLimit = "&CiLimits=100";
        }
        $dataToPost = "MyRestriction=".urlencode($textQuery);
        $dataToPost.= $resultLimit;
        return $dataToPost;
    }

    // }}}

    // {{{ _prepareTextQuery()

    /**
     * This methods prepare a text query so that it is represented as IndexServer
     * uses it.
     * @param   String  $query Query that needs to be modified
     * @return  String  modified query
     * @access  private
     */
    function _prepareTextQuery($query) {
        // A implementer !
        return $query;
    }

    // }}}

}

?>
