<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Erwan LE BESCOND <elebescond@clever-age.com>                 |
// +----------------------------------------------------------------------+
//
// Implementation class for MnoGoSearch.
//

require_once dirname(__FILE__)."/../SearchEngine.php";
require_once dirname(__FILE__)."/../tools.inc.php";
require_once dirname(__FILE__)."/../conf/mnogosearch.inc.php";


/**
 * Implementation class for MnoGoSearch.
 * This implementation posts a search query
 * to a .idq file served by MnoGoSearch.
 * Before calling search method, in any script, include
 * the configuration script defining the needed constants
 * to interface MnoGoSearch. (Temporary solution).
 */
class SearchEngine_MnoGoSearch extends SearchEngine {

    // {{{ constructor

    /**
     * Constructor for this implementation, used by the MnoGoSearch factory method
     * @access  private
     */
    function SearchEngine_MnoGoSearch() {
        $par = get_parent_class($this);
        $res = $this->$par();
        if (PEAR::isError($res)) {
            die($res->getMessage());
        }
    }

    // }}}

    // {{{ _computeQuery()

    /**
     * Implementation for MnoGoSearch
     *
     * @param   Array       query parameters
     * @return  String      XML result stream validating the indexresults.xsd XML Schema
     * @access  private
     */
    function &_computeQuery($queryParameters) {
        $queryToGet = $this->_computePostFields($queryParameters);
        $xmlStream = &sendToHostNoHeader(MNOGOSEARCH_ADDRESS, MNOGOSEARCH_PORT, '',
                                IDX_SRVR_IDQ, $queryToGet);
        
        return $xmlStream;
    }

    // }}}

    // {{{ _computePostFields()

    /**
     * This method computes the data to post given the query parameters
     * @param   Array   $queryParameters containing the query parameters
     * @return  String  representing the data ready to be posted as is
     * @access  private
     */
    function _computePostFields($queryParameters) {
        $textQuery = $this->_prepareTextQuery($queryParameters["textquery"]);
        
        if (isset($queryParameters["maxresults"])) {
            $resultLimit = "&ps=".urlencode($queryParameters["maxresults"]);
        } else {
            $resultLimit = "&ps=100";
        }
        
        $dataToPost = "q=".urlencode($textQuery);
        $dataToPost.= $resultLimit.'&wm=sub';
        return $dataToPost;
    }

    // }}}

    // {{{ _prepareTextQuery()

    /**
     * This methods prepare a text query so that it is represented as MnoGoSearch
     * uses it.
     * @param   String  $query Query that needs to be modified
     * @return  String  modified query
     * @access  private
     */
    function _prepareTextQuery($query) {
    	require_once dirname(__FILE__)."/../../indexer/Indexer_Utils.php";
        $query = Indexer_Utils::nettoyer_chaine_indexation($query);
        $regs = Indexer_Utils::separateurs_indexation(true)." ";
        
        $query = strtr($query, $regs, ereg_replace('.', ' ', $regs));
        
        $rows = Indexer_Utils::spip_split(" +", $query);
        for ($i = 0; $i < count($rows);$i++) {
            if(strlen($rows[$i]) <= 3) {
                unset($rows[$i]);
            }
        }
        $query = join('|', $rows);
        return $query;
    }

    // }}}

}

?>
