<?php

//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Antoine Angnieux <aangenieux@clever-age.com>                |
// +----------------------------------------------------------------------+
//
// Helper class to store a Search Result
//

/**
 * This class is designed to provide information about a given result
 * from the indexer
 *
 * @author  Antoine Angnieux <aangenieux@clever-age.com>
 * @version $Revision$
 */

class SearchResult {

    // {{{ properties

    /**
     * This attribute represents the pertinence of this result
     * @var     int
     * @access  public
     */
    var $pertinence;

    /**
     * This attribute represents the filesystem path to the
     * result file
     * @var     String
     * @access  public
     */
    var $path;

    /**
     * This attribute represents the virtual path to the
     * result file
     * @var     String
     * @access  public
     */
    var $vpath;

    /**
     * This attribute represents the title (if available)
     * of this result
     * @var     String
     * @access  public
     */
    var $title;

    /**
     * This attribute represents the filename of the
     * result file
     * @var     String
     * @access  public
     */
    var $filename;

    /**
     * This attribute represents an abstract for this result
     * @var     String
     * @access  public
     */
    var $abstract;

    // }}}

    // {{{ consutructor

    /**
     * Constructor for this helper class.
     * @access public
     */
    function SearchResult() {

    }

    // }}}

}

?>