<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Antoine Angnieux <aangenieux@clever-age.com>                |
// +----------------------------------------------------------------------+
//
// Class used to handle search results from a search query
//

/**
 * This class is designed to handle the list of search results
 * for a given query.
 *
 * @author Antoine Angnieux <aangenieux@clever-age.com>
 * @version $Revision$
 */
class SearchResults {

    // {{{ properties

    /**
     * Specifies the total number of results returned by the indexer
     * @var     int
     * @access  public
     */
    var $numberOfResults;

    /**
     * Specifies the index of the first result returned by the query.
     * This is useful for example when querying the indexer for a
     * given page of results
     * @var     int
     * @access  public
     */
    var $firstResultIndex;

    /**
     * Specifies the index of the last result returned by the query.
     * This is useful for example when querying the indexer for a
     * given page of results
     * @var     int
     * @access  public
     */
    var $lastResultIndex;

    /**
     * Array of SearchResult for each result returned by the indexer
     * @var     array
     * @access  public
     */
    var $results;

    // }}}

    // {{{ constructor

    /**
     * Constructor for SearchResults. Empty for now!
     */
    function SearchResults() {
        $results = array();
    }

    // }}}

}

?>