<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Aurelien Vialet <avialet@clever-age.com>                     |
// +----------------------------------------------------------------------+
//
// Base class for constraints filter
//


/**
 * FilterCondition 
 * @author  Aurelien Vialet <avialet@clever-age.com>
 * @access	public
 */
class Filter {
	
	// {{{ properties
	
	 /**
     * Error Message
     * @var     String
     * @access  private
     */
	var $_errMsg;
    var $_articleId;
    var $_rubriqueId;
	var $_fieldName;
	var $_fieldContent;
	var $_ruleValue;
    // Utiliser si le message d'erreur est personnalise 
    // par le rsultat de l'application de la regle
    var $_options;
	
	
	// {{{ setFieldName
	function setFieldName($fieldName) {
		$this->_fieldName = $fieldName;
	}
	// }}}
	
	// {{{ getFieldName
	function getFieldName() {
		return $this->_fieldName;
	}
	// }}}
    
    // {{{ getArticleId
    function getArticleId() {
        return $this->_articleId;
    }
    // }}}
    
    // {{{setArticleId
    function setArticleId($articleId) {
        $this->_articleId = $articleId;
    }
    // }}}
    
    // {{{ getRubriqueId
    function getRubriqueId() {
        return $this->_rubriqueId;
    }
    // }}}
    
    // {{{ setRubriqueId
    function setRubriqueId($rubriqueId) {
        $this->_rubriqueId = $rubriqueId;
    }
    // }}}
	
	// {{{ setFieldContent
	function setFieldContent($fieldContent) {
		$this->_fieldContent = $fieldContent;
	}
	// }}}
	
	// {{{ getFieldContent
	
	function getFieldContent() {
		return $this->_fieldContent;
	}
	// }}}
	
	// {{{ setRuleValue	
	function setRuleValue($ruleValue) {
		$this->_ruleValue = $ruleValue;
	}
	// }}}
	
	// {{{ getRuleValue
	function getRuleValue() {
		return $this->_ruleValue;
	}
	// }}}
    
    
    // {{{ getOptions
    function getOptions() {
        return $this->_options;
    }
    // }}}
    
    
    // {{{ setOptions
    function setOptions($options) {
        $this->_options = $options;
    }
    // }}}
		
	
	// {{{ _applyRule()

    /**
     * Default implementation for _applyRule
     * @param   $ruleName String name of the rule
     * @access public
     * @return error message
     */
	
	function _applyRule() {
		return ('Pas d\'implementation pour ce filtre');
	}
	// }}}
	
	
	// {{{ validate
	function validate() {
		if (!$this->_applyRule()) {
			return ($this->_getErrMsg());
		}
		else {
			return true; 
		}	
	}
	// }}}
	
	// _getErrMsg
	function _getErrMsg() {
		return ('Pas de message d\'erreur de dfini!');
	}
	// }}}
	
}

?>