<?php
/**
 * Serveur SOAP pour SPIP-Agora.
 * On expose les fonctionnalits des classes mtiers.
 *
 * Les services exposs sont dfinis dans include/bd/<metier>_ws.php
 *
 * 
 * 
 * @version      $Id$
 * @author       Tristan Rivoallan <trivoallan@clever-age.com>
 */

// !!
set_include_path( get_include_path() .  ':' . '/usr/share/pear' );

main();

function main() {
    error_reporting( E_ALL ^ E_NOTICE );

    // Traitement du PATH_INFO
    $ressource = explode( '/', $_SERVER['PATH_INFO'] );
    
    if ( count($ressource) < 3 ) { die('NOT IMPLEMENTED YET.'); }

    // Ressource accde
    $ressource_type = $ressource[1];   // Type
    $ressource_id = $ressource[2];     // Identifiant

    require_once 'SOAP/Server.php';
    
    // Chemin vers le rpertoire des classes mtier
    $daos_path = dirname(__FILE__) . '/../bd';
    
    // Instanciation du serveur SOAP
    $soap_srv =& new SOAP_Server;
    
    // Environnement
    $class_factory_path    = sprintf( '%s/inc_%s_factory.php', $daos_path, $ressource_type );
    $class_factory_func    = sprintf( 'recuperer_instance_%s', $ressource_type );
    $class_ws_path         = sprintf( '%s/%s_ws.php', $daos_path, $ressource_type );
    $class_ws_name         = sprintf( 'Agora_Webservice_%s', ucfirst($ressource_type) );
    $class_namespace       = sprintf( '%s/ns', 'http://agora.gouv.fr' );
    
    // Instanciation de la classe mtier
    require_once $class_factory_path;
    $obj_metier =& $class_factory_func();

    // On ne recherche pas la ressource lorsque le client demande le contrat WSDL
    if ( ! eregi("\?wsdl$", $_SERVER['REQUEST_URI'])) {
        // Dfinition des services exposs
        $status = $obj_metier->load($ressource_id);
        if ( PEAR::isError($status) ) { 
            require_once 'SOAP/Fault.php';
            $faultcode = $status->getCode();
            $faultstring = htmlentities( $status->getMessage() );
            $faultactor = null;
            $detail = null;
            $fault =& new SOAP_Fault($faultstring,
                                     $faultcode,
                                     $faultactor,
                                     $detail);
            
            header('Content-type: text/xml');
            echo $fault->message();
            exit;
            
        }
    }
    
    require $class_ws_path;
    $obj_ws =& new $class_ws_name( $obj_metier );
    $soap_srv->addObjectMap( $obj_ws, $class_namespace );
    

    /* Dmarrage du serveur SOAP
     * Si la requte est de type POST, on dmarre le serveur SOAP.
     * Si la requte est de type GET et contient 'wsdl', on renvoie le contrat WSDL
     * du serveur SOAP.
     * Sinon on renvoie le document DISCO.
     */
    if ( isset($_SERVER['REQUEST_METHOD']) && $_SERVER['REQUEST_METHOD'] == 'POST' ) {
        $soap_srv->service( $GLOBALS['HTTP_RAW_POST_DATA'] );
    } else {
        require_once 'SOAP/Disco.php';
        $disco_srv =& new SOAP_Disco_Server( $soap_srv, $ressource_type );
        
        header('Content-type: text/xml');
        if (eregi("\?wsdl$", $_SERVER['REQUEST_URI'])) {
            echo $disco_srv->getWSDL();
        } else {
            echo $disco_srv->getDisco();
        }

        exit;
    }
}

?>