<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Antoine Angnieux <aangenieux@clever-age.com>                |
// +----------------------------------------------------------------------+
//
// Sub Implementation for handling spip-agora table prefixes of the SQLScript class
//

require_once(dirname(__FILE__).'/../SQLScript.php');

/**
 * SQLScript_spipagora is a helper class to execute
 * specially formatted SQL scripts. It allows handling
 * of spip-agora $table_prefix variable
 *
 * @auhthor Antoine Angnieux <aangenieux@clever-age.com>
 * @version 1.0
 */

class SQLScript_spipagora extends SQLScript {

	// {{{ properties

	/**
	 * _tablePrefix table prefix to be used for the spip-agora installation
	 * @var		String
	 * @access	private
	 */
	var $_tablePrefix;

	// {{{ constructor

	function SQLScript_spipagora($sqlFile, $fileType = BLOCKMODE) {
		if (!($fileType == BLOCKMODE || $fileType == LINEMODE)) {
			die("<br>Filetype specified is neither BLOCKMODE nor LINEMODE ! fileType = $fileType");
		}
		$this->_sqlFile = $sqlFile;
		$this->_fileType = $fileType;
	}

	// }}}

	// {{{ destructor

	function _SQLScript() {
		$this->_sqlFile = null;
	}

	// }}}

	// {{{ _executeQuery()

	/**
	 * Execute the passed query. Query processing is achieved based
	 * on the query mode passed.
	 * Dirty implementation based on copy/paste from SPIP original code
	 * @param	$db DB or MDB reference to an open connection
	 * @param	$query String representing the SQL query to execute	 
	 */

	function _executeQuery(&$dbInstance, $query) {

		$query = trim($query);
		$query = substr($query, 0, strlen($query) - 1);
		if ($GLOBALS['flag_pcre']) {
			if (preg_match('/\s(VALUES|WHERE)\s/i', $query, $regs)) {
				$suite = strstr($query, $regs[0]);
				$query = substr($query, 0, -strlen($suite));
			}
			$query = preg_replace('/([,\s])spip_/', '\1'.$db.$GLOBALS['table_prefix'].'_', $query) . $suite;
		}
		else {
			if (eregi('[[:space:]](VALUES|WHERE)[[:space:]]', $query, $regs)) {
				$suite = strstr($query, $regs[0]);
				$query = substr($query, 0, -strlen($suite));
			}
			$query = ereg_replace('([[:space:],])spip_', '\1'.$db.$GLOBALS['table_prefix'].'_', $query) . $suite;
		}
		return $dbInstance->query($query);		
	}

	// }}}


}

 ?>