[action]
CREATE TABLE spip_articles (
  id_article bigint(21) NOT NULL default '0',
  surtitre blob NOT NULL,
  titre blob NOT NULL,
  soustitre blob NOT NULL,
  id_rubrique bigint(21) NOT NULL default '0',
  descriptif blob NOT NULL,
  chapo blob NOT NULL,
  texte LONGBLOB NOT NULL,
  ps blob NOT NULL,
  date_heure varchar(19) NOT NULL default '0000-00-00 00:00:00',
  statut varchar(10) NOT NULL default '0',
  id_secteur bigint(21) NOT NULL default '0',
  maj varchar(19) default NULL,
  export varchar(10) default 'oui',
  date_redac varchar(19) NOT NULL default '0000-00-00 00:00:00',
  visites int(11) NOT NULL default '0',
  referers int(11) NOT NULL default '0',
  popularite double NOT NULL default '0',
  accepter_forum varchar(14) NOT NULL default '',
  auteur_modif bigint(21) NOT NULL default '0',
  date_modif varchar(19) NOT NULL default '0000-00-00 00:00:00',
  extra longblob NOT NULL,
  lang varchar(10) NOT NULL default '',
  langue_choisie char(3) NOT NULL default 'non',
  id_trad bigint(21) NOT NULL default '0',
  nom_site tinytext NOT NULL,
  url_site varchar(255) NOT NULL default '',
  version_id INT,
  activer_historique VARCHAR( 3 ) DEFAULT 'non' NOT NULL,
  date_expiration varchar(19) NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (id_article),
  KEY id_rubrique (id_rubrique),
  KEY id_secteur (id_secteur),
  KEY statut (statut,date_heure),
  KEY lang (lang),
  KEY id_trad (id_trad),
  KEY date_modif (date_modif),
  KEY url_site (url_site),
  KEY version_id (version_id),
  KEY date_heure (date_heure)
) TYPE=MyISAM;


[action]
CREATE TABLE spip_articles_historique (
  id_article_historique bigint(21) NOT NULL default '0',
  id_article bigint(21) NOT NULL default '0',
  id_auteur bigint(21) NOT NULL,
  surtitre blob NOT NULL,
  titre blob NOT NULL,
  soustitre blob NOT NULL,
  descriptif blob NOT NULL,
  chapo blob NOT NULL,
  texte longblob NOT NULL,
  ps blob NOT NULL,
  date_heure varchar(19) NOT NULL default '0000-00-00 00:00:00',
  extra longblob NOT NULL,
  nom_site TINYTEXT NOT NULL,
  url_site VARCHAR(255) NOT NULL,
  PRIMARY KEY  (id_article_historique),
  KEY statut (date_heure)
) TYPE=MyISAM;

[action]
CREATE TABLE spip_auteurs (
  id_auteur bigint(21) NOT NULL default '0',
  nom blob NOT NULL,
  bio blob NOT NULL,
  email blob NOT NULL,
  nom_site blob NOT NULL,
  url_site blob NOT NULL,
  login varchar(255) binary NOT NULL default '',
  pass blob NOT NULL,
  statut varchar(255) NOT NULL default '',
  profil bigint(20) NOT NULL default '0',
  maj varchar(19) default NULL,
  pgp blob NOT NULL,
  htpass blob NOT NULL,
  en_ligne varchar(19) NOT NULL default '0000-00-00 00:00:00',
  imessage varchar(4) NOT NULL default '',
  messagerie varchar(4) NOT NULL default '',
  alea_actuel blob NOT NULL,
  alea_futur blob NOT NULL,
  prefs blob NOT NULL,
  cookie_oubli blob NOT NULL,
  source varchar(10) NOT NULL default 'spip',
  lang varchar(20) default NULL,
  extra longblob NOT NULL,
  low_sec tinytext NOT NULL,
  PRIMARY KEY  (id_auteur),
  KEY login (login),
  KEY statut (statut),
  KEY en_ligne (en_ligne),
  KEY lang (lang)
) TYPE=MyISAM;


[action]
CREATE TABLE spip_auteurs_articles (
  id_auteur bigint(21) NOT NULL default '0',
  id_article bigint(21) NOT NULL default '0',
  KEY id_auteur (id_auteur),
  KEY id_article (id_article)
) TYPE=MyISAM;

[action]
CREATE TABLE spip_auteurs_messages (
  id_auteur bigint(21) NOT NULL default '0',
  id_message bigint(21) NOT NULL default '0',
  vu varchar(4) NOT NULL default '',
  KEY id_auteur (id_auteur),
  KEY id_message (id_message)
) TYPE=MyISAM;

[action]
CREATE TABLE spip_auteurs_rubriques (
  id_auteur bigint(21) NOT NULL default '0',
  id_rubrique bigint(21) NOT NULL default '0',
  KEY id_auteur (id_auteur),
  KEY id_rubrique (id_rubrique)
) TYPE=MyISAM;

[action]
CREATE TABLE spip_bookmarks (
  id_auteur bigint(21) NOT NULL default '0',
  id_objet bigint(21) NOT NULL default '0',
  type_bookmark varchar(8) NOT NULL default '',
  PRIMARY KEY  (id_auteur,id_objet,type_bookmark)
) TYPE=MyISAM;


[action]
CREATE TABLE spip_breves (
  id_breve bigint(21) NOT NULL default '0',
  date_heure varchar(19) NOT NULL default '',
  titre blob NOT NULL,
  texte blob NOT NULL,
  lien_titre blob NOT NULL,
  lien_url blob NOT NULL,
  statut varchar(6) NOT NULL default '',
  id_rubrique bigint(21) NOT NULL default '0',
  maj varchar(19) default NULL,
  extra longblob NOT NULL,
  lang varchar(10) NOT NULL default '',
  langue_choisie char(3) NOT NULL default 'non',
  PRIMARY KEY  (id_breve),
  KEY id_rubrique (id_rubrique)
) TYPE=MyISAM;


[action]
CREATE TABLE spip_cm_lists (
  lst_id int(11) NOT NULL default '0',
  lst_name varchar(255) NOT NULL default '',
  lst_comment text NOT NULL,
  lst_moderation varchar(10) NOT NULL default '',
  lst_moderator_email varchar(255) NOT NULL default '',
  lst_subscribe_subject varchar(255) NOT NULL default '',
  lst_subscribe_text text NOT NULL,
  lst_subject varchar(255) NOT NULL default '',
  lst_unsubscribe_subject varchar(255) NOT NULL default '',
  lst_unsubscribe_text text NOT NULL,
  lst_subject_tag tinyint(1) NOT NULL default '1',
  lst_html_skeleton varchar(200) NOT NULL default '',
  lst_text_skeleton varchar(200) NOT NULL default '',
  lst_nb_articles tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (lst_id),
  FULLTEXT KEY lst_name (lst_name)
) TYPE=MyISAM;

[action]
CREATE TABLE spip_cm_lists_subscribers (
  lst_id int(11) NOT NULL default '0',
  sub_id bigint(20) NOT NULL default '0',
  lsr_mode tinyint(1) NOT NULL default '0',
  lsr_id varchar(32) NOT NULL default '',
  PRIMARY KEY  (lst_id,sub_id),
  KEY lst_id (lst_id)
) TYPE=MyISAM;

[action]
CREATE TABLE spip_cm_pending (
  lst_id int(11) NOT NULL default '0',
  sub_id bigint(20) NOT NULL default '0',
  pnd_action varchar(15) NOT NULL default '',
  pnd_mode tinyint(1) NOT NULL default '0',
  pnd_action_date int(11) NOT NULL default '0',
  pnd_action_id varchar(32) NOT NULL default '',
  PRIMARY KEY  (lst_id,sub_id)
) TYPE=MyISAM;


[action]
CREATE TABLE spip_cm_posts (
  pst_id bigint(20) NOT NULL default '0',
  lst_id int(11) NOT NULL default '0',
  pst_date_create varchar(19) NOT NULL default '0000-00-00 00:00:00',
  pst_date_update varchar(19) NOT NULL default '0000-00-00 00:00:00',
  pst_date_sent varchar(19) NOT NULL default '0000-00-00 00:00:00',
  pst_subject varchar(255) NOT NULL default '',
  destinataires_specifiques blob,
  user_group_inactif blob,
  PRIMARY KEY  (pst_id)
) TYPE=MyISAM;


[action]
CREATE TABLE spip_cm_posts_articles (
  article_id bigint(20) unsigned NOT NULL default '0',
  pst_id bigint(20) NOT NULL default '0',
  art_order tinyint(3) unsigned NOT NULL default '0',
  KEY article_id (article_id),
  KEY pst_id (pst_id)
) TYPE=MyISAM COMMENT='Tables contenant les articles associes a un post de NL donne';


[action]
CREATE TABLE spip_cm_posts_done (
  pst_id bigint(20) NOT NULL default '0',
  id_auteur bigint(20) NOT NULL default '0',
  id_sub bigint(20) NOT NULL default '0',
  email varchar(255) NOT NULL default '',
  PRIMARY KEY  (pst_id,email)
) TYPE=MyISAM;

[action]
CREATE TABLE spip_cm_posts_links (
  lnk_id bigint(20) NOT NULL default '0',
  pst_id bigint(20) NOT NULL default '0',
  lnk_name varchar(255) NOT NULL default '',
  lnk_url text NOT NULL,
  PRIMARY KEY  (lnk_id)
) TYPE=MyISAM;

[action]
CREATE TABLE spip_cm_posts_queued (
  pst_id bigint(20) NOT NULL default '0',
  id_auteur bigint(20) NOT NULL default '0',
  id_sub bigint(20) NOT NULL default '0',
  email varchar(255) NOT NULL default '',
  sub_mode int(11) NOT NULL default '0',
  psq_date varchar(19) NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (pst_id,email)
) TYPE=MyISAM;


[action]
CREATE TABLE spip_cm_settings (
  set_name varchar(15) NOT NULL default '',
  set_value varchar(255) NOT NULL default '',
  PRIMARY KEY  (set_name)
) TYPE=MyISAM COMMENT='Application settings';


[action]
CREATE TABLE spip_cm_subscribers (
  sub_id bigint(20) NOT NULL default '0',
  sub_email varchar(255) NOT NULL default '',
  sub_first_name varchar(50) NOT NULL default '',
  sub_middle_name varchar(50) NOT NULL default '',
  sub_last_name varchar(50) NOT NULL default '',
  sub_title varchar(10) NOT NULL default '',
  sub_profile varchar(32) NOT NULL default '',
  PRIMARY KEY  (sub_id),
  KEY sub_profile (sub_profile),
  KEY sub_email (sub_email)
) TYPE=MyISAM;


[action]
CREATE TABLE spip_cm_user_groups (
  id_groupe bigint(21) NOT NULL default '0',
  lst_id bigint(21) default NULL,
  pst_id bigint(21) default NULL,
  titre varchar(255) default NULL,
  PRIMARY KEY  (id_groupe)
) TYPE=MyISAM;

[action]
CREATE TABLE spip_dernieres_visites (
  id_pers int(11) NOT NULL default '0',
  date_heure varchar(19) NOT NULL default '',
  url varchar(200) NOT NULL default '',
  titre varchar(100) NOT NULL default ''
) TYPE=MyISAM;

[action]
CREATE TABLE spip_documents (
  id_document bigint(21) NOT NULL default '0',
  id_vignette bigint(21) NOT NULL default '0',
  id_type bigint(21) NOT NULL default '0',
  titre blob NOT NULL,
  date_heure varchar(19) NOT NULL default '0000-00-00 00:00:00',
  descriptif blob NOT NULL,
  fichier varchar(255) NOT NULL default '',
  taille int(11) NOT NULL default '0',
  largeur int(11) NOT NULL default '0',
  hauteur int(11) NOT NULL default '0',
  mode_spip varchar(8) NOT NULL default 'vignette',
  inclus varchar(4) default 'non',
  maj varchar(19) default NULL,
  PRIMARY KEY  (id_document),
  KEY id_vignette (id_vignette),
  KEY mode (mode_spip),
  KEY id_type (id_type)
) TYPE=MyISAM;

[action]
CREATE TABLE spip_documents_articles (
  id_document bigint(21) NOT NULL default '0',
  id_article bigint(21) NOT NULL default '0',
  KEY id_document (id_document),
  KEY id_article (id_article)
) TYPE=MyISAM;


[action]
CREATE TABLE spip_documents_breves (
  id_document bigint(21) NOT NULL default '0',
  id_breve bigint(21) NOT NULL default '0',
  KEY id_document (id_document),
  KEY id_breve (id_breve)
) TYPE=MyISAM;


[action]
CREATE TABLE spip_documents_rubriques (
  id_document bigint(21) NOT NULL default '0',
  id_rubrique bigint(21) NOT NULL default '0',
  KEY id_document (id_document),
  KEY id_rubrique (id_rubrique)
) TYPE=MyISAM;


[action]
CREATE TABLE spip_forum (
  id_forum bigint(21) NOT NULL default '0',
  id_parent bigint(21) NOT NULL default '0',
  id_rubrique bigint(21) NOT NULL default '0',
  id_article bigint(21) NOT NULL default '0',
  id_breve bigint(21) NOT NULL default '0',
  date_heure varchar(19) NOT NULL default '0000-00-00 00:00:00',
  titre blob NOT NULL,
  texte blob NOT NULL,
  auteur blob NOT NULL,
  email_auteur blob NOT NULL,
  nom_site blob NOT NULL,
  url_site blob NOT NULL,
  statut varchar(8) NOT NULL default '',
  ip varchar(16) default NULL,
  maj varchar(19) default NULL,
  id_auteur bigint(20) NOT NULL default '0',
  id_message bigint(21) NOT NULL default '0',
  id_syndic bigint(21) NOT NULL default '0',
  profil_auteur int(11) default '0',
  alerte_mail varchar(4) NOT NULL default 'oui',
  PRIMARY KEY  (id_forum),
  KEY id_parent (id_parent),
  KEY id_rubrique (id_rubrique),
  KEY id_article (id_article),
  KEY id_breve (id_breve),
  KEY id_message (id_message),
  KEY statut (statut,date_heure)
) TYPE=MyISAM;

[action]
CREATE TABLE spip_forum_cache (
  id_forum bigint(21) NOT NULL default '0',
  id_rubrique bigint(21) NOT NULL default '0',
  id_article bigint(21) NOT NULL default '0',
  id_breve bigint(21) NOT NULL default '0',
  id_syndic bigint(21) NOT NULL default '0',
  fichier varchar(150) binary NOT NULL default '',
  maj varchar(19) default NULL,
  PRIMARY KEY  (fichier,id_forum,id_article,id_rubrique,id_breve,id_syndic),
  KEY id_forum (id_forum),
  KEY id_rubrique (id_rubrique),
  KEY id_article (id_article),
  KEY id_syndic (id_syndic),
  KEY id_breve (id_breve)
) TYPE=MyISAM;

[action]
CREATE TABLE spip_groupes_mots (
  id_groupe bigint(21) NOT NULL default '0',
  titre blob NOT NULL,
  unseul varchar(4) NOT NULL default '',
  obligatoire varchar(4) NOT NULL default '',
  articles varchar(4) NOT NULL default '',
  breves varchar(4) NOT NULL default '',
  rubriques varchar(4) NOT NULL default '',
  syndic varchar(4) NOT NULL default '',
  auteurs varchar(4) NOT NULL default '',
  forum varchar(4) NOT NULL default '',
  cm varchar(4) NOT NULL default '',
  maj varchar(19) default NULL,
  profils int(11) NOT NULL default '0',
  PRIMARY KEY  (id_groupe)
) TYPE=MyISAM;

[action]
CREATE TABLE spip_index_articles (
  hash varchar(255) NOT NULL default '0',
  points int(10) unsigned NOT NULL default '0',
  id_article int(10) unsigned NOT NULL default '0',
  emplacement varchar(50),
  KEY emplacement (emplacement),
  KEY hash (hash),
  KEY id_article (id_article)
) TYPE=MyISAM;

[action]
CREATE TABLE spip_index_auteurs (
  hash varchar(255) NOT NULL default '0',
  points int(10) unsigned NOT NULL default '0',
  id_auteur int(10) unsigned NOT NULL default '0',
    emplacement varchar(50),
  KEY emplacement (emplacement),
  KEY hash (hash),
  KEY id_auteur (id_auteur)
) TYPE=MyISAM;

[action]
CREATE TABLE spip_index_breves (
  hash varchar(255) NOT NULL default '0',
  points int(10) unsigned NOT NULL default '0',
  id_breve int(10) unsigned NOT NULL default '0',
    emplacement varchar(50),
  KEY emplacement (emplacement),
  KEY hash (hash),
  KEY id_breve (id_breve)
) TYPE=MyISAM;

[action]
CREATE TABLE spip_index_dico (
  hash varchar(255) NOT NULL default '0',
  dico varchar(30) NOT NULL default '',
  PRIMARY KEY  (dico)
) TYPE=MyISAM;

[action]
CREATE TABLE spip_index_mots (
  hash varchar(255) NOT NULL default '0',
  points int(10) unsigned NOT NULL default '0',
  id_mot int(10) unsigned NOT NULL default '0',
    emplacement varchar(50),
  KEY emplacement (emplacement),
  KEY hash (hash),
  KEY id_mot (id_mot)
) TYPE=MyISAM;


[action]
CREATE TABLE spip_index_rubriques (
  hash varchar(255) NOT NULL default '0',
  points int(10) unsigned NOT NULL default '0',
  id_rubrique int(10) unsigned NOT NULL default '0',
    emplacement varchar(50),
  KEY emplacement (emplacement),
  KEY hash (hash),
  KEY id_rubrique (id_rubrique)
) TYPE=MyISAM;

[action]
CREATE TABLE spip_index_syndic (
  hash varchar(255) NOT NULL default '0',
  points int(10) unsigned NOT NULL default '0',
  id_syndic int(10) unsigned NOT NULL default '0',
    emplacement varchar(50),
  KEY emplacement (emplacement),
  KEY hash (hash),
  KEY id_syndic (id_syndic)
) TYPE=MyISAM;


[action]
CREATE TABLE spip_liens (
  contenant varchar(10) NOT NULL default '',
  lien_interne varchar(10) NOT NULL default '',
  lien_externe varchar(255) NOT NULL default '',
  PRIMARY KEY  (contenant,lien_interne,lien_externe)
) TYPE=MyISAM;

[action]
CREATE TABLE spip_lock_mots (
  lockID varchar(100) NOT NULL default '',
  lockTable varchar(100) NOT NULL default '',
  lockStamp varchar(100) NOT NULL default '',
  PRIMARY KEY  (lockID)
) TYPE=MyISAM COMMENT='Locks pour utilisation des NestedSet sur les mots cl�';

[action]
CREATE TABLE spip_messages (
  id_message bigint(21) NOT NULL default '0',
  titre blob NOT NULL,
  texte blob NOT NULL,
  type varchar(6) NOT NULL default '',
  date_heure varchar(19) NOT NULL default '0000-00-00 00:00:00',
  rv varchar(4) NOT NULL default '',
  statut varchar(6) NOT NULL default '',
  id_auteur bigint(21) NOT NULL default '0',
  maj varchar(19) default NULL,
  date_fin varchar(19) NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (id_message),
  KEY id_auteur (id_auteur)
) TYPE=MyISAM;

[action]
CREATE TABLE spip_meta (
  nom varchar(255) NOT NULL default '',
  valeur varchar(255) default '',
  maj varchar(19) default NULL,
  PRIMARY KEY  (nom)
) TYPE=MyISAM;

[action]
CREATE TABLE spip_mots (
  id_mot bigint(21) NOT NULL default '0',
  id_root bigint(21) unsigned NOT NULL default '0',
  l bigint(20) unsigned default NULL,
  r bigint(20) unsigned default NULL,
  streh bigint(20) unsigned default NULL,
  level_mot bigint(20) unsigned default NULL,
  strna varchar(100) default NULL,
  type_mot varchar(100) NOT NULL default '',
  titre blob NOT NULL,
  descriptif blob NOT NULL,
  texte blob NOT NULL,
  id_groupe bigint(21) NOT NULL default '0',
  maj varchar(19) default NULL,
  extra longblob NOT NULL,
  PRIMARY KEY  (id_mot),
  KEY type (type_mot),
  KEY id_root (id_root),
  KEY l (l),
  KEY r (r),
  KEY streh (streh),
  KEY level (level_mot)
) TYPE=MyISAM;

[action]
CREATE TABLE spip_mots_articles (
  id_mot bigint(21) NOT NULL default '0',
  id_article bigint(21) NOT NULL default '0',
  KEY id_mot (id_mot),
  KEY id_article (id_article)
) TYPE=MyISAM;

[action]
CREATE TABLE spip_mots_auteurs (
  id_mot bigint(20) unsigned NOT NULL default '0',
  id_auteur bigint(20) unsigned NOT NULL default '0',
  KEY id_mot (id_mot),
  KEY id_auteur (id_auteur)
) TYPE=MyISAM;

[action]
CREATE TABLE spip_mots_breves (
  id_mot bigint(21) NOT NULL default '0',
  id_breve bigint(21) NOT NULL default '0',
  KEY id_mot (id_mot),
  KEY id_breve (id_breve)
) TYPE=MyISAM;

[action]
CREATE TABLE spip_mots_cm (
  id_mot bigint(21) NOT NULL default '0',
  id_groupe bigint(21) NOT NULL default '0'
) TYPE=MyISAM;

[action]
CREATE TABLE spip_mots_forum (
  id_mot bigint(21) NOT NULL default '0',
  id_forum bigint(21) NOT NULL default '0',
  KEY id_mot (id_mot),
  KEY id_forum (id_forum)
) TYPE=MyISAM;

[action]
CREATE TABLE spip_mots_rubriques (
  id_mot bigint(21) NOT NULL default '0',
  id_rubrique bigint(21) NOT NULL default '0',
  KEY id_mot (id_mot),
  KEY id_rubrique (id_rubrique)
) TYPE=MyISAM;

[action]
CREATE TABLE spip_mots_syndic (
  id_mot bigint(21) NOT NULL default '0',
  id_syndic bigint(21) NOT NULL default '0',
  KEY id_mot (id_mot),
  KEY id_syndic (id_syndic)
) TYPE=MyISAM;

[action]
CREATE TABLE spip_petitions (
  id_article bigint(21) NOT NULL default '0',
  email_unique varchar(4) NOT NULL default '',
  site_obli varchar(4) NOT NULL default '',
  site_unique varchar(4) NOT NULL default '',
  message varchar(4) NOT NULL default '',
  texte blob NOT NULL,
  maj varchar(19) default NULL,
  PRIMARY KEY  (id_article)
) TYPE=MyISAM;

[action]
CREATE TABLE spip_profils (
  poids int(11) NOT NULL default '0',
  intitule varchar(255) NOT NULL default '',
  PRIMARY KEY  (poids)
) TYPE=MyISAM;

[action]
CREATE TABLE spip_referers (
  referer_md5 varchar(255) NOT NULL default '0',
  date_heure varchar(19) NOT NULL default '0000-00-00 00:00:00',
  referer varchar(255) NOT NULL default '',
  visites int(10) unsigned NOT NULL default '0',
  visites_jour int(10) unsigned NOT NULL default '0',
  maj varchar(19) default NULL,
  PRIMARY KEY  (referer_md5),
  FULLTEXT KEY maj (maj),
  FULLTEXT KEY maj_2 (maj)
) TYPE=MyISAM;

[action]
CREATE TABLE spip_referers_articles (
  id_article int(10) unsigned NOT NULL default '0',
  referer_md5 varchar(255) NOT NULL default '0',
  date_heure varchar(19) NOT NULL default '0000-00-00 00:00:00',
  referer varchar(255) NOT NULL default '',
  visites int(10) unsigned NOT NULL default '0',
  maj varchar(19) default NULL,
  PRIMARY KEY  (id_article,referer_md5),
  KEY referer_md5 (referer_md5)
) TYPE=MyISAM;

[action]
CREATE TABLE spip_referers_temp (
  ip varchar(15) NOT NULL default '0.0.0.0',
  referer varchar(255) NOT NULL default '',
  referer_md5 varchar(255) NOT NULL default '0',
  type_referer varchar(8) NOT NULL default 'article',
  id_objet int(10) unsigned NOT NULL default '0',
  maj varchar(19) default NULL,
  PRIMARY KEY  (type_referer,id_objet,referer_md5,ip)
) TYPE=MyISAM;

[action]
CREATE TABLE spip_rubriques (
  id_rubrique bigint(21) NOT NULL default '0',
  id_parent bigint(21) NOT NULL default '0',
  titre blob NOT NULL,
  descriptif blob NOT NULL,
  texte blob NOT NULL,
  id_secteur bigint(21) NOT NULL default '0',
  maj varchar(19) default NULL,
  export varchar(10) default 'oui',
  id_import bigint(20) default '0',
  statut varchar(10) NOT NULL default '',
  date_heure varchar(19) NOT NULL default '0000-00-00 00:00:00',
  extra longblob NOT NULL,
  lang varchar(10) NOT NULL default '',
  langue_choisie char(3) NOT NULL default 'non',
  PRIMARY KEY  (id_rubrique),
  KEY id_parent (id_parent),
  KEY lang (lang)
) TYPE=MyISAM;

[action]
CREATE TABLE spip_signatures (
  id_signature bigint(21) NOT NULL default '0',
  id_article bigint(21) NOT NULL default '0',
  date_time varchar(19) NOT NULL default '0000-00-00 00:00:00',
  nom_email blob NOT NULL,
  ad_email blob NOT NULL,
  nom_site blob NOT NULL,
  url_site blob NOT NULL,
  message blob NOT NULL,
  statut varchar(10) NOT NULL default '',
  maj varchar(19) default NULL,
  PRIMARY KEY  (id_signature),
  KEY id_article (id_article),
  KEY statut (statut)
) TYPE=MyISAM;

[action]
CREATE TABLE spip_sondages (
  id_article bigint(20) NOT NULL default '0',
  actif char(3) NOT NULL default 'oui',
  affichage_public char(3) NOT NULL default 'non',
  PRIMARY KEY  (id_article)
) TYPE=MyISAM;

[action]
CREATE TABLE spip_sondages_reponses (
  id_article bigint(20) NOT NULL default '0',
  id_reponse bigint(20) NOT NULL default '0',
  texte_reponse varchar(255) NOT NULL default '',
  votes int(11) NOT NULL default '0',
  PRIMARY KEY  (id_article,id_reponse)
) TYPE=MyISAM;

[action]
CREATE TABLE spip_sondages_votes (
  id_article bigint(20) NOT NULL default '0',
  email_votant varchar(255) NOT NULL default '',
  date_time varchar(19) NOT NULL default '0000-00-00 00:00:00',
  id_reponse bigint(20) NOT NULL default '0',
  statut varchar(10) NOT NULL default '',
  PRIMARY KEY  (id_article,email_votant)
) TYPE=MyISAM;

[action]
CREATE TABLE spip_syndic (
  id_syndic bigint(21) NOT NULL default '0',
  id_rubrique bigint(21) NOT NULL default '0',
  id_secteur bigint(21) NOT NULL default '0',
  nom_site blob NOT NULL,
  url_site blob NOT NULL,
  url_syndic blob NOT NULL,
  descriptif blob NOT NULL,
  maj varchar(19) default NULL,
  syndication varchar(4) NOT NULL default '',
  statut varchar(10) NOT NULL default '',
  date_heure varchar(19) NOT NULL default '0000-00-00 00:00:00',
  date_syndic varchar(19) NOT NULL default '0000-00-00 00:00:00',
  date_index varchar(19) NOT NULL default '0000-00-00 00:00:00',
  moderation varchar(4) NOT NULL default '',
  PRIMARY KEY  (id_syndic),
  KEY id_rubrique (id_rubrique),
  KEY id_secteur (id_secteur),
  KEY statut (statut,date_syndic)
) TYPE=MyISAM;

[action]
CREATE TABLE spip_syndic_articles (
  id_syndic_article bigint(21) NOT NULL default '0',
  id_syndic bigint(21) NOT NULL default '0',
  titre blob NOT NULL,
  url varchar(255) NOT NULL default '',
  date_heure varchar(19) NOT NULL default '0000-00-00 00:00:00',
  lesauteurs blob NOT NULL,
  maj varchar(19) default NULL,
  statut varchar(10) NOT NULL default '',
  descriptif blob NOT NULL,
  PRIMARY KEY  (id_syndic_article),
  KEY id_syndic (id_syndic),
  KEY statut (statut),
  KEY url (url)
) TYPE=MyISAM;

[action]
CREATE TABLE spip_types_documents (
  id_type bigint(21) NOT NULL default '0',
  titre blob NOT NULL,
  descriptif blob NOT NULL,
  extension varchar(10) NOT NULL default '',
  mime_type varchar(100) NOT NULL default '',
  inclus varchar(5) NOT NULL default 'non',
  upload varchar(4) NOT NULL default 'oui',
  maj varchar(19) default NULL,
  PRIMARY KEY  (id_type),
  UNIQUE KEY extension (extension),
  KEY inclus (inclus)
) TYPE=MyISAM;

[action]
CREATE TABLE spip_visites (
  date_heure varchar(19) NOT NULL default '0000-00-00 00:00:00',
  visites int(10) unsigned NOT NULL default '0',
  maj varchar(19) default NULL,
  PRIMARY KEY  (date_heure)
) TYPE=MyISAM;

[action]
CREATE TABLE spip_visites_articles (
  date_heure varchar(19) NOT NULL default '0000-00-00 00:00:00',
  id_article int(10) unsigned NOT NULL default '0',
  visites int(10) unsigned NOT NULL default '0',
  maj varchar(19) default NULL,
  PRIMARY KEY  (date_heure,id_article)
) TYPE=MyISAM;

[action]
CREATE TABLE spip_visites_temp (
  ip varchar(15) NOT NULL default '0.0.0.0',
  type varchar(8) NOT NULL default 'article',
  id_objet int(10) unsigned NOT NULL default '0',
  maj varchar(19) default NULL,
  PRIMARY KEY  (type,id_objet,ip)
) TYPE=MyISAM;

[action]
CREATE TABLE spip_glossaire (
  id int(11) NOT NULL,
  mot varchar(50) NOT NULL default '',
  url varchar(255) NOT NULL default '',
  PRIMARY KEY id (id)
) TYPE=MyISAM;

[action]
CREATE TABLE spip_index_documents (
  hash varchar(255) NOT NULL default '0',
  points int(10) unsigned NOT NULL default '0',
  id_document int(10) unsigned NOT NULL default '0',
  emplacement varchar(50) default NULL,
  KEY hash (hash),
  KEY id_document (id_document),
  KEY emplacement (emplacement)
) TYPE=MyISAM; 

[action]
CREATE TABLE spip_articles_mapping (
  id bigint(20) NOT NULL ,
  id_map bigint(20) NOT NULL default '0',
  id_article bigint(20) NOT NULL default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;

[action]
CREATE TABLE spip_module (
  nom varchar(50) NOT NULL default '',
  date_install varchar(50) NOT NULL default '',
  version varchar(10) NOT NULL default '',
  author varchar(50) NOT NULL default '',
  PRIMARY KEY  (nom)
) TYPE=MyISAM;
