[action]
CREATE TABLE spip_articles (
  id_article number primary key,
  surtitre VARCHAR2(255) NULL,
  titre VARCHAR2(255) NULL,
  soustitre VARCHAR2(255) NULL,
  id_rubrique number NOT NULL ,
  descriptif VARCHAR2(255) NULL,
  chapo VARCHAR2(255) NULL,
  texte CLOB NULL,
  ps VARCHAR2(255) NULL,
  date_heure varchar(19) default '0000-00-00 00:00:00' NOT NULL ,
  statut varchar(10) NOT NULL ,
  id_secteur number NOT NULL ,
  maj varchar(19) NULL,
  export varchar(10) default 'oui',
  date_redac varchar2(19) default '0000-00-00 00:00:00' NOT NULL ,
  visites number NULL ,
  referers number NULL ,
  popularite number  NULL ,
  accepter_forum varchar2(14) NULL ,
  auteur_modif number NULL ,
  date_modif varchar2(19) default '0000-00-00 00:00:00' NULL ,
  extra CLOB NULL,
  lang varchar2(10) NOT NULL ,
  langue_choisie varchar2(4) default 'non' NOT NULL ,
  id_trad number NULL ,
  nom_site varchar2(255) NULL,
  url_site varchar2(255) NULL ,
  version_id INTEGER,
  activer_historique varchar2( 3 )  NULL,
  date_expiration varchar2(19) default '0000-00-00 00:00:00' NULL 
) ;
[action]
create index id_rubrique ON spip_articles (id_rubrique);
[action]
create index id_secteur ON spip_articles (id_secteur);
[action]
create index statut ON spip_articles (statut,date_heure);
[action]
create index lang ON spip_articles (lang);
[action]
create index id_trad ON spip_articles (id_trad);
[action]
create index date_modif ON spip_articles (date_modif);
[action]
create index url_site ON spip_articles (url_site);
[action]
create index version_id ON spip_articles (version_id);
[action]
create index date_heure ON spip_articles (date_heure);

[action]
CREATE TABLE spip_articles_historique (
  id_article_historique number PRIMARY KEY ,
  id_article number NOT NULL ,
  id_auteur number NOT NULL,
  surtitre VARCHAR2(255)  NULL,
  titre VARCHAR2(255) NOT NULL,
  soustitre VARCHAR2(255)  NULL,
  descriptif VARCHAR2(255)  NULL,
  chapo VARCHAR2(255)  NULL,
  texte CLOB  NULL,
  ps VARCHAR2(255)  NULL,
  date_heure varchar2(19) NOT NULL ,
  extra CLOB  NULL,
  nom_site varchar2(255)  NULL,
  url_site varchar2(255)  NULL
) ;

[action]
CREATE TABLE spip_auteurs (
  id_auteur number PRIMARY KEY ,
  nom VARCHAR2(255)  NULL,
  bio VARCHAR2(255)  NULL,
  email VARCHAR2(255)  NULL,
  nom_site VARCHAR2(255)  NULL,
  url_site VARCHAR2(255)  NULL,
  login varchar2(255)   NULL ,
  pass varchar2(255) NULL,
  statut varchar2(255)  NULL ,
  profil INTEGER  NULL ,
  maj varchar2(19) NULL,
  pgp VARCHAR2(255)  NULL,
  htpass varchar2(255)  NULL,
  en_ligne varchar2(19)  NULL ,
  imessage varchar2(4)  NULL ,
  messagerie varchar2(4)  NULL ,
  alea_actuel varchar2(255)  NULL,
  alea_futur varchar2(255)  NULL,
  prefs varchar2(255)  NULL,
  cookie_oubli varchar2(255)  NULL,
  source varchar2(10)  NULL,
  lang varchar2(20) NULL,
  extra CLOB  NULL,
  low_sec varchar2(255)  NULL
) ;
[action]
create index auteurs_login ON spip_auteurs (login);
[action]
create index auteurs_statut ON spip_auteurs (statut);
[action]
create index auteurs_en_ligne ON spip_auteurs (en_ligne);
[action]
create index auteurs_lang ON spip_auteurs (lang);

[action]
CREATE TABLE spip_auteurs_articles (
  id_auteur number NOT NULL ,
  id_article number NOT NULL 
) ;
[action]
create index auteurs_articles_id_auteur ON spip_auteurs_articles (id_auteur);
[action]
create index auteurs_articles_id_article ON spip_auteurs_articles (id_article);

[action]
CREATE TABLE spip_auteurs_messages (
  id_auteur number NOT NULL ,
  id_message number NOT NULL ,
  vu varchar2(4) NOT NULL 
) ;
[action]
create index a_messages_id_auteur ON spip_auteurs_messages (id_auteur);
[action]
create index a_messages_id_message ON spip_auteurs_messages (id_message);

[action]
CREATE TABLE spip_auteurs_rubriques (
  id_auteur number NOT NULL ,
  id_rubrique number NOT NULL 
) ;
[action]
create index a_rubriques_id_auteur ON spip_auteurs_rubriques (id_auteur);
[action]
create index a_rubriques_id_rubrique ON spip_auteurs_rubriques (id_rubrique);

[action]
CREATE TABLE spip_bookmarks (
  id_auteur number NOT NULL ,
  id_objet number NOT NULL ,
  type_bookmark varchar2(8) NOT NULL ,
  CONSTRAINT spip_bokmark_pk PRIMARY KEY (id_auteur,id_objet,type_bookmark)
) ;

[action]
CREATE TABLE spip_breves (
  id_breve number PRIMARY KEY ,
  date_heure varchar2(19) NOT NULL ,
  titre VARCHAR2(255) NOT NULL,
  texte CLOB  NULL,
  lien_titre VARCHAR2(255)  NULL,
  lien_url VARCHAR2(255) NULL,
  statut varchar2(6) NOT NULL ,
  id_rubrique number NOT NULL ,
  maj varchar2(19) NULL,
  extra CLOB  NULL,
  lang varchar2(10) NOT NULL ,
  langue_choisie varchar2(4) NOT NULL 
) ;
[action]
create index breves_id_rubrique ON spip_breves (id_rubrique);

[action]
CREATE TABLE spip_cm_lists (
  lst_id number PRIMARY KEY ,
  lst_name varchar2(255) NOT NULL ,
  lst_comment CLOB  NULL,
  lst_moderation varchar2(10) NOT NULL ,
  lst_moderator_email varchar2(255)  NULL ,
  lst_subscribe_subject varchar2(255)  NULL ,
  lst_subscribe_text CLOB  NULL,
  lst_subject varchar2(255)  NULL ,
  lst_unsubscribe_subject varchar2(255)  NULL ,
  lst_unsubscribe_text CLOB  NULL,
  lst_subject_tag INTEGER  NULL,
  lst_html_skeleton varchar2(200)  NULL ,
  lst_text_skeleton varchar2(200)  NULL ,
  lst_nb_articles INTEGER  NULL 
) ;

[action]
CREATE TABLE spip_cm_lists_subscribers (
  lst_id number NOT NULL ,
  sub_id INTEGER NOT NULL ,
  lsr_mode INTEGER NOT NULL ,
  lsr_id varchar2(32) NOT NULL ,
  CONSTRAINT spip_cm_lists_subscribers_pk PRIMARY KEY (lst_id,sub_id)
) ;
[action]
create index cm_lst_id ON spip_cm_lists_subscribers (lst_id);

[action]
CREATE TABLE spip_cm_pending (
  lst_id number NOT NULL ,
  sub_id INTEGER NOT NULL ,
  pnd_action varchar2(15)  NULL ,
  pnd_mode INTEGER NULL ,
  pnd_action_date number  NULL ,
  pnd_action_id varchar2(32)  NULL ,
  CONSTRAINT spip_cm_pending_pk PRIMARY KEY  (lst_id,sub_id)
) ;


[action]
CREATE TABLE spip_cm_posts (
  pst_id INTEGER PRIMARY KEY ,
  lst_id number NOT NULL ,
  pst_date_create varchar2(19)  default '0000-00-00 00:00:00' NULL ,
  pst_date_update varchar2(19)  default '0000-00-00 00:00:00' NULL ,
  pst_date_sent varchar2(19)  default '0000-00-00 00:00:00' NULL  ,
  pst_subject varchar2(255)  NULL ,
  destinataires_specifiques CLOB,
  user_group_inactif CLOB
) ;


[action]
CREATE TABLE spip_cm_posts_articles (
  article_id INTEGER  NOT NULL ,
  pst_id INTEGER NOT NULL ,
  art_order INTEGER  NULL 
) ;
[action]
create index cm_p_a_article_id ON spip_cm_posts_articles (article_id);
[action]
create index cm_p_a_pst_id ON spip_cm_posts_articles (pst_id);

[action]
CREATE TABLE spip_cm_posts_done (
  pst_id INTEGER NOT NULL ,
  id_auteur INTEGER  NULL ,
  id_sub INTEGER  NULL ,
  email varchar2(255) NOT NULL ,
  CONSTRAINT spip_cm_posts_done_pk PRIMARY KEY  (pst_id,email)
) ;

[action]
CREATE TABLE spip_cm_posts_links (
  lnk_id INTEGER PRIMARY KEY ,
  pst_id INTEGER NOT NULL ,
  lnk_name varchar2(255) NULL ,
  lnk_url CLOB NULL
) ;

[action]
CREATE TABLE spip_cm_posts_queued (
  pst_id INTEGER NOT NULL ,
  id_auteur INTEGER  NULL ,
  id_sub INTEGER  NULL ,
  email varchar2(255) NOT NULL ,
  sub_mode INTEGER  NULL ,
  psq_date varchar2(19)  NULL ,
  CONSTRAINT spip_cm_posts_queued_pk PRIMARY KEY  (pst_id,email)
) ;


[action]
CREATE TABLE spip_cm_settings (
  set_name varchar2(15) PRIMARY KEY ,
  set_value varchar2(255)  NULL 
) ;


[action]
CREATE TABLE spip_cm_subscribers (
  sub_id INTEGER  PRIMARY KEY  ,
  sub_email varchar2(255) NOT NULL ,
  sub_first_name varchar2(50)  NULL ,
  sub_middle_name varchar2(50)  NULL ,
  sub_last_name varchar2(50)  NULL ,
  sub_title varchar2(10)  NULL ,
  sub_profile varchar2(32) NULL
) ;
[action]
create index cm_s_sub_profile ON spip_cm_subscribers (sub_profile);
[action]
create index cm_s_sub_email ON spip_cm_subscribers (sub_email);

[action]
CREATE TABLE spip_cm_user_groups (
  id_groupe number PRIMARY KEY ,
  lst_id number NULL,
  pst_id number NULL,
  titre varchar2(255) NULL
) ;

[action]
CREATE TABLE spip_dernieres_visites (
  id_pers number NOT NULL ,
  date_heure varchar2(19) NOT NULL ,
  url varchar2(200)  NULL ,
  titre varchar2(100)  NULL 
) ;

[action]
CREATE TABLE spip_documents (
  id_document number PRIMARY KEY ,
  id_vignette number  NULL ,
  id_type number  NULL ,
  titre VARCHAR2(255)  NULL,
  date_heure varchar2(19)  NULL ,
  descriptif CLOB  NULL,
  fichier varchar2(255)  NULL ,
  taille number  NULL ,
  largeur number  NULL ,
  hauteur number  NULL ,
  mode_spip varchar2(8)  NULL,
  inclus varchar2(4) ,
  maj varchar2(19) NULL
) ;
[action]
create index documents_id_vignette ON spip_documents (id_vignette);
[action]
create index documents_mode_spip ON spip_documents (mode_spip);
[action]
create index documents_id_type ON spip_documents (id_type);

[action]
CREATE TABLE spip_documents_articles (
  id_document number NOT NULL ,
  id_article number NOT NULL 
) ;
[action]
create index documents_articles_id_document ON spip_documents_articles (id_document);
[action]
create index documents_articles_id_article ON spip_documents_articles (id_article);


[action]
CREATE TABLE spip_documents_breves (
  id_document number NOT NULL ,
  id_breve number NOT NULL 
) ;
[action]
create index documents_breves_id_document ON spip_documents_breves (id_document);
[action]
create index documents_breves_id_breve ON spip_documents_breves (id_breve);

[action]
CREATE TABLE spip_documents_rubriques (
  id_document number NOT NULL ,
  id_rubrique number NOT NULL 
) ;
[action]
create index docd_id_document ON spip_documents_rubriques (id_document);
[action]
create index docr_id_rubrique ON spip_documents_rubriques (id_rubrique);

[action]
CREATE TABLE spip_forum (
  id_forum number PRIMARY KEY ,
  id_parent number NOT NULL ,
  id_rubrique number NOT NULL ,
  id_article number  NULL ,
  id_breve number  NULL ,
  date_heure varchar2(19)  NULL ,
  titre VARCHAR2(255)  NULL,
  texte CLOB  NULL,
  auteur VARCHAR2(255)  NULL,
  email_auteur VARCHAR2(255)  NULL,
  nom_site VARCHAR2(255)  NULL,
  url_site VARCHAR2(255)  NULL,
  statut varchar2(8)  NULL ,
  ip varchar2(16) NULL,
  maj varchar2(19) NULL,
  id_auteur INTEGER  NULL ,
  id_message number  NULL ,
  id_syndic number  NULL ,
  profil_auteur number ,
  alerte_mail varchar2(4) NOT NULL
) ;
[action]
create index forum_id_parent ON spip_forum (id_parent);
[action]
create index forum_id_rubrique ON spip_forum (id_rubrique);
[action]
create index forum_id_article ON spip_forum (id_article);
[action]
create index forum_id_breve ON spip_forum (id_breve);
[action]
create index forum_id_message ON spip_forum (id_message);
[action]
create index forum_statut ON spip_forum (statut,date_heure);

[action]
CREATE TABLE spip_forum_cache (
  id_forum number NOT NULL ,
  id_rubrique number NOT NULL ,
  id_article number  NULL ,
  id_breve number  NULL ,
  id_syndic number  NULL ,
  fichier varchar2(150)   NULL ,
  maj varchar2(19) NULL,
  CONSTRAINT spip_forum_cache_pk PRIMARY KEY  (fichier,id_forum,id_article,id_rubrique,id_breve,id_syndic)
) ;
[action]
create index forum_c_id_forum ON spip_forum_cache (id_forum);
[action]
create index forum_c_id_rubrique ON spip_forum_cache (id_rubrique);
[action]
create index forum_c_id_article ON spip_forum_cache (id_article);
[action]
create index forum_c_id_syndic ON spip_forum_cache (id_syndic);
[action]
create index forum_c_id_breve ON spip_forum_cache (id_breve);

[action]
CREATE TABLE spip_groupes_mots (
  id_groupe number PRIMARY KEY ,
  titre VARCHAR2(255) NOT NULL,
  unseul varchar2(4)  NULL ,
  obligatoire varchar2(4)  NULL ,
  articles varchar2(4)  NULL ,
  breves varchar2(4)  NULL ,
  rubriques varchar2(4)  NULL ,
  syndic varchar2(4)  NULL ,
  auteurs varchar2(4)  NULL ,
  forum varchar2(4)  NULL ,
  cm varchar2(4)  NULL ,
  maj varchar2(19) NULL,
  profils number NULL 
) ;

[action]
CREATE TABLE spip_index_articles (
  hash varchar2(255) NOT NULL ,
  points INTEGER  NOT NULL ,
  id_article number  NOT NULL ,
  emplacement varchar2(50)
) ;
[action]
create index index_a_emplacement ON spip_index_articles (emplacement);
[action]
create index index_a_hash ON spip_index_articles (hash);
[action]
create index index_a_id_article ON spip_index_articles (id_article);

[action]
CREATE TABLE spip_index_auteurs (
  hash varchar2(255) NOT NULL ,
  points INTEGER  NOT NULL ,
  id_auteur INTEGER  NOT NULL ,
  emplacement varchar2(50)
) ;
[action]
create index index_au_emplacement ON spip_index_auteurs (emplacement);
[action]
create index index_au_hash ON spip_index_auteurs (hash);
[action]
create index index_au_id_auteur ON spip_index_auteurs (id_auteur);

[action]
CREATE TABLE spip_index_breves (
  hash varchar2(255) NOT NULL ,
  points INTEGER  NOT NULL ,
  id_breve INTEGER  NOT NULL ,
  emplacement varchar2(50)
) ;
[action]
create index index_b_emplacement ON spip_index_breves (emplacement);
[action]
create index index_b_hash ON spip_index_breves (hash);
[action]
create index index_b_id_breve ON spip_index_breves (id_breve);


[action]
CREATE TABLE spip_index_dico (
  hash varchar2(255) NOT NULL ,
  dico varchar2(30) PRIMARY KEY 
) ;

[action]
CREATE TABLE spip_index_mots (
  hash varchar2(255) NOT NULL ,
  points INTEGER  NOT NULL ,
  id_mot INTEGER  NOT NULL ,
  emplacement varchar2(50)
) ;
[action]
create index index_m_emplacement ON spip_index_mots (emplacement);
[action]
create index index_m_hash ON spip_index_mots (hash);
[action]
create index index_m_id_mot ON spip_index_mots (id_mot);


[action]
CREATE TABLE spip_index_rubriques (
  hash varchar2(255) NOT NULL ,
  points INTEGER  NOT NULL ,
  id_rubrique INTEGER  NOT NULL ,
  emplacement varchar2(50)
) ;
[action]
create index index_r_emplacement ON spip_index_rubriques (emplacement);
[action]
create index index_r_hash ON spip_index_rubriques (hash);
[action]
create index index_r_id_rubrique ON spip_index_rubriques (id_rubrique);

[action]
CREATE TABLE spip_index_syndic (
  hash varchar2(255) NOT NULL ,
  points INTEGER  NOT NULL ,
  id_syndic INTEGER  NOT NULL ,
  emplacement varchar2(50)
) ;
[action]
create index index_s_emplacement ON spip_index_syndic (emplacement);
[action]
create index index_s_hash ON spip_index_syndic (hash);
[action]
create index index_s_id_rubrique ON spip_index_syndic (id_syndic);

[action]
CREATE TABLE spip_liens (
  contenant varchar2(10) NOT NULL ,
  lien_interne varchar2(10)  NULL ,
  lien_externe varchar2(255)  NULL ,
  CONSTRAINT spip_liens_pk PRIMARY KEY  (contenant,lien_interne,lien_externe)
) ;

[action]
CREATE TABLE spip_lock_mots (
  lockID varchar2(100) PRIMARY KEY ,
  lockTable varchar2(100)  NULL ,
  lockStamp varchar2(100)  NULL 
) ;

[action]
CREATE TABLE spip_messages (
  id_message number PRIMARY KEY ,
  titre VARCHAR2(255) NOT NULL,
  texte CLOB  NULL,
  type varchar2(6)  NULL ,
  date_heure varchar2(19)  NULL ,
  rv varchar2(4)  NULL ,
  statut varchar2(6)  NULL ,
  id_auteur number  NULL ,
  maj varchar2(19) NULL,
  date_fin varchar2(19)  NULL
) ;
[action]
create index messages_id_auteur ON spip_messages (id_auteur);

[action]
CREATE TABLE spip_meta (
  nom varchar2(255) PRIMARY KEY ,
  valeur varchar2(255) ,
  maj varchar2(19) NULL
) ;

[action]
CREATE TABLE spip_mots (
  id_mot number PRIMARY KEY ,
  id_root number  NOT NULL ,
  l INTEGER  NULL,
  r INTEGER  NULL,
  streh INTEGER  NULL,
  level_mot INTEGER  NULL,
  strna varchar2(100) NULL,
  type_mot varchar2(100)  NULL ,
  titre VARCHAR2(255)  NULL,
  descriptif CLOB  NULL,
  texte CLOB  NULL,
  id_groupe number NOT NULL ,
  maj varchar2(19) NULL,
  extra CLOB NULL
) ;
[action]
create index mots_type ON spip_mots (type_mot);
[action]
create index mots_id_root ON spip_mots (id_root);
[action]
create index mots_l ON spip_mots (l);
[action]
create index mots_r ON spip_mots (r);
[action]
create index mots_streh ON spip_mots (streh);
[action]
create index level_mot ON spip_mots (level_mot);

[action]
CREATE TABLE spip_mots_articles (
  id_mot number NOT NULL ,
  id_article number NOT NULL 
) ;
[action]
create index mots_a_id_mot ON spip_mots_articles (id_mot);
[action]
create index mots_a_id_article ON spip_mots_articles (id_article);

[action]
CREATE TABLE spip_mots_auteurs (
  id_mot INTEGER  NOT NULL ,
  id_auteur INTEGER  NOT NULL 
) ;
[action]
create index mots_au_id_mot ON spip_mots_auteurs (id_mot);
[action]
create index mots_au_id_auteur ON spip_mots_auteurs (id_auteur);

[action]
CREATE TABLE spip_mots_breves (
  id_mot number NOT NULL ,
  id_breve number NOT NULL 
) ;
[action]
create index mots_b_id_mot ON spip_mots_breves (id_mot);
[action]
create index mots_b_id_breve ON spip_mots_breves (id_breve);

[action]
CREATE TABLE spip_mots_cm (
  id_mot number NOT NULL ,
  id_groupe number NOT NULL 
) ;

[action]
CREATE TABLE spip_mots_forum (
  id_mot number NOT NULL ,
  id_forum number NOT NULL 
) ;
[action]
create index mots_f_id_mot ON spip_mots_forum (id_mot);
[action]
create index mots_f_id_forum ON spip_mots_forum (id_forum);

[action]
CREATE TABLE spip_mots_rubriques (
  id_mot number NOT NULL ,
  id_rubrique number NOT NULL 
) ;
[action]
create index mots_r_id_mot ON spip_mots_rubriques (id_mot);
[action]
create index mots_r_id_rubrique ON spip_mots_rubriques (id_rubrique);

[action]
CREATE TABLE spip_mots_syndic (
  id_mot number NOT NULL ,
  id_syndic number NOT NULL
) ;
[action]
create index mots_s_id_mot ON spip_mots_syndic (id_mot);
[action]
create index mots_s_id_syndic ON spip_mots_syndic (id_syndic);

[action]
CREATE TABLE spip_petitions (
  id_article number PRIMARY KEY ,
  email_unique varchar2(4)  NULL ,
  site_obli varchar2(4)  NULL ,
  site_unique varchar2(4)  NULL ,
  message varchar2(4)  NULL ,
  texte CLOB  NULL,
  maj varchar2(19) NULL
) ;

[action]
CREATE TABLE spip_profils (
  poids number PRIMARY KEY ,
  intitule varchar2(255) NOT NULL
) ;

[action]
CREATE TABLE spip_referers (
  referer_md5 varchar2(255) PRIMARY KEY ,
  date_heure varchar2(19) NOT NULL ,
  referer varchar2(255)  NULL ,
  visites INTEGER   NULL ,
  visites_jour INTEGER   NULL ,
  maj varchar2(19) NULL
) ;

[action]
CREATE TABLE spip_referers_articles (
  id_article INTEGER  NOT NULL ,
  referer_md5 varchar2(255)  NULL ,
  date_heure varchar2(19) NOT NULL ,
  referer varchar2(255)  NULL ,
  visites INTEGER   NULL ,
  maj varchar2(19) NULL ,
  CONSTRAINT spip_referers_articles_pk PRIMARY KEY  (id_article,referer_md5)
) ;
[action]
create index referers_a_r_md5 ON spip_referers_articles (referer_md5);

[action]
CREATE TABLE spip_referers_temp (
  ip varchar2(15) NOT NULL,
  referer varchar2(255)  NULL ,
  referer_md5 varchar2(255)  NULL ,
  type_referer varchar2(8)  NULL ,
  id_objet INTEGER  NOT NULL ,
  maj varchar2(19) NULL,
  CONSTRAINT spip_referers_t_pk PRIMARY KEY  (type_referer,id_objet,referer_md5,ip)
) ;

[action]
CREATE TABLE spip_rubriques (
  id_rubrique number PRIMARY KEY ,
  id_parent number NOT NULL ,
  titre VARCHAR2(255) NOT NULL,
  descriptif VARCHAR2(255)  NULL,
  texte CLOB  NULL,
  id_secteur number NOT NULL ,
  maj varchar2(19) NULL,
  export varchar2(10) default 'oui',
  id_import INTEGER ,
  statut varchar2(10)  NULL ,
  date_heure varchar2(19) NOT NULL ,
  extra CLOB  NULL,
  lang varchar2(10)  NULL ,
  langue_choisie varchar2(4)  NULL
) ;
[action]
create index rubriques_id_parent ON spip_rubriques (id_parent);
[action]
create index rubriques_lang ON spip_rubriques (lang);

[action]
CREATE TABLE spip_signatures (
  id_signature number PRIMARY KEY ,
  id_article number NOT NULL ,
  date_time varchar2(19) NOT NULL ,
  nom_email CLOB  NULL,
  ad_email CLOB  NULL,
  nom_site CLOB  NULL,
  url_site CLOB  NULL,
  message CLOB  NULL,
  statut varchar2(10)  NULL ,
  maj varchar2(19) NULL
) ;
[action]
create index signatures_id_article ON spip_signatures (id_article);
[action]
create index signatures_statut ON spip_signatures (statut);

[action]
CREATE TABLE spip_sondages (
  id_article number PRIMARY KEY ,
  actif char(3)  NULL ,
  affichage_public char(3)  NULL 
) ;

[action]
CREATE TABLE spip_sondages_reponses (
  id_article INTEGER NOT NULL ,
  id_reponse INTEGER NOT NULL ,
  texte_reponse varchar2(255)  NULL ,
  votes number  NULL ,
  CONSTRAINT spip_s_re_pk PRIMARY KEY  (id_article,id_reponse)
) ;

[action]
CREATE TABLE spip_sondages_votes (
  id_article INTEGER NOT NULL ,
  email_votant varchar2(255)  NULL ,
  date_time varchar2(19)  NULL ,
  id_reponse INTEGER  NULL ,
  statut varchar2(10)  NULL ,
  CONSTRAINT spip_sondages_votes_pl PRIMARY KEY  (id_article,email_votant)
) ;

[action]
CREATE TABLE spip_syndic (
  id_syndic number PRIMARY KEY ,
  id_rubrique number NOT NULL ,
  id_secteur number NOT NULL ,
  nom_site VARCHAR2(255)  NULL,
  url_site VARCHAR2(255)  NULL,
  url_syndic VARCHAR2(255)  NULL,
  descriptif VARCHAR2(255)  NULL,
  maj varchar2(19) NULL,
  syndication varchar2(4)  NULL ,
  statut varchar2(10)  NULL ,
  date_heure varchar2(19)  NULL ,
  date_syndic varchar2(19)  NULL ,
  date_index varchar2(19)  NULL ,
  moderation varchar2(4)  NULL 
) ;
[action]
create index syndic_id_rubrique ON spip_syndic (id_rubrique);
[action]
create index syndic_id_secteur ON spip_syndic (id_secteur);
[action]
create index syndic_statut ON spip_syndic (statut);

[action]
CREATE TABLE spip_syndic_articles (
  id_syndic_article number PRIMARY KEY  ,
  id_syndic number NOT NULL ,
  titre VARCHAR2(255)  NULL,
  url varchar2(255)  NULL ,
  date_heure varchar2(19)  NULL ,
  lesauteurs CLOB  NULL,
  maj varchar2(19) NULL,
  statut varchar2(10)  NULL ,
  descriptif CLOB  NULL
) ;
[action]
create index syndic_a_id_syndic ON spip_syndic_articles (id_syndic);
[action]
create index syndic_a_statut ON spip_syndic_articles (statut);
[action]
create index syndic_a_url ON spip_syndic_articles (url);

[action]
CREATE TABLE spip_types_documents (
  id_type number PRIMARY KEY,
  titre VARCHAR2(255) NOT NULL,
  descriptif CLOB NULL,
  extension varchar2(10) NOT NULL ,
  mime_type varchar2(100) NULL ,
  inclus varchar2(5)  NULL ,
  upload varchar2(4)  NULL ,
  maj varchar2(19) NULL
) ;
[action]
create unique index types_doc_extension ON spip_types_documents (extension);
[action]
create index types_doc_inclus ON spip_types_documents (inclus);

[action]
CREATE TABLE spip_visites (
  date_heure varchar2(19) PRIMARY KEY ,
  visites INTEGER  NOT NULL ,
  maj varchar2(19) NULL
) ;

[action]
CREATE TABLE spip_visites_articles (
  date_heure varchar2(19) NOT NULL ,
  id_article INTEGER  NOT NULL ,
  visites INTEGER  NOT NULL ,
  maj varchar2(19) NULL,
  CONSTRAINT spip_visites_articles_pk PRIMARY KEY  (date_heure,id_article)
) ;

[action]
CREATE TABLE spip_visites_temp (
  ip varchar2(15) NOT NULL,
  type varchar2(8)  NULL,
  id_objet INTEGER  NOT NULL ,
  maj varchar2(19) NULL,
  CONSTRAINT spip_visites_temp_pk PRIMARY KEY   (type,id_objet,ip)
) ;

[action]
CREATE TABLE spip_glossaire (
  id number PRIMARY KEY,
  mot varchar2(50)  NULL ,
  url varchar2(255)  NULL 
) ;

[action]
CREATE TABLE spip_index_documents (
  hash varchar2(255) NOT NULL ,
  points INTEGER  NOT NULL ,
  id_document INTEGER  NOT NULL ,
  emplacement varchar2(50) NULL
) ; 
[action]
create index index_doc_emplacement ON spip_index_documents (emplacement);
[action]
create index index_doc_hash ON spip_index_documents (hash);
[action]
create index index_doc_id_document ON spip_index_documents (id_document);

[action]
CREATE TABLE spip_articles_mapping (
  id number PRIMARY KEY ,
  id_map number NOT NULL ,
  id_article number NOT NULL
) ;

[action]
CREATE TABLE spip_module (
  nom varchar(50) PRIMARY KEY ,
  date_install varchar(50) NOT NULL ,
  version varchar(10) NOT NULL ,
  author varchar(50) NOT NULL 
);

