[action]
CREATE TABLE spip_articles (
  id_article bigint NOT NULL default '0',
  surtitre text NOT NULL,
  titre text NOT NULL,
  soustitre text NOT NULL,
  id_rubrique bigint NOT NULL default '0',
  descriptif text NOT NULL,
  chapo text NOT NULL,
  texte text NOT NULL,
  ps text NOT NULL,
  date_heure varchar(19) NOT NULL default '0000-00-00 00:00:00',
  statut varchar(10) NOT NULL default '0',
  id_secteur bigint NOT NULL default '0',
  maj varchar(19) default NULL,
  export varchar(10) default 'oui',
  date_redac varchar(19) NOT NULL default '0000-00-00 00:00:00',
  visites int NOT NULL default '0',
  referers int NOT NULL default '0',
  popularite float NOT NULL default '0',
  accepter_forum varchar(14) NOT NULL default '',
  auteur_modif bigint NOT NULL default '0',
  date_modif varchar(19) NOT NULL default '0000-00-00 00:00:00',
  extra text NOT NULL,
  lang varchar(10) NOT NULL default '',
  langue_choisie char(3) NOT NULL default 'non',
  id_trad bigint NOT NULL default '0',
  nom_site text NOT NULL,
  url_site varchar(255) NOT NULL default '',
  version_id INT,
  activer_historique VARCHAR( 3 ) DEFAULT NOT NULL 'non',
  PRIMARY KEY  (id_article)
);
[action]
CREATE TABLE spip_articles_historique (
  id_article_historique bigint NOT NULL default '0',
  id_article bigint NOT NULL default '0',
  surtitre text NOT NULL,
  titre text NOT NULL,
  soustitre text NOT NULL,
  descriptif text NOT NULL,
  chapo text NOT NULL,
  texte text NOT NULL,
  ps text NOT NULL,
  date_heure varchar(19) NOT NULL default '0000-00-00 00:00:00',
  extra text NOT NULL,
  PRIMARY KEY  (id_article_historique)
);
[action]
CREATE TABLE spip_auteurs (
  id_auteur bigint NOT NULL default '0',
  nom text NOT NULL,
  bio text NOT NULL,
  email text NOT NULL,
  nom_site text NOT NULL,
  url_site text NOT NULL,
  login varchar(255) NOT NULL default '',
  pass text NOT NULL,
  statut varchar(255) NOT NULL default '',
  profil bigint NOT NULL default '0',
  maj varchar(19) default NULL,
  pgp text NOT NULL,
  htpass text NOT NULL,
  en_ligne varchar(19) NOT NULL default '0000-00-00 00:00:00',
  imessage varchar(4) NOT NULL default '',
  messagerie varchar(4) NOT NULL default '',
  alea_actuel text NOT NULL,
  alea_futur text NOT NULL,
  prefs text NOT NULL,
  cookie_oubli text NOT NULL,
  source varchar(10) NOT NULL default 'spip',
  lang varchar(20) default NULL,
  extra text NOT NULL,
  low_sec text NOT NULL,
  PRIMARY KEY  (id_auteur)
  );


[action]
CREATE TABLE spip_auteurs_articles (
  id_auteur bigint NOT NULL default '0',
  id_article bigint NOT NULL default '0'
);

[action]
CREATE TABLE spip_auteurs_messages (
  id_auteur bigint NOT NULL default '0',
  id_message bigint NOT NULL default '0',
  vu varchar(4) NOT NULL default ''
);

[action]
CREATE TABLE spip_auteurs_rubriques (
  id_auteur bigint NOT NULL default '0',
  id_rubrique bigint NOT NULL default '0'
);

[action]
CREATE TABLE spip_bookmarks (
  id_auteur bigint NOT NULL default '0',
  id_objet bigint NOT NULL default '0',
  type_bookmark varchar(8) NOT NULL default '',
  PRIMARY KEY  (id_auteur,id_objet,type_bookmark)
);


[action]
CREATE TABLE spip_breves (
  id_breve bigint NOT NULL default '0',
  date_heure varchar(19) NOT NULL default '',
  titre text NOT NULL,
  texte text NOT NULL,
  lien_titre text NOT NULL,
  lien_url text NOT NULL,
  statut varchar(6) NOT NULL default '',
  id_rubrique bigint NOT NULL default '0',
  maj varchar(19) default NULL,
  extra text NOT NULL,
  lang varchar(10) NOT NULL default '',
  langue_choisie char(3) NOT NULL default 'non',
  PRIMARY KEY  (id_breve)
);


[action]
CREATE TABLE spip_cm_lists (
  lst_id int NOT NULL default '0',
  lst_name varchar(255) NOT NULL default '',
  lst_comment text NOT NULL,
  lst_moderation varchar(10) NOT NULL default '',
  lst_moderator_email varchar(255) NOT NULL default '',
  lst_subscribe_subject varchar(255) NOT NULL default '',
  lst_subscribe_text text NOT NULL,
  lst_subject varchar(255) NOT NULL default '',
  lst_unsubscribe_subject varchar(255) NOT NULL default '',
  lst_unsubscribe_text text NOT NULL,
  lst_subject_tag int NOT NULL default '1',
  lst_html_skeleton varchar(200) NOT NULL default '',
  lst_text_skeleton varchar(200) NOT NULL default '',
  lst_nb_articles int NOT NULL default '0',
  PRIMARY KEY  (lst_id)
);

[action]
CREATE TABLE spip_cm_lists_subscribers (
  lst_id int NOT NULL default '0',
  sub_id bigint NOT NULL default '0',
  lsr_mode int NOT NULL default '0',
  lsr_id varchar(32) NOT NULL default '',
  PRIMARY KEY  (lst_id,sub_id)
);

[action]
CREATE TABLE spip_cm_pending (
  lst_id int NOT NULL default '0',
  sub_id bigint NOT NULL default '0',
  pnd_action varchar(15) NOT NULL default '',
  pnd_mode int NOT NULL default '0',
  pnd_action_date int NOT NULL default '0',
  pnd_action_id varchar(32) NOT NULL default '',
  PRIMARY KEY  (lst_id,sub_id)
);


[action]
CREATE TABLE spip_cm_posts (
  pst_id bigint NOT NULL default '0',
  lst_id int NOT NULL default '0',
  pst_date_create varchar(19) NOT NULL default '0000-00-00 00:00:00',
  pst_date_update varchar(19) NOT NULL default '0000-00-00 00:00:00',
  pst_date_sent varchar(19) NOT NULL default '0000-00-00 00:00:00',
  pst_subject varchar(255) NOT NULL default '',
  destinataires_specifiques text,
  user_group_inactif text,
  PRIMARY KEY  (pst_id)
);


[action]
CREATE TABLE spip_cm_posts_articles (
  article_id bigint NOT NULL default '0',
  pst_id bigint NOT NULL default '0',
  art_order int NOT NULL default '0'
);


[action]
CREATE TABLE spip_cm_posts_done (
  pst_id bigint NOT NULL default '0',
  id_auteur bigint NOT NULL default '0',
  id_sub bigint NOT NULL default '0',
  email varchar(255) NOT NULL default '',
  PRIMARY KEY  (pst_id,email)
);

[action]
CREATE TABLE spip_cm_posts_links (
  lnk_id bigint NOT NULL default '0',
  pst_id bigint NOT NULL default '0',
  lnk_name varchar(255) NOT NULL default '',
  lnk_url text NOT NULL,
  PRIMARY KEY  (lnk_id)
);

[action]
CREATE TABLE spip_cm_posts_queued (
  pst_id bigint NOT NULL default '0',
  id_auteur bigint NOT NULL default '0',
  id_sub bigint NOT NULL default '0',
  email varchar(255) NOT NULL default '',
  mode int NOT NULL default '0',
  psq_date varchar(19) NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (pst_id,email)
);


[action]
CREATE TABLE spip_cm_settings (
  set_name varchar(15) NOT NULL default '',
  set_value varchar(255) NOT NULL default '',
  PRIMARY KEY  (set_name)
);


[action]
CREATE TABLE spip_cm_subscribers (
  sub_id bigint NOT NULL default '0',
  sub_email varchar(255) NOT NULL default '',
  sub_first_name varchar(50) NOT NULL default '',
  sub_middle_name varchar(50) NOT NULL default '',
  sub_last_name varchar(50) NOT NULL default '',
  sub_title varchar(10) NOT NULL default '',
  sub_profile varchar(32) NOT NULL default '',
  PRIMARY KEY  (sub_id)
);


[action]
CREATE TABLE spip_cm_user_groups (
  id_groupe bigint NOT NULL default '0',
  lst_id bigint default NULL,
  pst_id bigint default NULL,
  titre varchar(255) default NULL,
  PRIMARY KEY  (id_groupe)
);

[action]
CREATE TABLE spip_dernieres_visites (
  id_pers bigint NOT NULL default '0',
  date varchar(19) NOT NULL default '',
  url varchar(200) NOT NULL default '',
  titre varchar(100) NOT NULL default '',
  PRIMARY KEY  (id_pers)
);

[action]
CREATE TABLE spip_documents (
  id_document bigint NOT NULL default '0',
  id_vignette bigint NOT NULL default '0',
  id_type bigint NOT NULL default '0',
  titre text NOT NULL,
  date_heure varchar(19) NOT NULL default '0000-00-00 00:00:00',
  descriptif text NOT NULL,
  fichier varchar(255) NOT NULL default '',
  taille int NOT NULL default '0',
  largeur int NOT NULL default '0',
  hauteur int NOT NULL default '0',
  mode_spip varchar(8) NOT NULL default 'vignette',
  inclus varchar(4) default 'non',
  maj varchar(19) default NULL,
  PRIMARY KEY  (id_document)
);

[action]
CREATE TABLE spip_documents_articles (
  id_document bigint NOT NULL default '0',
  id_article bigint NOT NULL default '0'
);


[action]
CREATE TABLE spip_documents_breves (
  id_document bigint NOT NULL default '0',
  id_breve bigint NOT NULL default '0'
);


[action]
CREATE TABLE spip_documents_rubriques (
  id_document bigint NOT NULL default '0',
  id_rubrique bigint NOT NULL default '0'
);


[action]
CREATE TABLE spip_forum (
  id_forum bigint NOT NULL default '0',
  id_parent bigint NOT NULL default '0',
  id_rubrique bigint NOT NULL default '0',
  id_article bigint NOT NULL default '0',
  id_breve bigint NOT NULL default '0',
  date_heure varchar(19) NOT NULL default '0000-00-00 00:00:00',
  titre text NOT NULL,
  texte text NOT NULL,
  auteur text NOT NULL,
  email_auteur text NOT NULL,
  nom_site text NOT NULL,
  url_site text NOT NULL,
  statut varchar(8) NOT NULL default '',
  ip varchar(16) default NULL,
  maj varchar(19) default NULL,
  id_auteur bigint NOT NULL default '0',
  id_message bigint NOT NULL default '0',
  id_syndic bigint NOT NULL default '0',
  profil_auteur int default '0',
  alerte_mail varchar(4) NOT NULL default 'oui',
  PRIMARY KEY  (id_forum)
);

[action]
CREATE TABLE spip_forum_cache (
  id_forum bigint NOT NULL default '0',
  id_rubrique bigint NOT NULL default '0',
  id_article bigint NOT NULL default '0',
  id_breve bigint NOT NULL default '0',
  id_syndic bigint NOT NULL default '0',
  fichier varchar(150)  NOT NULL default '',
  maj varchar(19) default NULL,
  PRIMARY KEY  (fichier,id_forum,id_article,id_rubrique,id_breve,id_syndic)
);

[action]
CREATE TABLE spip_groupes_mots (
  id_groupe bigint NOT NULL default '0',
  titre text NOT NULL,
  unseul varchar(4) NOT NULL default '',
  obligatoire varchar(4) NOT NULL default '',
  articles varchar(4) NOT NULL default '',
  breves varchar(4) NOT NULL default '',
  rubriques varchar(4) NOT NULL default '',
  syndic varchar(4) NOT NULL default '',
  auteurs varchar(4) NOT NULL default '',
  forum varchar(4) NOT NULL default '',
  cm varchar(4) NOT NULL default '',
  maj varchar(19) default NULL,
  profils int NOT NULL default '0',
  PRIMARY KEY  (id_groupe)
);

[action]
CREATE TABLE spip_index_articles (
  hash varchar(255) NOT NULL default '0',
  points int  NOT NULL default '0',
  id_article int  NOT NULL default '0'
);

[action]
CREATE TABLE spip_index_auteurs (
  hash varchar(255) NOT NULL default '0',
  points int  NOT NULL default '0',
  id_auteur int  NOT NULL default '0'
);

[action]
CREATE TABLE spip_index_breves (
  hash varchar(255) NOT NULL default '0',
  points int  NOT NULL default '0',
  id_breve int  NOT NULL default '0'
);

[action]
CREATE TABLE spip_index_dico (
  hash varchar(255) NOT NULL default '0',
  dico varchar(30) NOT NULL default '',
  PRIMARY KEY  (dico)
);

[action]
CREATE TABLE spip_index_mots (
  hash varchar(255) NOT NULL default '0',
  points int  NOT NULL default '0',
  id_mot int  NOT NULL default '0'
);


[action]
CREATE TABLE spip_index_rubriques (
  hash varchar(255) NOT NULL default '0',
  points int  NOT NULL default '0',
  id_rubrique int  NOT NULL default '0'
);

[action]
CREATE TABLE spip_index_syndic (
  hash varchar(255) NOT NULL default '0',
  points int  NOT NULL default '0',
  id_syndic int  NOT NULL default '0'
);


[action]
CREATE TABLE spip_liens (
  contenant varchar(10) NOT NULL default '',
  lien_interne varchar(10) NOT NULL default '',
  lien_externe varchar(255) NOT NULL default '',
  PRIMARY KEY  (contenant,lien_interne,lien_externe)
);

[action]
CREATE TABLE spip_lock_mots (
  lockID varchar(100) NOT NULL default '',
  lockTable varchar(100) NOT NULL default '',
  lockStamp varchar(100) NOT NULL default '',
  PRIMARY KEY  (lockID)
);

[action]
CREATE TABLE spip_messages (
  id_message bigint NOT NULL default '0',
  titre text NOT NULL,
  texte text NOT NULL,
  type varchar(6) NOT NULL default '',
  date_heure varchar(19) NOT NULL default '0000-00-00 00:00:00',
  rv varchar(4) NOT NULL default '',
  statut varchar(6) NOT NULL default '',
  id_auteur bigint NOT NULL default '0',
  maj varchar(19) default NULL,
  date_fin varchar(19) NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (id_message)
);

[action]
CREATE TABLE spip_meta (
  nom varchar(255) NOT NULL default '',
  valeur varchar(255) default '',
  maj varchar(19) default NULL,
  PRIMARY KEY  (nom)
);

[action]
CREATE TABLE spip_mots (
  id_mot bigint NOT NULL default '0',
  id_root bigint  NOT NULL default '0',
  l bigint  default NULL,
  r bigint  default NULL,
  streh bigint  default NULL,
  level_mot bigint  default NULL,
  strna varchar(100) default NULL,
  type_mot varchar(100) NOT NULL default '',
  titre text NOT NULL,
  descriptif text NOT NULL,
  texte text NOT NULL,
  id_groupe bigint NOT NULL default '0',
  maj varchar(19) default NULL,
  extra text NOT NULL,
  PRIMARY KEY  (id_mot)
);

[action]
CREATE TABLE spip_mots_articles (
  id_mot bigint NOT NULL default '0',
  id_article bigint NOT NULL default '0'
);

[action]
CREATE TABLE spip_mots_auteurs (
  id_mot bigint  NOT NULL default '0',
  id_auteur bigint  NOT NULL default '0'
);

[action]
CREATE TABLE spip_mots_breves (
  id_mot bigint NOT NULL default '0',
  id_breve bigint NOT NULL default '0'
);

[action]
CREATE TABLE spip_mots_cm (
  id_mot bigint NOT NULL default '0',
  id_groupe bigint NOT NULL default '0'
);

[action]
CREATE TABLE spip_mots_forum (
  id_mot bigint NOT NULL default '0',
  id_forum bigint NOT NULL default '0'
);

[action]
CREATE TABLE spip_mots_rubriques (
  id_mot bigint NOT NULL default '0',
  id_rubrique bigint NOT NULL default '0'
);

[action]
CREATE TABLE spip_mots_syndic (
  id_mot bigint NOT NULL default '0',
  id_syndic bigint NOT NULL default '0'
);

[action]
CREATE TABLE spip_petitions (
  id_article bigint NOT NULL default '0',
  email_unique varchar(4) NOT NULL default '',
  site_obli varchar(4) NOT NULL default '',
  site_unique varchar(4) NOT NULL default '',
  message varchar(4) NOT NULL default '',
  texte text NOT NULL,
  maj varchar(19) default NULL,
  PRIMARY KEY  (id_article)
);

[action]
CREATE TABLE spip_profils (
  poids int NOT NULL default '0',
  intitule varchar(255) NOT NULL default '',
  PRIMARY KEY  (poids)
);

[action]
CREATE TABLE spip_referers (
  referer_md5 varchar(255) NOT NULL default '0',
  date_heure varchar(19) NOT NULL default '0000-00-00 00:00:00',
  referer varchar(255) NOT NULL default '',
  visites int  NOT NULL default '0',
  visites_jour int  NOT NULL default '0',
  maj varchar(19) default NULL,
  PRIMARY KEY  (referer_md5)
);

[action]
CREATE TABLE spip_referers_articles (
  id_article int  NOT NULL default '0',
  referer_md5 varchar(255) NOT NULL default '0',
  date_heure varchar(19) NOT NULL default '0000-00-00 00:00:00',
  referer varchar(255) NOT NULL default '',
  visites int  NOT NULL default '0',
  maj varchar(19) default NULL,
  PRIMARY KEY  (id_article,referer_md5)
);

[action]
CREATE TABLE spip_referers_temp (
  ip varchar(15) NOT NULL default '0.0.0.0',
  referer varchar(255) NOT NULL default '',
  referer_md5 varchar(255) NOT NULL default '0',
  type_referer varchar(8) NOT NULL default 'article',
  id_objet int  NOT NULL default '0',
  maj varchar(19) default NULL,
  PRIMARY KEY  (type_referer,id_objet,referer_md5,ip)
);

[action]
CREATE TABLE spip_rubriques (
  id_rubrique bigint NOT NULL default '0',
  id_parent bigint NOT NULL default '0',
  titre text NOT NULL,
  descriptif text NOT NULL,
  texte text NOT NULL,
  id_secteur bigint NOT NULL default '0',
  maj varchar(19) default NULL,
  export varchar(10) default 'oui',
  id_import bigint default '0',
  statut varchar(10) NOT NULL default '',
  date_heure varchar(19) NOT NULL default '0000-00-00 00:00:00',
  extra text NOT NULL,
  lang varchar(10) NOT NULL default '',
  langue_choisie char(3) NOT NULL default 'non',
  PRIMARY KEY  (id_rubrique)
);

[action]
CREATE TABLE spip_signatures (
  id_signature bigint NOT NULL default '0',
  id_article bigint NOT NULL default '0',
  date_time varchar(19) NOT NULL default '0000-00-00 00:00:00',
  nom_email text NOT NULL,
  ad_email text NOT NULL,
  nom_site text NOT NULL,
  url_site text NOT NULL,
  message text NOT NULL,
  statut varchar(10) NOT NULL default '',
  maj varchar(19) default NULL,
  PRIMARY KEY  (id_signature)
);

[action]
CREATE TABLE spip_sondages (
  id_article bigint NOT NULL default '0',
  actif char(3) NOT NULL default 'oui',
  affichage_public char(3) NOT NULL default 'non',
  PRIMARY KEY  (id_article)
);

[action]
CREATE TABLE spip_sondages_reponses (
  id_article bigint NOT NULL default '0',
  id_reponse bigint NOT NULL default '0',
  texte_reponse varchar(255) NOT NULL default '',
  votes int NOT NULL default '0',
  PRIMARY KEY  (id_article,id_reponse)
);

[action]
CREATE TABLE spip_sondages_votes (
  id_article bigint NOT NULL default '0',
  email_votant varchar(255) NOT NULL default '',
  date_time varchar(19) NOT NULL default '0000-00-00 00:00:00',
  id_reponse bigint NOT NULL default '0',
  statut varchar(10) NOT NULL default '',
  PRIMARY KEY  (id_article,email_votant)
);

[action]
CREATE TABLE spip_syndic (
  id_syndic bigint NOT NULL default '0',
  id_rubrique bigint NOT NULL default '0',
  id_secteur bigint NOT NULL default '0',
  nom_site text NOT NULL,
  url_site text NOT NULL,
  url_syndic text NOT NULL,
  descriptif text NOT NULL,
  maj varchar(19) default NULL,
  syndication varchar(4) NOT NULL default '',
  statut varchar(10) NOT NULL default '',
  date_heure varchar(19) NOT NULL default '0000-00-00 00:00:00',
  date_syndic varchar(19) NOT NULL default '0000-00-00 00:00:00',
  date_index varchar(19) NOT NULL default '0000-00-00 00:00:00',
  moderation varchar(4) NOT NULL default '',
  PRIMARY KEY  (id_syndic)
);

[action]
CREATE TABLE spip_syndic_articles (
  id_syndic_article bigint NOT NULL default '0',
  id_syndic bigint NOT NULL default '0',
  titre text NOT NULL,
  url varchar(255) NOT NULL default '',
  date_heure varchar(19) NOT NULL default '0000-00-00 00:00:00',
  lesauteurs text NOT NULL,
  maj varchar(19) default NULL,
  statut varchar(10) NOT NULL default '',
  descriptif text NOT NULL,
  PRIMARY KEY  (id_syndic_article)
);

[action]
CREATE TABLE spip_types_documents (
  id_type bigint NOT NULL default '0',
  titre text NOT NULL,
  descriptif text NOT NULL,
  extension varchar(10) NOT NULL default '',
  mime_type varchar(100) NOT NULL default '',
  inclus varchar(5) NOT NULL default 'non',
  upload varchar(4) NOT NULL default 'oui',
  maj varchar(19) default NULL,
  PRIMARY KEY  (id_type)
);

[action]
CREATE TABLE spip_visites (
  date_heure varchar(19) NOT NULL default '0000-00-00 00:00:00',
  visites int  NOT NULL default '0',
  maj varchar(19) default NULL,
  PRIMARY KEY  (date_heure)
);

[action]
CREATE TABLE spip_visites_articles (
  date_heure varchar(19) NOT NULL default '0000-00-00 00:00:00',
  id_article int  NOT NULL default '0',
  visites int  NOT NULL default '0',
  maj varchar(19) default NULL,
  PRIMARY KEY  (date_heure,id_article)
);

[action]
CREATE TABLE spip_visites_temp (
  ip varchar(15) NOT NULL default '0.0.0.0',
  type varchar(8) NOT NULL default 'article',
  id_objet int  NOT NULL default '0',
  maj varchar(19) default NULL,
  PRIMARY KEY  (type,id_objet,ip)
);

[action]
CREATE TABLE spip_glossaire (
  id int NOT NULL,
  mot varchar(50) NOT NULL default '',
  url varchar(255) NOT NULL default '',
  PRIMARY KEY (id)
);

[action]
CREATE TABLE spip_module (
  nom varchar(50) NOT NULL default '',
  date_install varchar(50) NOT NULL default '',
  version varchar(10) NOT NULL default '',
  author varchar(50) NOT NULL default '',
  PRIMARY KEY  (nom)
);
