<?php
/******* Fichier Ajout MAPPING guillaume.grason@diplomatie.gouv.fr *******/
/** Gestion d'un article.
 * @version      $Id: mapping_articles.php3,v 1.2 2005/11/28 22:21:02 lpoinsignon Exp $
 */



include ("inc.php3");

include_ecrire("inc_logos.php3");
include_ecrire("inc_mots.php3");
include_ecrire("inc_documents.php3");

/* Ajout Clever Age / Nicolas Hoizey / Referencement des liens & gestion sondages */
include_ecrire('inc_liens.php3');
include_ecrire("inc_sondages.php3");
/* fin zone de modification Clever Age */

/* Ajout Clever Age / Antoine Angenieux / Couche metier */
require_once (dirname(__FILE__)."/include/bd/auteur.php");
require_once (dirname(__FILE__)."/include/bd/inc_article_factory.php");
require_once (dirname(__FILE__)."/include/bd/inc_document_factory.php");
require_once (dirname(__FILE__)."/include/bd/inc_forum_factory.php");
require_once (dirname(__FILE__)."/include/bd/inc_petition_factory.php");
require_once (dirname(__FILE__)."/include/bd/inc_signature_factory.php");
require_once (dirname(__FILE__)."/include/bd/inc_forum_list_factory.php");
require_once (dirname(__FILE__)."/include/bd/inc_profil_factory.php");

// Ajout Aurelien Vialet <avialet@clever-age.com> Gestion des champs formulaires
require_once (dirname(__FILE__)."/inc_contraintes.php");
require_once (dirname(__FILE__)."/include/bd/inc_article_historique_factory.php");
// Fin de l'ajout Aurelien Vialet

require_once (dirname(__FILE__)."/include/bd/inc_mapping_factory.php");
$mappingMetier = &recuperer_instance_mapping();
$loadOK = $mappingMetier->loadArticle($id_article);
if (PEAR :: isError($loadOK)) {
	die($loadOK->getMessage());
}
else {
	$id_article_parent = $mappingMetier->getArticleId();
}

/* fin zone de modification Clever Age */

// le poids du redacteur .... utile pour la suite 
$profilMetier = & recuperer_instance_profil();
$loadOK = $profilMetier->getProfilForIntitule('item_redacteur');
if (PEAR :: isError($loadOK)) {
    die($loadOK->getMessage());
}
define ("POIDSREDACTEUR", $loadOK->getPoids());
//var_dump ($profilMetier);

$articles_surtitre = lire_meta("articles_surtitre");
$articles_soustitre = lire_meta("articles_soustitre");
$articles_descriptif = lire_meta("articles_descriptif");
$articles_urlref = lire_meta("articles_urlref");
$articles_chapeau = lire_meta("articles_chapeau");
$articles_ps = lire_meta("articles_ps");
$articles_redac = lire_meta("articles_redac");
$articles_mots = lire_meta("articles_mots");

$activer_version_articles = lire_meta("activer_version_articles");
$activer_histo_articles = lire_meta("activer_histo_articles");

$articleMetier = & recuperer_instance_article();
$auteurMetier = & recuperer_instance_auteur();

$mapping = & recuperer_instance_mapping();
$mappingMetier = & recuperer_instance_article();

// Rcupration de l'heure courante (valeur par dfaut de l'heure de publication)
$heure = date( 'H' );
$minute = date( 'i' );
$seconde = date( 's' );

// Gestion de la mise en ligne d'une version d'un article
$id_version = 0;

if ($activer_version_articles == 'oui') {
	if ($new_version == 'oui') {
		// Gestion de la mise en place d'une nouvelle version d'un article
		$id_version = $id_article;
		$id_article = 0;
		$new = 'oui';
	}
}

/********* Modification tbeaumanoir@clever-age.com ***********************/
// c quoi ce code mon petit thomas ?
if ($activerhistorique == 'oui' || $activerhistorique == 'non') {
	$loadOK = $articleMetier->load($id_article);
	if (PEAR :: isError($loadOK)) {
		die($loadOK->getMessage());
	} else {
		$articleMetier->setActiverHistorique($activerhistorique);
		$articleMetier->update();
	}
}
/********* Fin Modification tbeaumanoir@clever-age.com ***********************/


if ($id_article == 0) {
	if ($new == 'oui') {
		$authorization = & recuperer_instance_authorization('isManagedRubriqueByAuteurId', $GLOBALS['connect_id_auteur'], array ('rubriqueId' => intval($articleMetier->getRubriqueId())));
		if (!$authorization->isAuthorizedAction()) {
			echo _T('avis_acces_interdit');
			exit;
		}

		/********* Modification elebescond@clever-age.com ***********************/
		if ($titre == '')
			$titre = _T('art_info_sans_titre', null, $articleMetier->getRubriqueId());
		/*
		if ($titre=='') $titre = _T('info_sans_titre');
		*/
		/********* Fin modification elebescond@clever-age.com ***********************/

		$langue_new = '';
		/**************** Modification elebescond@clever-age.com *************************************/
		$rubriqueMetier = & recuperer_instance_rubrique();
		$loadOK = $rubriqueMetier->load($id_rubrique);
		if (PEAR :: isError($loadOK)) {
			die($loadOK->getMessage());
		} else {
			$langue_new = $rubriqueMetier->getLang();
		}
		/*
		$result_lang_rub = spip_query("SELECT lang FROM spip_rubriques WHERE id_rubrique=$articleMetier->getRubriqueId()");
		if ($row = spip_fetch_array($result_lang_rub))
			$langue_new = $row["lang"];
		*/
		/**************** Fin modification elebescond@clever-age.com *************************************/

		if (!$langue_new)
			$langue_new = lire_meta('langue_site');
		$langue_choisie_new = 'non';

		/********* Modification elebescond@clever-age.com ***********/
		$forums_publics = lire_meta('forums_publics');
		/*
		$forums_publics = substr(lire_meta('forums_publics'),0,3);
		*/
		/********* Fin modification elebescond@clever-age.com ***********/

		/* Modification Clever Age, utilisation couche m�tier */
		$articleMetier->setRubriqueId($id_rubrique);
		$articleMetier->setStatut('prepa');
		$articleMetier->setAccepterForum($forums_publics);
		$articleMetier->setLang($langue_new);
		$articleMetier->setLangChoisie($langue_choisie_new);

		// Ajout Aurelien Vialet <avialet@clever-age.com>
		// Gestion du versionning des articles
		$articleMetier->setVersionId($id_version);

		$createOK = $articleMetier->create();
		if (PEAR :: isError($createOK)) {
			die($createOK->getMessage());
		}
		/*
		spip_query("INSERT INTO spip_articles (id_rubrique, statut, date, accepter_forum, lang, langue_choisie) VALUES ($articleMetier->getRubriqueId(), 'prepa', NOW(), '$forums_publics', '$langue_new', '$langue_choisie_new')");
		$id_article = spip_insert_id();
		
		spip_query("INSERT INTO spip_articles (id_rubrique, statut, date, accepter_forum) VALUES ($articleMetier->getRubriqueId(), 'prepa', NOW(), '$forums_publics')");
		*/
		$id_article = $articleMetier->getArticleId();

		$deleteAuteursOK = $articleMetier->deleteAuteurs();
		if (PEAR :: isError($createOK)) {
			die($deleteAuteursOK->getMessage());
		}

		$addAuteurOK = $articleMetier->addAuteur($connect_id_auteur);
		if (PEAR :: isError($addAuteurOK)) {
			die($addAuteurOK->getMessage());
		}
		/*
		spip_query("DELETE FROM spip_auteurs_articles WHERE id_article = $id_article");
		spip_query("DELETE FROM spip_auteurs_articles WHERE id_article = $id_article");
		spip_query("INSERT INTO spip_auteurs_articles (id_auteur, id_article) VALUES ($connect_id_auteur, $id_article)");
		*/
		/* Fin de zone de modifications */
	} else {
		@ header("Location: ./index.php3");
		exit;
	}
}

$clean_link = new Link("mapping_articles.php3?id_article=$id_article");

// Initialiser doublons pour documents (completes par "propre($texte)")
$id_doublons['documents'] = "0";

//////////////////////////////////////////////////////
// Determiner les droits d'edition de l'article
//

/*
    MODIFICATION CLEVER AGE COUCHE METIER
*/

$loadOK = $articleMetier->load($id_article);

if (PEAR :: isError($loadOK)) {
	die($loadOK->getMessage());
} else {
	$statut_article = $articleMetier->getStatut();
	if ($statut_article != '') {
		$titre_article = $articleMetier->getTitre();
		$rubrique_article = $articleMetier->getRubriqueId();
	}
}
$authorization = & recuperer_instance_authorization('isManagedRubriqueByAuteurId', $GLOBALS['connect_id_auteur'], array ('rubriqueId' => $rubrique_article));
if (!$authorization->isAuthorizedAction()) {
	echo _T('avis_acces_interdit');
	exit;
}

/*
$query = "SELECT statut, titre, id_rubrique FROM spip_articles WHERE id_article=$id_article";
$result = spip_query($query);
if ($row = spip_fetch_array($result)) {
	$statut_article = $row['statut'];
	$titre_article = $row['titre'];
	$rubrique_article = $row['id_rubrique'];
}
else {
	$statut_article = '';
}
*/

$flag_auteur = $articleMetier->isAuthor($connect_id_auteur);
if (PEAR :: isError($flag_auteur)) {
	die($flag_auteur->getMessage());
}
/*
$query = "SELECT * FROM spip_auteurs_articles WHERE id_article=$id_article AND id_auteur=$connect_id_auteur";
$result_auteur = spip_query($query);

$flag_auteur = (spip_num_rows($result_auteur) > 0);
*/

/*
    FIN DE ZONE DE MODIFICATIONS
*/
//--------Zone de modifications Clever Age elebescond-------------
//$authorization = &recuperer_instance_authorization();

$authorization1 = & recuperer_instance_authorization('isManagedRubriqueByAuteurId', $GLOBALS['connect_id_auteur'], array ('rubriqueId' => $rubrique_article));
$authorization2 = & recuperer_instance_authorization('modifierStatutArticle', $GLOBALS['connect_id_auteur'], array ('id_article' => $id_article, 'statut_nouv' => $statut_nouv));
$authorization3 = & recuperer_instance_authorization('modifierArticle', $GLOBALS['connect_id_auteur'], array ('id_article' => $id_article));

$flag_editable = ($authorization1->isAuthorizedAction() AND ($authorization2->isAuthorizedAction() OR $authorization3->isAuthorizedAction()));
/*
$flag_editable = ($authorization->isAuthorized($GLOBALS['connect_id_auteur'], 'isManagedRubriqueByAuteurId', array('rubriqueId' => $rubrique_article))
	OR ($flag_auteur AND ($statut_article == 'prepa' OR $statut_article == 'prop' OR $statut_article == 'poubelle')));
*/
 

/*
$flag_editable = (acces_rubrique($rubrique_article)
	OR ($flag_auteur AND ($statut_article == 'prepa' OR $statut_article == 'prop' OR $statut_article == 'poubelle')));
*/
//--------Fin Zone de modifications Clever Age elebescond-------------

/// En double avec articles_edit.php3, mais necessite le flag_editable
$modif_document = $GLOBALS['modif_document'];

if ($modif_document == 'oui' AND $flag_editable) {
	//--------Zone de modifications Clever Age aangenieux-------------
	$documentMetier = & recuperer_instance_document();
	$loadOK = $documentMetier->load($id_document);

	if (PEAR :: isError($loadOK)) {
		die($loadOK->getMessage());
	}

	if ($documentMetier->getMode() == 'document') {
		if ($titre_document != '') {
			$documentMetier->setTitre($titre_document);
		} else {
			if ($titre_document == '' && $descriptif_document != '' && $documentMetier->getTitre() == '') {
				$titre_document_array = explode('/', $documentMetier->getFichier());
				$titre_document = $titre_document_array[2];
				$titre_document_array = explode('.', $titre_document);

				$titre_document = strtr($titre_document_array[0], "_", " ");
				$documentMetier->setTitre($titre_document);
			}
		}
	} else {
		if (($titre_document == '' && $descriptif_document == '') || ($titre_document != '')) {
			$documentMetier->setTitre($titre_document);
		} else {
			if ($titre_document == '' && $descriptif_document != '' && $documentMetier->getTitre() == '') {
				$titre_document_array = explode('/', $documentMetier->getFichier());
				$titre_document = $titre_document_array[2];
				$titre_document_array = explode('.', $titre_document);

				$titre_document = strtr($titre_document_array[0], "_", " ");
				$documentMetier->setTitre($titre_document);
			}
		}
	}

	$documentMetier->setDescriptif($descriptif_document);
	if ($largeur_document AND $hauteur_document) {
		$documentMetier->setLargeur($largeur_document);
		$documentMetier->setHauteur($hauteur_document);
	}

	$updateOK = $documentMetier->update();
	if (PEAR :: isError($updateOK)) {
		die($updateOK->getMessage());
	}
	/*
	$titre_document = corriger_caracteres($titre_document);
	$descriptif_document = corriger_caracteres($descriptif_document);
	$query = "UPDATE spip_documents SET titre=\"$titre_document\", descriptif=\"$descriptif_document\"";
	if ($largeur_document AND $hauteur_document) $query .= ", largeur='$largeur_document', hauteur='$hauteur_document'";
	$query .= " WHERE id_document=$id_document";
	spip_query($query);
	*/
	//----------Fin zone de modifications-----------------------------
}

//
// Appliquer les modifications
//
$suivi_edito = lire_meta("suivi_edito");
$reindexer = false;

$ok_nouveau_statut = false;
 
if ($statut_nouv && $flag_editable) {
	//--------Zone de modifications Clever Age elebescond-------------
	$authorization = & recuperer_instance_authorization('isManagedRubriqueByAuteurId', $GLOBALS['connect_id_auteur'], array ('rubriqueId' => $rubrique_article));
	if ($authorization->isAuthorizedAction())
		$ok_nouveau_statut = true;
	/*
	if (acces_rubrique($rubrique_article)) $ok_nouveau_statut = true;
	*/
	//--------Zone de modifications Clever Age elebescond@clever-age.com-------------
	else
		if ($flag_auteur) {
			if ($statut_nouv == 'prop' AND $statut_article == 'prepa')
				$ok_nouveau_statut = true;
			else
				if ($statut_nouv == 'prepa' AND $statut_article == 'poubelle')
					$ok_nouveau_statut = true;
		}

	if ($ok_nouveau_statut) {
		// GESTION DU VERSIONNING
		//-----------MODIFICATION CLEVER AGE
		$articleMetier->setStatut($statut_nouv);
		/*
		$query = "UPDATE spip_articles SET statut='$statut_nouv' WHERE id_article=$id_article";
		$result = spip_query($query);
		*/
		/******* Ajout MAPPING guillaume.grason@diplomatie.gouv.fr *******/
		if ($statut_nouv == 'poubelle' AND $statut_nouv != $statut_article) {
			$mappings = $mapping->getMappings($articleMetier->getArticleId());
			if ( PEAR::isError($mappings) ) {
				die($mappings->getMessage());
			}
			else {
				for ($i = 0; $i < count($mappings); $i++) {
					$deleteOK = $mappingMetier->delete($mappings[$i]);
					if (PEAR :: isError($deleteOK)) {
						die($deleteOK->getMessage());
					}
					$deleteOK = $mapping->deleteEntryByArticleIdAndMappingId($articleMetier->getArticleId(), $id_map);
					if (PEAR :: isError($deleteOK)) {
						die($deleteOK->getMessage());
					}
				}
			}
		}
		/******* Fin Ajout MAPPING guillaume.grason@diplomatie.gouv.fr *******/
		if ($statut_nouv == 'publie' AND $statut_nouv != $statut_article) {
			if (($activer_version_articles == 'oui') && ($articleMetier->getVersionId() != 0)) {
				//echo $articleMetier->getVersionId();
				$redirectId = $articleMetier->getVersionId();
				//$articleMetier->load(1);
				// Modification Aurelien Vialet <avialet@clever-age.com>
				// Mise  jour en publi implique dans le cas d'une version qu'il 
				// faut pour une version la pass en artilce racine
				
				if ($articleMetier->getVersionId() != 0) {
					$articleMetier->switchVersion($articleMetier->getVersionId(), $articleMetier->getArticleId());
				}
				// header("location:articles.php3?id_article=1"); //, c pas l'article 1 !!!!!
				header("location:articles.php3?id_article=".$articleMetier->getVersionId());
				
				// Gestion du changement de statut si on publie une version
				// Fin de modification Aurelien Vialet <avialet@clever-age.com>
			}
			
			
			
            //			$maDate = new Date();
            //			$articleMetier->setDate($maDate->getDate(DATE_FORMAT_ISO));
			//$articleMetier->setDate('NOW()');
			/*
			$query = "UPDATE spip_articles SET date=NOW() WHERE id_article=$id_article";
			$result = spip_query($query);
			*/
		}

		$updateOK = $articleMetier->update();
		if (PEAR :: isError($updateOK)) {
			die($updateOK->getMessage());
		}
		//-------FIN MODIFICATION CLEVER AGE
		/******* Ajout MAPPING guillaume.grason@diplomatie.gouv.fr *******/
		if ($statut_nouv != $statut_article) {
			$mappings = $mapping->getMappings($articleMetier->getArticleId());
			if ( PEAR::isError($mappings) ) {
				die($mappings->getMessage());
			}
			else {
				for ($i = 0; $i < count($mappings); $i++) {
					$loadOK = $mappingMetier->load($mappings[$i]);
					if (PEAR :: isError($loadOK)) {
						die($loadOK->getMessage());
					} else {
						if ($statut_nouv == 'publie')
							$mappingMetier->setStatut('mappe');
						else
							$mappingMetier->setStatut('map_off');
						$updateOK = $mappingMetier->update();
						if (PEAR :: isError($updateOK)) {
							die($updateOK->getMessage());
						}
					}
				}
			}
		}
		/******* Fin Ajout MAPPING guillaume.grason@diplomatie.gouv.fr *******/

		$statut_ancien = $statut_article; // message pour les traitements de fond (indexation ; envoi mail)
		$statut_article = $statut_nouv;
		//--------Zone de modifications Clever Age elebescond-------------
		//$authorization = &recuperer_instance_authorization();
		//$flag_editable = ($authorization->isAuthorized($GLOBALS['connect_id_auteur'], 'isManagedRubriqueByAuteurId', array('rubriqueId' => $rubrique_article))
		//OR ($flag_auteur AND ($statut_article == 'prepa' OR $statut_article == 'prop')));
		/*
		$flag_editable = (acces_rubrique($rubrique_article)
			OR ($flag_auteur AND ($statut_article == 'prepa' OR $statut_article == 'prop')));
		*/
		//--------Fin Zone de modifications Clever Age elebescond-------------

	}
}


// Passer les images/docs en "inclus=non"
//----------------Zone de modifications Clever Age aangenieux----------
$documentMetier = & recuperer_instance_document();
$ze_doc = $documentMetier->getAlldocumentIdsForArticleId($id_article);

if (PEAR :: isError($ze_doc)) {
	die($ze_doc->getMessage());
}
/*
$query = "SELECT docs.id_document FROM spip_documents AS docs, spip_documents_articles AS lien WHERE lien.id_article=$id_article AND lien.id_document=docs.id_document";
$result = spip_query($query);
while($row=spip_fetch_array($result)){
	$ze_doc[]=$row['id_document'];
}
*/
//----------------Fin de zone de modifications--------------------------

if (count($ze_doc) > 0) {
	$ze_docs = join($ze_doc, ",");
	//----------------Zone de modifications Clever Age aangenieux----------
	$documentMetier = & recuperer_instance_document();
	$updateOK = $documentMetier->updateInclusForDocumentIds('non', $ze_docs);
	if (PEAR :: isError($updateOK)) {
		die($updateOK->getMessage());
	}
	/*
	spip_query("UPDATE spip_documents SET inclus='non' WHERE id_document IN ($ze_docs)");
	*/
	//----------------Fin de zone de modifications--------------------------
}

//
// Reunit les textes decoupes parce que trop longs
//
// patch David Charbonnier  tester 
$nb_texte = 0;
while ($nb_texte ++ < 100) { // 100 pour eviter une improbable boucle infinie
	$varname = "texte$nb_texte";
	$texte_plus = $$varname; // double $ pour obtenir $texte1, $texte2...
	if ($texte_plus) {
		$texte_ajout .= " ".$texte_plus;
	} else {
		break;
	}
}
$texte = $texte_ajout.$texte;
/*
$nb_texte = 0;
while ($nb_texte ++ < 100){		// 100 pour eviter une improbable boucle infinie
	$varname = "texte$nb_texte";
	$texte_plus = $$varname;	// double $ pour obtenir $texte1, $texte2...
	if ($texte_plus){
		$texte_plus = ereg_replace("<!--SPIP-->[\n\r]*","\n\n\n",$texte_plus);
		$texte_ajout .= " ".$texte_plus;
	} else {
		break;
	}
}
$texte = $texte_ajout . $texte;
*/
// fin patch 

// preparer le virtuel
if ($changer_virtuel && $flag_editable) {
	$virtuel = eregi_replace("^http://$", "", trim($virtuel));
	if ($virtuel)
		$chapo = addslashes(corriger_caracteres("=$virtuel"));
	else
		$chapo = "";

	//-----------MODIFICATION CLEVER AGE

	$articleMetier->setChapo($chapo);

	$updateOK = $articleMetier->update();

	if (PEAR :: isError($updateOK)) {
		die(PEAR :: isError($updateOK));
	}

	/*
	$query = "UPDATE spip_articles SET chapo=\"$chapo\" WHERE id_article=$id_article";
	$result = spip_query($query);
	*/
	//-----------FIN MODIFICATION CLEVER AGE

}


if ($titre && !$ajout_forum && $flag_editable) {
	// ajout de l'entre dans la table historique 
	if (($activer_histo_articles == 'oui') && ($articleMetier->getActiverHistorique() == 'oui')) {
		$articleMetier->create_historique ();
	}
	
	//------MODIFICATION CLEVER AGE
	$articleMetier->setSurtitre($surtitre);
	$articleMetier->setTitre($titre);
	$articleMetier->setSoustitre($soustitre);
	$articleMetier->setDescriptif($descriptif);
	$articleMetier->setNomSite($nom_site);
	$articleMetier->setUrlSite($url_site);
	$articleMetier->setChapo($chapo);
	$articleMetier->setTexte($texte);
	$articleMetier->setPs($ps);
	/*
	$surtitre = addslashes(corriger_caracteres($surtitre));
	$titre = addslashes(corriger_caracteres($titre));
	$soustitre = addslashes(corriger_caracteres($soustitre));
	$descriptif = addslashes(corriger_caracteres($descriptif));
	$nom_site = addslashes(corriger_caracteres($nom_site));
	$url_site = addslashes(corriger_caracteres($url_site));
	$chapo = addslashes(corriger_caracteres($chapo));
	$texte = addslashes(corriger_caracteres($texte));
	$ps = addslashes(corriger_caracteres($ps));
	*/

	// recoller les champs du extra
	if ($champs_extra) {
		include_ecrire("inc_extra.php3");
		//-------MODIFICATION CLEVER AGE --- AANGENIEUX --- Gestion extra -------
		$add_extra = extra_recup_saisie("articles", $id_secteur);
		/*
		$add_extra = ", extra = '".addslashes(extra_recup_saisie("article", $id_secteur))."'";
		*/
	} else
		$add_extra = '';

	$articleMetier->setExtra($add_extra);
	//--------------FIN DE MODIFICATION CA---------------------------

	// Verifier qu'on envoie bien dans une rubrique autorisee

	//--------Zone de modifications Clever Age elebescond-------------
	$authorization = & recuperer_instance_authorization('isManagedRubriqueByAuteurId', $GLOBALS['connect_id_auteur'], array ('rubriqueId' => $rubrique_article));
	if ($flag_auteur OR $authorization->isAuthorizedAction()) {
		$articleMetier->setRubriqueId($id_rubrique);
	}

	/*
	if ($flag_auteur OR acces_rubrique($id_rubrique)) {
		//$change_rubrique = "id_rubrique=\"$id_rubrique\",";
	}
	*/
	//--------Fin Zone de modifications Clever Age elebescond-------------

	/*
	} else {
		$change_rubrique = "";
	}
	*/
	$updateOK = $articleMetier->update();

	if (PEAR :: isError($updateOK)) {
		die(PEAR :: isError($updateOK));
	}
	/******* Ajout MAPPING guillaume.grason@diplomatie.gouv.fr *******/
	$mappings = $mapping->getMappings($articleMetier->getArticleId());
	if ( PEAR::isError($mappings) ) {
		die($mappings->getMessage());
	}
	else {
		for ($i = 0; $i < count($mappings); $i++) {
			$loadOK = $mappingMetier->load($mappings[$i]);
			if (PEAR :: isError($loadOK)) {
				die($loadOK->getMessage());
			} else {
				$mappingMetier->setSurtitre($articleMetier->getSurtitre());
				//$mappingMetier->setTitre($articleMetier->getTitre());
				$mappingMetier->setSoustitre($articleMetier->getSoustitre());
				//$mappingMetier->setDescriptif($articleMetier->getDescriptif());
				$mappingMetier->setNomSite($articleMetier->getNomSite());
				$mappingMetier->setUrlSite($articleMetier->getUrlSite());
				$mappingMetier->setChapo($articleMetier->getChapo());
				$mappingMetier->setTexte($articleMetier->getTexte());
				$mappingMetier->setPs($articleMetier->getPs());
				$mappingMetier->setExtra($articleMetier->getExtra());
				$updateOK = $mappingMetier->update();
				if (PEAR :: isError($updateOK)) {
					die($updateOK->getMessage());
				}
			}
		}
	}
	/******* Fin Ajout MAPPING guillaume.grason@diplomatie.gouv.fr *******/
	/*
	$query = "UPDATE spip_articles SET surtitre=\"$surtitre\", titre=\"$titre\", soustitre=\"$soustitre\", $change_rubrique descriptif=\"$descriptif\", chapo=\"$chapo\", texte=\"$texte\", ps=\"$ps\", url_site=\"$url_site\", nom_site=\"$nom_site\" $add_extra WHERE id_article=$id_article";
	$result = spip_query($query);
	*/
	//----------FIN MODIFICATION CLEVER AGE
	
	// modifications Olivier Mansour 
	// reports de ces actions en bas de script
	/* 
	calculer_rubriques();
	*/
	// fin modifications Olivier Mansour
	/* Ajout Clever Age / Nicolas Hoizey / R�f�rencement des liens */
	$contenu = $surtitre.$titre.$soustitre.$descriptif.$chapo.$texte.$ps;
	if ($champs_extra)
		$contenu .= addslashes(extra_recup_saisie('article', $id_secteur));
	update_liens($contenu, 'art-'.$id_article);
	/* fin zone de modification Clever Age */


	if ($statut_article == 'publie')
		$reindexer = true;

	// Changer la langue heritee
	if ($articleMetier->getRubriqueId() != $id_rubrique_old) {
		/**************** Modification elebescond@clever-age.com *************************************/
		$loadOK = $articleMetier->load($id_article);
		if (PEAR :: isError($loadOK)) {
			die($loadOK->getMessage());
		}
		$langue_old = $articleMetier->getLang();
		$langue_choisie_old = $articleMetier->getLangChoisie();
		/*
		$row = spip_fetch_array(spip_query("SELECT lang, langue_choisie FROM spip_articles WHERE id_article=$id_article"));
		$langue_old = $row['lang'];
		$langue_choisie_old = $row['langue_choisie'];
		*/
		/**************** Fin modification elebescond@clever-age.com *************************************/

		/**************** Modification elebescond@clever-age.com *************************************/
		if ($langue_choisie_old != "oui") {
			$rubriqueMetier = & recuperer_instance_rubrique();
			$loadOK = $rubriqueMetier->load($articleMetier->getRubriqueId());
			if (PEAR :: isError($loadOK)) {
				die($loadOK->getMessage());
			}
			$langue_new = $rubriqueMetier->getLang();
			if ($langue_new != $langue_old) {
				$articleMetier->setLang($langue_new);
				$updateOK = $articleMetier->update();
				if (PEAR :: isError($updateOK)) {
					die($updateOK->getMessage());
				}
				/******* Ajout MAPPING guillaume.grason@diplomatie.gouv.fr *******/
				$mappings = $mapping->getMappings($articleMetier->getArticleId());
				if ( PEAR::isError($mappings) ) {
					die($mappings->getMessage());
				}
				else {
					for ($i = 0; $i < count($mappings); $i++) {
						$loadOK = $mappingMetier->load($mappings[$i]);
						if (PEAR :: isError($loadOK)) {
							die($loadOK->getMessage());
						} else {
							$mappingMetier->setLang($articleMetier->getLang());
							$updateOK = $mappingMetier->update();
							if (PEAR :: isError($updateOK)) {
								die($updateOK->getMessage());
							}
						}
					}
				}
				/******* Fin Ajout MAPPING guillaume.grason@diplomatie.gouv.fr *******/
			}
		}
		/*
		if ($langue_choisie_old != "oui") {
			$row = spip_fetch_array(spip_query("SELECT lang FROM spip_rubriques WHERE id_rubrique=$id_rubrique"));
			$langue_new = $row['lang'];
			if ($langue_new != $langue_old) spip_query("UPDATE spip_articles SET lang = '$langue_new' WHERE id_article = $id_article");
		}
		*/
		/**************** Fin modification elebescond@clever-age.com *************************************/
	}

	// afficher le nouveau titre dans la barre de fenetre
	$titre_article = stripslashes($titre);

	//-----------MODIFICATION CLEVER AGE

	// marquer l'article (important pour les articles nouvellement crees)
	$maDate = new Date();
	$articleMetier->setModificationDate($maDate->getDate(DATE_FORMAT_ISO));
	//$articleMetier->setModificationDate('NOW()');
	$articleMetier->setAuteurModif($connect_id_auteur);
	$updateOK = $articleMetier->update();

	if (PEAR :: isError($updateOK)) {
		die(PEAR :: isError($updateOK));
	}
	/******* Ajout MAPPING guillaume.grason@diplomatie.gouv.fr *******/
	$mappings = $mapping->getMappings($articleMetier->getArticleId());
	if ( PEAR::isError($mappings) ) {
		die($mappings->getMessage());
	}
	else {
		for ($i = 0; $i < count($mappings); $i++) {
			$loadOK = $mappingMetier->load($mappings[$i]);
			if (PEAR :: isError($loadOK)) {
				die($loadOK->getMessage());
			} else {
				$mappingMetier->setModificationDate($articleMetier->getModificationDate());
				$mappingMetier->setAuteurModif($articleMetier->getAuteurModif());
				$updateOK = $mappingMetier->update();
				if (PEAR :: isError($updateOK)) {
					die($updateOK->getMessage());
				}
			}
		}
	}
	/******* Fin Ajout MAPPING guillaume.grason@diplomatie.gouv.fr *******/

	/*
	spip_query("UPDATE spip_articles SET date_modif=NOW(), auteur_modif=$connect_id_auteur WHERE id_article=$id_article");
	*/
	$id_article_bloque = $id_article; // message pour inc_presentation
	
	
	
}

// remplacement par une sous version de l'historique
if ($flag_editable and $id_article_historique_replace and ($activer_histo_articles == 'oui') and ($articleMetier->getActiverHistorique() == 'oui')) {
    $articleMetier->create_historique ();
	$articleMetier->switchHistorique($id_article_historique_replace);
}
//----------FIN MODIFICATION CLEVER AGE

//
// Suivi forums publics
//

// fonction dupliquee dans inc-forum.php3
function get_forums_publics($id_article = 0) {

	$forums_publics = lire_meta("forums_publics");
	if ($id_article) {
		//------------MODIFICATION CLEVER AGE
        $articleMetier = & recuperer_instance_article();
		$loadOK = $articleMetier->loadLightWeight($id_article);
		/*
		$query = "SELECT accepter_forum FROM spip_articles WHERE id_article=$id_article";
		$res = spip_query($query);
		*/

		if ( PEAR::isError($loadOK) ) {
			die($loadOK->getMessage());
		} else {
			$forums_publics = $articleMetier->getAccepterForum();
		}
		/*
		if ($obj = spip_fetch_object($res))
			$forums_publics = $obj->accepter_forum;
		*/
		//-----------FIN MODIFICATION CLEVER AGE

	} else { // dans ce contexte, inutile
		$forums_publics = substr(lire_meta("forums_publics"), 0, 3);
	}
	return $forums_publics;
}

//
// Lire l'article
//

//----------MODIFICATION CLEVER AGE
if ($articleMetier->getArticleId() == $id_article) { //Test si article charg� OK
	$surtitre = $articleMetier->getSurtitre();
	$titre = $articleMetier->getTitre();
	$soustitre = $articleMetier->getSoustitre();
	$id_rubrique = $articleMetier->getRubriqueId();
	$descriptif = $articleMetier->getDescriptif();
	$chapo = $articleMetier->getChapo();
	$texte = $articleMetier->getTexte();
	$ps = $articleMetier->getPs();
	$date = $articleMetier->getDate();
	$statut_article = $articleMetier->getStatut();
	$maDate = new Date($articleMetier->getMajDate());
	$maj = $maDate->getDate(DATE_FORMAT_TIMESTAMP);
	//$maj = $articleMetier->getMajDate();
	$date_redac = $articleMetier->getRedactionDate();
	$visites = $articleMetier->getVisites();
	$referers = $articleMetier->getReferers();
	$extra = $articleMetier->getExtra();
	$id_trad = $articleMetier->getTradId();
}

/*
$query = "SELECT * FROM spip_articles WHERE id_article='$id_article'";
$result = spip_query($query);

if ($row = spip_fetch_array($result)) {
	$id_article = $row["id_article"];
	$surtitre = $row["surtitre"];
	$titre = $row["titre"];
	$soustitre = $row["soustitre"];
	$id_rubrique = $row["id_rubrique"];
	$descriptif = $row["descriptif"];
	$nom_site = $row["nom_site"];
	$url_site = $row["url_site"];
	$chapo = $row["chapo"];
	$texte = $row["texte"];
	$ps = $row["ps"];
	$date = $row["date"];
	$statut_article = $row["statut"];
	$maj = $row["maj"];
	$date_redac = $row["date_redac"];
	$visites = $row["visites"];
	$referers = $row["referers"];
	$extra = $row["extra"];
	$id_trad = $row["id_trad"];
}
*/

//----------FIN MODIFICATION CLEVER AGE

// pour l'affichage du virtuel
unset ($virtuel);
if (substr($chapo, 0, 1) == '=') {
	$virtuel = substr($chapo, 1);
}

if (ereg("([0-9]{4})-([0-9]{2})-([0-9]{2})", $date_redac, $regs)) {
	$mois_redac = $regs[2];
	$jour_redac = $regs[3];
	$annee_redac = $regs[1];
	if ($annee_redac > 4000)
		$annee_redac -= 9000;
}

if (ereg("([0-9]{4})-([0-9]{2})-([0-9]{2})", $date, $regs)) {
	$mois = $regs[2];
	$jour = $regs[3];
	$annee = $regs[1];
}

debut_page("&laquo; $titre_article &raquo;", "documents", "articles");

debut_grand_cadre();
afficher_parents($articleMetier->getRubriqueId());
$parents = "~ <img src='img_pack/racine-site-24.gif' width=24 height=24 align='middle'> <A HREF='naviguer.php3?coll=0'><B>"._T('lien_racine_site')."</B></A> ".aide("rubhier")."<BR>".$parents;
$parents = ereg_replace("~", "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;", $parents);
$parents = ereg_replace("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; ", "", $parents);
echo "$parents";

fin_grand_cadre();

//////////////////////////////////////////////////////
// Affichage de la colonne de gauche
//

debut_gauche();

debut_boite_info();

echo "<div align='center'>\n";

if ($statut_article == "publie") {
	$post_dates = lire_meta("post_dates");
	$voir_en_ligne = true;
	if ($post_dates == "non") {

		//---------MODIFICATION CLEVER AGE

		if ($articleMetier->isPostDated()) {
			$voir_en_ligne = false;
		}

		/*
		$query = "SELECT id_article FROM spip_articles WHERE id_article=$id_article AND date<=NOW()";
		$result = spip_query($query);
		if (!spip_num_rows($result)) {
			$voir_en_ligne = false;
		}
		*/

		//----------FIN MODIFICATION CLEVER AGE

	}
}

/******* Ajout PREVIEW guillaume.grason@diplomatie.gouv.fr *******/
if (($statut_article == 'valid') or ($statut_article == 'prepa') or ($statut_article == 'prop') or ($statut_article == 'map_off'))
	$previsualiser = true;
if ($statut_article == 'mappe')
	$voir_en_ligne = true;
/******* Fin Ajout PREVIEW guillaume.grason@diplomatie.gouv.fr *******/
/*********** Modification elebescond@clever-age.com *********************/
echo "<font face='Verdana,Arial,Sans,sans-serif' size='1'><b>"._T('art_info_numero_article', null, $articleMetier->getRubriqueId())."</b></font>\n";
/*
echo "<font face='Verdana,Arial,Sans,sans-serif' size='1'><b>"._T('info_numero_article')."</b></font>\n";
*/
/*********** Fin modification elebescond@clever-age.com *********************/
echo "<br><font face='Verdana,Arial,Sans,sans-serif' size='6'><b>$id_article</b></font>\n";
if ($voir_en_ligne) {
	icone_horizontale(_T('icone_voir_en_ligne'), "../spip_redirect.php3?id_article=$id_article&recalcul=oui", "racine-24.gif", "rien.gif");
	//icone_horizontale(_T('icone_voir_en_pdf'), "../spip_redirect.php3?id_article_pdf=$id_article&recalcul=oui", "pdf-24.png", "rien.gif");
}
/******* Ajout PREVIEW guillaume.grason@diplomatie.gouv.fr *******/
elseif ($previsualiser) {
	icone_horizontale(_T('icone_previsualiser'), "../spip_redirect.php3?id_article=$id_article&preview=oui", "racine-24.gif", "rien.gif");
}
/******* Fin Ajout PREVIEW guillaume.grason@diplomatie.gouv.fr *******/

//----------------Zone de modifications Clever Age elebescond@clever-age.com----------
$authorization = & recuperer_instance_authorization( 'afficherSuiviForumArticle', 
                                                     $GLOBALS['connect_id_auteur'], 
                                                     array ('id_rubrique' => $articleMetier->getRubriqueId()) );
if ($authorization->isAuthorizedAction()) {
	/*
	if ($connect_statut=='minirezo' AND acces_rubrique($id_rubrique)) {
	*/
	//----------------FIN Zone de modifications Clever Age elebescond----------
	//----------Modification Clever Age elebescond@clever-age.com-----------------
	$forumMetier = & recuperer_instance_forum();
	$nb_forums = $forumMetier->howManyForumForArticleIdAndStatuts($id_article, "'publie', 'off', 'prop'");
	if (PEAR :: isError($nb_forums)) {
		die($nb_forums->getMessage());
	}
	if ($nb_forums) {
		icone_horizontale(_T('icone_suivi_forum', array ('nb_forums' => $nb_forums)), "controle_forum_suite.php3?affType=discussion&affMessage[]=tout&vierge=1&id_current_forum=$id_article&type_forum=article", "suivi-forum-24.gif", "");
	}
	/*
	$query = "SELECT count(*) AS count FROM spip_forum WHERE id_article=$id_article AND statut IN ('publie', 'off', 'prop')";
	if ($row = spip_fetch_array(spip_query($query))) {
		$nb_forums = $row['count'];
		if ($nb_forums) {
			icone_horizontale(_T('icone_suivi_forum', array('nb_forums' => $nb_forums)),
				"articles_forum.php3?id_article=$id_article", "suivi-forum-24.gif", "");
		}
	}
	*/
	//---------Fin modification Clever Age-------------------
}

$activer_statistiques = lire_meta("activer_statistiques");
$activer_statistiques_ref = lire_meta("activer_statistiques_ref");

//----------------Zone de modifications Clever Age elebescond@clever-age.com----------
$authorization = & recuperer_instance_authorization('afficherIconeEvolutionVisites', $GLOBALS['connect_id_auteur'], array ('statut_article' => $statut_article, 'visites' => $visites, 'activer_statistiques' => $activer_statistiques, 'options' => $options));
if ($authorization->isAuthorizedAction()) {
	/*
	if ($connect_statut == "minirezo" AND $statut_article == 'publie' AND $visites > 0 AND $activer_statistiques != "non" AND $options == "avancees") {
	*/
	//----------------FIN Zone de modifications Clever Age elebescond----------	icone_horizontale(_T('icone_evolution_visites', array('visites' => $visites, 'aff_ref' => $aff_ref)), "statistiques_visites.php3?id_article=$id_article", "statistiques-24.gif","rien.gif");
}
echo "</div>\n";
fin_boite_info();


// Logos du mapping

$arton = "arton$id_article";
$artoff = "artoff$id_article";

if ($id_article > 0 AND $flag_editable)
	afficher_boite_logo($arton, $artoff, _T('art_logo_mapping', null, $articleMetier->getRubriqueId()).aide("logoart"), _T('logo_survol'));

$authorization = & recuperer_instance_authorization('afficherBoiteConfigurationAvancee', $GLOBALS['connect_id_auteur'], array ('options' => $options, 'flag_editable' => $flag_editable));
if ($authorization->isAuthorizedAction()) {
	// Redirection (article virtuel)
	debut_cadre_relief("site-24.gif");
	$visible = ($changer_virtuel || $virtuel);
	
	echo "<font size='2' FACE='Verdana,Arial,Sans,sans-serif'><center><b>";
	if ($visible)
		echo bouton_block_visible("redirection");
	else
		echo bouton_block_invisible("redirection");
	echo _T('bouton_redirection');
	echo aide("artvirt");
	echo "</b></center></font>";
	if ($visible)
		echo debut_block_visible("redirection");
	else
		echo debut_block_invisible("redirection");
	
	echo "<form action='mapping_articles.php3?id_article=$id_article' method='post'>";
	echo "\n<INPUT TYPE='hidden' NAME='id_article' VALUE='$id_article'>";
	echo "\n<INPUT TYPE='hidden' NAME='changer_virtuel' VALUE='oui'>";
	$virtuelhttp = ($virtuel ? "" : "http://");
	
	echo "<INPUT TYPE='text' NAME='virtuel' CLASS='formo' style='font-size:9px;' VALUE=\"$virtuelhttp$virtuel\" SIZE='40'><br>";
	echo "<font face='Verdana,Arial,Sans,sans-serif' size=2>";
	/************* Modification elebescond@clever-age.com *******************/
	echo "(<b>"._T('art_texte_article_virtuel', null, $articleMetier->getRubriqueId() )."&nbsp;:</b> "._T('art_texte_reference_mais_redirige', null, $articleMetier->getRubriqueId() ).")";
	/*
	echo "(<b>"._T('texte_article_virtuel')."&nbsp;:</b> "._T('texte_reference_mais_redirige').")";
	*/
	/************* Fin modification elebescond@clever-age.com *******************/
	echo "</font>";
	echo "<div align='right'><INPUT TYPE='submit' NAME='Changer' CLASS='fondo' VALUE='"._T('bouton_changer')."' STYLE='font-size:10px'></div>";
	echo "</form>";
	echo fin_block();
	
	fin_cadre_relief();
}

//
// Afficher les raccourcis
//

debut_raccourcis();
icone_horizontale(_T('icone_tous_articles'), "articles_page.php3", "article-24.gif");
/////////////////////////////
// Modifier l'article parent
//
icone_horizontale(_T('art_icone_modifier_article_parent', null, $coll), "articles.php3?id_article=$id_article_parent&", "article-24.gif","edit.gif");
////////////////////////////////
// Supprimer le mapping courant 
echo "<form name='mapping' method='post' action='do_mapping.php3'>\n";
echo "<a href='#' OnClick='document.forms[\"mapping\"].submit();' class='cellule-h'><table cellpadding='0' valign='middle'><tr>\n";
echo "<td><a href='#' OnClick='document.forms[\"mapping\"].submit();'><div class='cell-i'><img style='background: url(\"img_pack/article-24.gif\"); background-repeat: no-repeat; background-position: center center;' src='img_pack/supprimer.gif' alt='' border='0'></div></a></td>\n";
echo "<td class='cellule-h-lien'><a href='#' OnClick='document.forms[\"mapping\"].submit();' class='cellule-h'>"._T('art_icone_supprimer_mapping', null, $coll)."</a></td>\n";
echo "</tr></table></a>\n";
echo "<input type='hidden' name='id_map' value ='$id_article' />\n";
echo "<input type='hidden' name='id_action' value='0'>\n";
echo "<input type='hidden' name='id_article' value='$id_article_parent'>\n";
echo "</form>";
// Fin supprimer le mappage courant
//////////////////////////////////
fin_raccourcis();

//////////////////////////////////////////////////////
// Affichage de la colonne de droite
//

debut_droite();

$strErr = displayErrorMsg(getErrorMsg('article', $articleMetier));
if ($strErr) {
	debut_cadre_relief();
	// Ajout Aurelien Vialet <avialet@clever-age.com> Gestion des erreur sur les champs/Gestion des champs de formulaires
	echo $strErr;
	// Fin de l'ajout Aurelien Vialet
	fin_cadre_relief();
}

changer_typo('', 'article'.$id_article);

// qu'est-ce que c'est que ces choses ??

function mySel($varaut, $variable) {
	$retour = " VALUE=\"$varaut\"";
	if ($variable == $varaut) {
		$retour .= " SELECTED";
	}
	return $retour;
}

function my_sel($num, $tex, $comp) {
	if ($num == $comp) {
		echo "<OPTION VALUE='$num' SELECTED>$tex\n";
	} else {
		echo "<OPTION VALUE='$num'>$tex\n";
	}

}

function afficher_mois($mois) {
	my_sel("00", _T('mois_non_connu'), $mois);
	my_sel("01", _T('date_mois_1'), $mois);
	my_sel("02", _T('date_mois_2'), $mois);
	my_sel("03", _T('date_mois_3'), $mois);
	my_sel("04", _T('date_mois_4'), $mois);
	my_sel("05", _T('date_mois_5'), $mois);
	my_sel("06", _T('date_mois_6'), $mois);
	my_sel("07", _T('date_mois_7'), $mois);
	my_sel("08", _T('date_mois_8'), $mois);
	my_sel("09", _T('date_mois_9'), $mois);
	my_sel("10", _T('date_mois_10'), $mois);
	my_sel("11", _T('date_mois_11'), $mois);
	my_sel("12", _T('date_mois_12'), $mois);
}

function afficher_annee($annee) {
	// Cette ligne permettrait de faire des articles sans date de publication
	// my_sel("0000","n.c.",$annee);

	if ($annee < 1996 AND $annee <> 0) {
		echo "<OPTION VALUE='$annee' SELECTED>$annee\n";
	}
	for ($i = 1996; $i < date(Y) + 2; $i ++) {
		my_sel($i, $i, $annee);
	}
}

function afficher_jour($jour) {
	my_sel("00", _T('jour_non_connu_nc'), $jour);
	for ($i = 1; $i < 32; $i ++) {
		if ($i < 10) {
			$aff = "&nbsp;".$i;
		} else {
			$aff = $i;
		}

        $d = strlen($i) == 1 ? '0'.$i : $i;
		my_sel( $d , $aff, $jour );
	}
}

function afficher_heure( $heure ) {
    my_sel( '', _T('heure_non_connu_nc'), $heure );
    for ( $i = 0; $i < 24; $i++ ) {
        $h = strlen($i) == 1 ? '0'.$i : $i;
        my_sel( $h, $h, $heure );
    }
}

function afficher_minute( $minute ) {
    my_sel( '', _T('minute_non_connu_nc'), $minute );
    for ( $i = 0; $i < 60; $i++ ) {
        $m = strlen($i) == 1 ? '0'.$i : $i;
        my_sel( $m, $m, $minute );
    }
}

debut_cadre_relief();
echo "<CENTER>";

//
// Titre, surtitre, sous-titre
//

if ($statut_article == 'publie') {
	$logo_statut = "puce-verte.gif";
} else // TODO : un bon switch case fera l'affaire
	if ($statut_article == 'prepa') {
		$logo_statut = "puce-blanche.gif";
	} else
		if ($statut_article == 'prop') {
			$logo_statut = "puce-orange.gif";
		} else
			if ($statut_article == 'valid') {
				$logo_statut = "puce-jaune.gif";
			} else
				if ($statut_article == 'archi') {
					$logo_statut = "puce-marron.gif";
				} else
					if ($statut_article == 'refuse') {
						$logo_statut = "puce-rouge.gif";
					} else
						if ($statut_article == 'poubelle') {
							$logo_statut = "puce-poubelle.gif";
						}

echo "\n<table cellpadding=0 cellspacing=0 border=0 width='100%'>";
echo "<tr width='100%'><td width='100%' valign='top'>";
if ($surtitre) {
	echo "<span $dir_lang><font face='arial,helvetica' size=3><b>";
	echo typo($surtitre);
	echo "</b></font></span>\n";
}
gros_titre($titre, $logo_statut);

if ($soustitre) {
	echo "<span $dir_lang><font face='arial,helvetica' size=3><b>";
	echo typo($soustitre);
	echo "</b></font></span>\n";
}

// TODO : c'est super moche !
$nom_site = $articleMetier->getNomSite();
$url_site = $articleMetier->getUrlSite();
if ($descriptif OR $url_site OR $nom_site) {
	echo "<p><div align='left' style='padding: 5px; border: 1px dashed #aaaaaa; background-color: #e4e4e4;' $dir_lang>";
	echo "<font size=2 face='Verdana,Arial,Sans,sans-serif'>";
	/********** Modification elebescond@clever-age.com ********************/
	$texte_case = ($descriptif) ? "{{"._T('art_info_descriptif', null, $articleMetier->getRubriqueId())."}} $descriptif\n\n" : '';
	/*
	$texte_case = ($descriptif) ? "{{"._T('info_descriptif')."}} $descriptif\n\n" : '';
	*/
	/********** Fin modification elebescond@clever-age.com ********************/
	$texte_case .= ($nom_site.$url_site) ? "{{"._T('info_urlref')."}} [".$nom_site."->".$url_site."]" : '';
	echo propre($texte_case);
	echo "</font>";
	echo "</div>";
}

if ($statut_article == 'prop') {
	/********** Modification elebescond@clever-age.com ********************/
	echo "<P><FONT FACE='Verdana,Arial,Sans,sans-serif' SIZE=2 COLOR='red'><B>"._T('art_text_article_propose_publication', null, $articleMetier->getRubriqueId())."</B></FONT></P>";
	/*
	echo "<P><FONT FACE='Verdana,Arial,Sans,sans-serif' SIZE=2 COLOR='red'><B>"._T('text_article_propose_publication')."</B></FONT></P>";
	*/
	/********** Fin modification elebescond@clever-age.com ********************/
}

echo "</td>";



if ($flag_editable) {
	echo "<td><img src='img_pack/rien.gif' width=5></td>\n";
	echo "<td align='center'>";
	//-----------MODIFICATION CLEVER AGE-----------
	if (lire_meta('articles_modif') != 'non') {
		$flag_modif = !($articleMetier->hasLastModified($connect_id_auteur));
		$date_diff = $articleMetier->whenWasModified();
		$auteur_modif = $articleMetier->getAuteurModif();
		if ($flag_modif) {
			$nom_auteur_modif = $articleMetier->getLastModifiedUserName();
		}

	}


	$authorization = & recuperer_instance_authorization('modifierArticle', $GLOBALS['connect_id_auteur'], array ('id_article' => $id_article));
	if ($authorization->isAuthorizedAction()) {
		/******* Modification MAPPING guillaume.grason@diplomatie.gouv.fr *******/
		if ($statut_article == 'mappe' || $statut_article == 'map_off') {
			icone(_T('art_icone_modifier_mapping', null, $articleMetier->getRubriqueId()), "mappings_edit.php3?id_article=$id_article", "article-24.gif", "edit.gif");
			if ($flag_modif) {
				echo "<font face='arial,helvetica,sans-serif' size='2'>"._T('avis_mapping_modifie', array ('nom_auteur_modif' => $nom_auteur_modif, 'date_diff' => $date_diff))."</font>";
				echo aide("artmodif");
			}
		}
		else {
			icone(_T('art_icone_modifier_article', null, $articleMetier->getRubriqueId()), "articles_edit.php3?id_article=$id_article", "article-24.gif", "edit.gif");
			if ($flag_modif) {
				echo "<font face='arial,helvetica,sans-serif' size='2'>"._T('avis_article_modifie', array ('nom_auteur_modif' => $nom_auteur_modif, 'date_diff' => $date_diff))."</font>";
				echo aide("artmodif");
			}
		}
		/*
		if ($flag_modif) {
			icone(_T('art_icone_modifier_article', null, $articleMetier->getRubriqueId()), "articles_edit.php3?id_article=$id_article", "article-24.gif", "edit.gif");
			echo "<font face='arial,helvetica,sans-serif' size='2'>"._T('avis_article_modifie', array ('nom_auteur_modif' => $nom_auteur_modif, 'date_diff' => $date_diff))."</font>";
			echo aide("artmodif");
		} else {
			icone(_T('art_icone_modifier_article', null, $articleMetier->getRubriqueId()), "articles_edit.php3?id_article=$id_article", "article-24.gif", "edit.gif");
		}
		*/
		/******* Fin Modification MAPPING guillaume.grason@diplomatie.gouv.fr *******/
	}
	echo "</td>";
}
echo "</tr></table>\n";

echo "<div class='serif' align='left'>";


//
// Affichage date redac et date publi
//

if ($flag_editable AND $options == 'avancees') {
	debut_cadre_enfonce();

	echo "<FORM ACTION='articles.php3' METHOD='get'>";
	echo "<INPUT TYPE='hidden' NAME='id_article' VALUE='$id_article'>";

	/* Modification Clever Age, elebescond */
	$authorization = & recuperer_instance_authorization('modifierDatePublicationArticle', $GLOBALS['connect_id_auteur'], array ('id_article' => $id_article));
	if ($authorization->isAuthorizedAction()) {
        if ( $datetime = $articleMetier->getDate() ) {
            list($date, $time) = explode( ' ', $datetime );
            list($annee, $mois, $jour) = explode( '-', $date );
            list($heure, $minute, $seconde) = explode( ':', $time );
            $heure = $heure ? $heure : '00';
            $minute = $minute ? $minute : '00';
        }
		/*
		if ($statut_article == 'publie') {
		*/
		/* Fin Modification Clever Age */
		echo "<TABLE CELLPADDING=5 CELLSPACING=0 BORDER=0 WIDTH=100% BACKGROUND=''>";
		echo "<TR><TD BGCOLOR='$couleur_foncee' COLSPAN=2><FONT SIZE=1 COLOR='#FFFFFF'><B>"._T('texte_date_publication_article');
		echo aide("artdate");
		echo "</B></FONT></TD></TR>";
		echo "<TR><TD ALIGN='center'>";
		echo "<SELECT NAME='jour' SIZE=1 CLASS='fondl'>";
		afficher_jour($jour);
		echo "</SELECT> ";
		echo "<SELECT NAME='mois' SIZE=1 CLASS='fondl'>";
		afficher_mois($mois);
		echo "</SELECT> ";
		echo "<SELECT NAME='annee' SIZE=1 CLASS='fondl'>";
		afficher_annee($annee);
		echo "</SELECT>";
        if ( lire_meta('activer_horaire_publication_etendu') == 'oui' ) {
            echo "<br /><SELECT NAME='heure' SIZE=1 CLASS='fondl'>";
            afficher_heure($heure);
            echo "</SELECT> ";
            echo "<SELECT NAME='minute' SIZE=1 CLASS='fondl'>";
            afficher_minute($minute);
            echo "</SELECT> ";
        }
		/******* Ajout MAE guillaume.grason@diplomatie.gouv.fr *******/
		else {
			echo "<input type='hidden' name='heure' value='00'>";
			echo "<input type='hidden' name='minute' value='00'>";
		}
		/******* Fin Ajout MAE guillaume.grason@diplomatie.gouv.fr *******/
		echo "</TD><TD ALIGN='right'>";
		echo "<INPUT TYPE='submit' NAME='Changer' CLASS='fondo' VALUE='"._T('bouton_changer')."'>";
		echo "</TD></TR></TABLE>";
	} else {
		echo "<TABLE CELLPADDING=5 CELLSPACING=0 BORDER=0 WIDTH=100% BACKGROUND=''>";
		/******* Modification MAPPING guillaume.grason@diplomatie.gouv.fr *******/
		if ($statut_article == 'mappe' || $statut_article == 'map_off')
			echo "<TR><TD BGCOLOR='$couleur_foncee'><FONT SIZE=1 COLOR='#FFFFFF' face='Verdana,Arial,Sans,sans-serif'><b>"._T('texte_date_creation_mapping')." : ";
		else
			echo "<TR><TD BGCOLOR='$couleur_foncee'><FONT SIZE=1 COLOR='#FFFFFF' face='Verdana,Arial,Sans,sans-serif'><b>"._T('texte_date_creation_article')." : ";
		//echo "<TR><TD BGCOLOR='$couleur_foncee'><FONT SIZE=1 COLOR='#FFFFFF' face='Verdana,Arial,Sans,sans-serif'><b>"._T('texte_date_creation_article')." : ";
		/******* Fin Modification MAPPING guillaume.grason@diplomatie.gouv.fr *******/
		echo majuscules(affdate($date))."</font></B></FONT>".aide('artdate')."</TD></TR>";
		//echo majuscules(affdate_base($date, 'complet'))."</font></B></FONT>".aide('artdate')."</TD></TR>";
  		echo "</TABLE>";
	}

	/* Modification Clever Age, elebescond */
	$authorization = & recuperer_instance_authorization('modifierDateAnterieurPublicationArticle', $GLOBALS['connect_id_auteur'], array ('id_article' => $id_article));
	if ($authorization->isAuthorizedAction())
		/* Fin Modification Clever Age */
		if (($options == 'avancees' AND $articles_redac != 'non') OR ($annee_redac.'-'.$mois_redac.'-'.$jour_redac != '0000-00-00')) {
			echo '<p><table cellpadding="5" cellspacing="0" border="0" width="100%">';
			echo '<tr><td bgcolor="#cccccc" colspan="2"><font size="1" color="#000000" face="Verdana,Arial,Sans,sans-serif">';
			if ($annee_redac.'-'.$mois_redac.'-'.$jour_redac != '0000-00-00')
				$date_affichee = ' : '.majuscules(affdate($date_redac));
			echo bouton_block_invisible('dateredac');
			echo "<b>"._T('texte_date_publication_anterieure').$date_affichee."</b></font></td></tr></table>";
			echo debut_block_invisible('dateredac');
			echo '<table cellpadding="5" cellspacing="0" border="0" width="100%">';
			echo '<tr><td align="left">';
			echo '<input type="radio" name="avec_redac" value="non" id="avec_redac_on"';
			if ($annee_redac.'-'.$mois_redac.'-'.$jour_redac == '0000-00-00')
				echo ' checked="checked"';
			echo ' /> <label for="avec_redac_on">'._T('texte_date_publication_anterieure_nonaffichee').'</label>';
			echo '<br /><input type="radio" name="avec_redac" value="oui" id="avec_redac_off"';
			if ($annee_redac.'-'.$mois_redac.'-'.$jour_redac != '0000-00-00')
				echo ' checked="checked"';
			echo ' /> <label for="avec_redac_off">'._T('bouton_radio_afficher').' :</label> ';

			echo '<select name="jour_redac" class="fondl">';
			afficher_jour($jour_redac);
			echo '</select> &nbsp;';
			echo '<select name="mois_redac" class="fondl">';
			afficher_mois($mois_redac);
			echo '</select> &nbsp;';
			echo '<input type="text" name="annee_redac" class="fondl" value="'.$annee_redac.'" size="5" maxlength="4" />';

			echo '</td><td align="right">';
			echo '<input type="submit" name="Changer" class="fondo" value="'._T('bouton_changer').'" />';
			echo aide('artdate_redac');
			echo '</td></tr>';
			echo '</table>';
			echo fin_block();
		}

	echo "</FORM>";
	fin_cadre_enfonce();
} else
	if ($statut_article == 'publie') {
		echo "<CENTER>".affdate($date)."</CENTER><P>";
	}


// Modification Aurelien Vialet <avialet@clever-age.com>
// Gestion du versionning des articles
if ($activer_version_articles == 'oui') {

	if ($articleMetier->getVersionId() == 0) {
	   $aArticlesVersion = $articleMetier->getAllForVersion(' id_article');
       if (count($aArticlesVersion) > 0) {
		debut_cadre_enfonce("article_new_version-24.png");
	
		echo "<TABLE BORDER=0 CELLSPACING=0 CELLPADDING=3 WIDTH=100% BACKGROUND=''><TR><TD BGCOLOR='#EEEECC' class='serif2'>";
		if ($flag_editable AND $options == 'avancees') {
			echo bouton_block_invisible("versionarticle");
		}
		echo "<B>"._T('article_version')."</B>";
		echo aide("#");
		echo "</TD></TR></TABLE>";
		echo debut_block_invisible("versionarticle");
		echo "<table bgcolor='#FFFFFF' width='100%'>";
		while (list (, $val) = each($aArticlesVersion)) {
			echo "<tr>";
			echo "<td class='arial2'>".majuscules(affdate($val->getDate()))."</td>";
			echo "<td class='arial2'><a href='articles.php3?id_article="
			.$val->getArticleId()."'>"
			.$val->getArticleId().". "
			.$val->getTitre()
			."</a></td>";
			echo "</tr>";
		}
		echo "</table>";
		
		fin_cadre_enfonce();
        }
	}
}
//
// Fin de la gestion des versions de l'article
//


//
// Gestion des historique d'une version d'un article
//
if ($options == 'avancees') {
if (($activer_histo_articles == 'oui') and ($articleMetier->getActiverHistorique() == 'oui') and $articleMetier->countHistorique() > 0) {
	$articleHisto = & recuperer_instance_article_historique();
	if (isset($articleHistoPurge)) {
		$articleHisto->purgeHisto($articleHistoPurge);
	}
	$aArticlesHisto = $articleHisto->loadHistoForArticle($articleMetier->getArticleId());
	
	debut_cadre_enfonce("article_history-24.png");
	echo "<TABLE BORDER=0 CELLSPACING=0 CELLPADDING=3 WIDTH=100% BACKGROUND=''><TR><TD BGCOLOR='#EEEECC' class='serif2'>";
//	if ($flag_editable AND $options == 'avancees') {
			echo bouton_block_invisible("historiquearticle");
//}
	echo "<B>"._T('article_historique')."</B>";
	echo aide("#");
	echo "</TD></TR></TABLE>";
	echo debut_block_invisible("historiquearticle");
	
	//if (count($aArticlesHisto) > 0) {
    echo "<table bgcolor='#FFFFFF' width='100%' border=0>";
    if ($flag_editable) {
        echo '<form action"articles.php3" method="get">';
        echo '<input type="hidden" name="id_article" value="'.$articleMetier->getArticleId().'" >';
    }
    //$first = true;
    foreach ( $aArticlesHisto as $histo ) {
        // En cas d'erreur...
        if ( PEAR::isError($histo) ) { die( $histo->getMessage() ); }

        // Rcupration de l'auteur de l'article
        $auteur_histo =& recuperer_instance_auteur();
        $status = $auteur_histo->load( $histo->getAuteurId() );
        
        if ( PEAR::isError($status) ) {
            $str_auteur = 'Auteur inconnu';
        } else {
            $str_auteur = "<a href=\"".$auteur_histo->getUrl()."\">". $auteur_histo->getNom()."</a>";
        }
       
        echo "<tr>";
        echo "<td class='arial2'>".affdate_base($histo->getDate(), 'complet')
            ." par ". $str_auteur .'</td>';
        echo "<td class='arial2'><a href='articles_texte_compare.php3?id_article="
            .$articleMetier->getArticleId()."&id_article_historique=".$histo->getArticleHistoriqueId()."'>"._T('comparer')."</a> ";
        echo "<td class='arial2'><a href='articles_texte_compare.php3?id_article_historique=".$histo->getArticleHistoriqueId()."'>"._T('voir')."</a> ";
        //echo "<a href='articles.php3?id_article=".$articleMetier->getArticleId()."&id_article_historique_replace=".$histo->getArticleHistoriqueId()."'>"._T('remplacer')."</a> ";
        if ($flag_editable) {
            echo "<td><input name='articleHistoPurge[]' type='checkbox' value='".$histo->getArticleHistoriqueId()."'></td>";
        }
        echo "</tr>";
			// }
    }
    echo "<tr>";
    if ($flag_editable) {
    echo '<td colspan="2" align="right"></td>'.
        '<td>'.
        '<input type="submit" name="Purger" class="fondo" value="'._T('bouton_purger').'" />'.
        '</td>'.
        '</tr>'.
        '</form>';
    }
    echo "</table>";
	//}
    fin_cadre_enfonce();
}
}

//
// Fin de la gestion de l'historique d'une version de l'article
//



//////////////////////////////////////////////////////
// Liste des mots-cles de l'article
//
//-------------MODIFICATION CLEVER AGE elebescond
$authorization = & recuperer_instance_authorization('modifierArticle', $GLOBALS['connect_id_auteur'], array ('id_article' => $id_article));
if ($authorization->isAuthorizedAction()) {
	if ($options == 'avancees' AND $articles_mots != 'non') {
		formulaire_mots('articles_map', $id_article, $nouv_mot, $supp_mot, $cherche_mot, $flag_editable);
	}
}
/*
if ($options == 'avancees' AND $articles_mots != 'non') {
	formulaire_mots('articles', $id_article, $nouv_mot, $supp_mot, $cherche_mot, $flag_editable);
}
*/
//-------------Fin MODIFICATION CLEVER AGE elebescond


//////////////////////////////////////////////////////
// Corps de l'article
//

echo "\n\n<div align='justify'>";

if ($virtuel) {
	debut_boite_info();
	echo _T('info_renvoi_article')." ".propre("<center>[->$virtuel]</center>");
	fin_boite_info();
} else {
	echo "<div $dir_lang><b>";
	echo justifier(propre($chapo));
	echo "</b></div>\n\n";

	echo "<div $dir_lang>".justifier(propre($texte))."</div>";

	if ($ps) {
		echo debut_cadre_enfonce();
		echo "<div $dir_lang><font size=2 face='Verdana,Arial,Sans,sans-serif'>";
		/***************** Modification elebescond@clever-age.com ***********/
		echo justifier("<b>"._T('art_info_ps', null, $articleMetier->getRubriqueId())."</b> ".propre($ps));
		/*
		echo justifier("<b>"._T('info_ps')."</b> ".propre($ps));
		*/
		/***************** Fin modification elebescond@clever-age.com ***********/
		echo "</font></div>";
		echo fin_cadre_enfonce();
	}

	if ($les_notes) {
		echo debut_cadre_relief();
		echo "<div $dir_lang><font size=2>";
		/***************** Modification elebescond@clever-age.com ***********/
		echo justifier("<b>"._T('art_info_notes', null, $articleMetier->getRubriqueId())."&nbsp;:</b> ".$les_notes);
		/*
		echo justifier("<b>"._T('info_notes')."&nbsp;:</b> ".$les_notes);
		*/
		/***************** Fin modification elebescond@clever-age.com ***********/
		echo "</font></div>";
		echo fin_cadre_relief();
	}

	if ($champs_extra AND $extra) {
		include_ecrire("inc_extra.php3");
		extra_affichage($extra, "articles");
	}
}

//
// Bouton "modifier cet article"
//

if ($flag_editable) {
	echo "\n\n<div align=right><br>";

	if ($date_diff >= 0 AND $date_diff < 60 AND $auteur_modif > 0 AND $auteur_modif != $connect_id_auteur) {
		//-------------MODIFICATION CLEVER AGE elebescond
		// $auteurMetier = & recuperer_instance_auteur();
		$loadOK = $auteurMetier->load($auteur_modif);
		if (PEAR :: isError($loadOK)) {
			die($loadOK->getMessage());
		} else {
			$nom_auteur_modif = $auteurMetier->getNom();
		}
		/*
		$query_auteur = "SELECT * FROM spip_auteurs WHERE id_auteur='$auteur_modif'";
		$result_auteur = spip_query($query_auteur);
		while ($row_auteur = spip_fetch_array($result_auteur)) {
			$nom_auteur_modif = $row_auteur["nom"];
		}
		*/
		//-------------FIN MODIFICATION
		//-------------MODIFICATION CLEVER AGE elebescond
		$authorization = & recuperer_instance_authorization('modifierArticle', $GLOBALS['connect_id_auteur'], array ('id_article' => $id_article));
		if ($authorization->isAuthorizedAction()) {
			/******* Modification MAPPING guillaume.grason@diplomatie.gouv.fr *******/
			if ($statut_article == 'mappe' || $statut_article == 'map_off') {
				icone(_T('art_icone_modifier_mapping', null, $articleMetier->getRubriqueId()), "mappings_edit.php3?id_article=$id_article", "warning-24.gif");
			}
			else {
				icone(_T('art_icone_modifier_article', null, $articleMetier->getRubriqueId()), "articles_edit.php3?id_article=$id_article", "warning-24.gif", "");
			}
			//icone(_T('art_icone_modifier_article', null, $articleMetier->getRubriqueId()), "articles_edit.php3?id_article=$id_article", "warning-24.gif", "");
			/******* Fin Modification MAPPING guillaume.grason@diplomatie.gouv.fr *******/
			echo "<font face='arial,helvetica,sans-serif' size=1>"._T('art_texte_travail_article', array ('nom_auteur_modif' => $nom_auteur_modif, 'date_diff' => $date_diff), $articleMetier->getRubriqueId())."</font>";
			echo aide("artmodif");
		}
		/*
		icone(_T('icone_modifier_article'), "articles_edit.php3?id_article=$id_article", "warning-24.gif", "");
		echo "<font face='arial,helvetica,sans-serif' size=1>"._T('texte_travail_article', array('nom_auteur_modif' => $nom_auteur_modif, 'date_diff' => $date_diff))."</font>";
		echo aide("artmodif");
		*/
		//-------------FIN MODIFICATION
	} else {
		//-------------MODIFICATION CLEVER AGE elebescond
		$authorization = & recuperer_instance_authorization('modifierArticle', $GLOBALS['connect_id_auteur'], array ('id_article' => $id_article));
		if ($authorization->isAuthorizedAction()) {
			/******* Modification MAPPING guillaume.grason@diplomatie.gouv.fr *******/
			if ($statut_article == 'mappe' || $statut_article == 'map_off') {
				icone(_T('art_icone_modifier_mapping', null, $articleMetier->getRubriqueId()), "mappings_edit.php3?id_article=$id_article", "article-24.gif", "edit.gif");
			}
			else {
				icone(_T('art_icone_modifier_article', null, $articleMetier->getRubriqueId()), "articles_edit.php3?id_article=$id_article", "article-24.gif", "edit.gif");
			}
			//icone(_T('art_icone_modifier_article', null, $articleMetier->getRubriqueId()), "articles_edit.php3?id_article=$id_article", "article-24.gif", "edit.gif");
			/******* Fin Modification MAPPING guillaume.grason@diplomatie.gouv.fr *******/
		}
		/*
		icone(_T('icone_modifier_article'), "articles_edit.php3?id_article=$id_article", "article-24.gif", "edit.gif");*/
		//-------------FIN MODIFICATION

	}

	echo "</div>";
}


echo "</DIV>";

fin_cadre_relief();




// choses lentes reportees en fin de page
@ flush();

// ajout Olivier Mansour
/* 
if ($jour && $flag_editable) {
	if (lire_meta("post_dates") != 'non')
		calculer_dates_rubriques();
}
*/
// a quoi ca sert ? ces lignes ? 
/*
if ($titre && !$ajout_forum && $flag_editable && !$ok_nouveau_statut) {
	calculer_rubriques();
}
*/

if ($ok_nouveau_statut) {
//	calculer_rubriques();
	if ($statut_nouv == 'publie' AND $statut_ancien != $statut_nouv) {
		include_ecrire("inc_mail.php3");
		envoyer_mail_publication($id_article);
	}
	if ($statut_nouv == "prop" AND $statut_ancien != $statut_nouv AND $statut_ancien != 'publie') {
		include_ecrire("inc_mail.php3");
		envoyer_mail_proposition($id_article);
	}
	if ($statut_nouv == 'publie' AND $statut_nouv != $statut_ancien)
		$reindexer = true;
}

if ($reindexer AND (lire_meta('activer_moteur') == 'oui')) {
	include_ecrire("inc_index.php3");
	indexer_article($id_article);
}

fin_page();

?>