<?php
/******* Fichier Ajout MAPPING guillaume.grason@diplomatie.gouv.fr *******/
include ("inc.php3");
include_ecrire ("inc_documents.php3");

require_once 'inc_presentation.php3';
/*  Couche mtier */
require_once (dirname(__FILE__)."/include/bd/inc_article_factory.php");
require_once (dirname(__FILE__)."/include/bd/inc_document_factory.php");
require_once (dirname(__FILE__)."/include/bd/inc_config_metier.php");
if (file_exists(dirname(__FILE__)."/mes_options.php3")) {
	require_once dirname(__FILE__)."/mes_options.php3";
} else {
	$GLOBALS['table_prefix'] = 'spip';
}
/* fin zone  */

require_once (dirname(__FILE__)."/include/bd/inc_metier_factory.php");
$dbMetier = &recuperer_instance_metier();
$db = &$dbMetier->_getDB();

include_ecrire ("inc_barre.php3");

$articles_surtitre = lire_meta("articles_surtitre");
$articles_soustitre = lire_meta("articles_soustitre");
$articles_descriptif = lire_meta("articles_descriptif");
$articles_urlref = lire_meta("articles_urlref");
$articles_chapeau = lire_meta("articles_chapeau");
$articles_ps = lire_meta("articles_ps");
$articles_redac = lire_meta("articles_redac");
$articles_mots = lire_meta("articles_mots");
$articles_modif = lire_meta("articles_modif");

// securite
$id_article = intval($id_article);
$id_rubrique = intval($id_rubrique);
$lier_trad = intval($lier_trad);
unset ($flag_editable);

//
// Creation de l'objet article
//

# -- Edition d'un article existant
if ($id_article) {
	$articleMetier = &recuperer_instance_article();
	$loadOK = $articleMetier->load($id_article);
	if(PEAR::isError($loadOK)) {
		die($loadOK->getMessage());
	}
	$id_article = $articleMetier->getArticleId();
	$surtitre = $articleMetier->getSurtitre();
	$titre = $articleMetier->getTitre();
	$soustitre = $articleMetier->getSoustitre();
	$id_rubrique = $articleMetier->getRubriqueId();
	$descriptif = $articleMetier->getDescriptif();
	$nom_site = $articleMetier->getNomSite();
	$url_site = $articleMetier->getUrlSite();
	$chapo = $articleMetier->getChapo();
	$texte = $articleMetier->getTexte();
	$ps = $articleMetier->getPs();
	$date = $articleMetier->getDate();
	$statut = $articleMetier->getStatut();
	$date_redac = $articleMetier->getRedactionDate();
	if (ereg("([0-9]{4})-([0-9]{2})-([0-9]{2})",$date_redac,$regs)){
		$mois_redac = $regs[2];
		$jour_redac = $regs[3];
		$annee_redac = $regs[1];
		if ($annee_redac > 4000) $annee_redac -= 9000;
	}
	$extra = $articleMetier->getExtra();
	$flag_auteur = $articleMetier->isAuthor($connect_id_auteur);
	$flag_editable = true;
}
if (!$flag_editable) {
	die ("<H3>"._T('info_acces_interdit')."</H3>");
}

debut_page(_T('titre_page_mapping_edit', array('titre' => $titre)), "documents", "articles");
debut_grand_cadre();
afficher_parents($id_rubrique);
$parents="~ <img src='img_pack/racine-site-24.gif' width=24 height=24 align='middle'> <A HREF='naviguer.php3?coll=0'><B>"._T('lien_racine_site')."</B></A> ".aide ("rubhier")."<BR>".$parents;
$parents=ereg_replace("~","&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;",$parents);
$parents=ereg_replace("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; ","",$parents);
echo "$parents";
fin_grand_cadre();
debut_gauche();
debut_droite();

debut_cadre_formulaire();
echo "\n<table cellpadding=0 cellspacing=0 border=0 width='100%'>";
echo "<tr width='100%'>";
echo "<td>";
if ($lier_trad) icone(_T('icone_retour'), "articles.php3?id_article=$lier_trad", "article-24.gif", "rien.gif");
else icone(_T('icone_retour'), "articles.php3?id_article=$id_article", "article-24.gif", "rien.gif");
echo "</td>";
echo "<td><img src='img_pack/rien.gif' width=10></td>\n";
echo "<td width='100%'>";
echo _T('art_texte_modifier_mapping', null, $id_rubrique);
gros_titre($titre);
echo "</td></tr></table>";
echo "<p>";
echo "<P><HR><P>";
$logo_parent = "rubrique-24.gif";
debut_cadre_relief("$logo_parent");
echo "<B>"._T('titre_cadre_interieur_modifier_mapping')."&nbsp;:</B>\n";
$id_article = $HTTP_GET_VARS ["id_article"];
echo "<form  method=post action='do_mapping.php3'>";
echo "<table><tr><td align='right'>"._T('entree_mapping_liste_rubriques')."</td><td>";
echo "<select name='id_rubrique'>";
$query = "SELECT map.id_map, rubriques.titre, rubriques.id_rubrique FROM ".$GLOBALS['table_prefix']."_rubriques rubriques, ".$GLOBALS['table_prefix']."_articles articles, ".$GLOBALS['table_prefix']."_articles_mapping map WHERE map.id_article = $id_article AND map.id_map = articles.id_article AND rubriques.id_rubrique = articles.id_rubrique";
$result = $db->query($query);
$rubriqueMetier = &recuperer_instance_rubrique();
while($row = $result->fetchRow()) {
	$chemin = "";
	$id_rubrique_courante = $row['id_rubrique'];
	while ($id_rubrique_courante != 0) {
		$loadOK = $rubriqueMetier->load($id_rubrique_courante);
		if(PEAR::isError($loadOK)) {
			die($loadOK->getMessage());
		}
		$chemin = "/".ereg_replace("^[[:space:]]*[0-9]+[.)".chr(176)."][[:space:]]+", "", $rubriqueMetier->getTitre()) . $chemin;
		$id_rubrique_courante = $rubriqueMetier->getParentId();
	}
	if (strlen($chemin) > 60) 
		$chemin = substr($chemin,0,30) . "..." . substr($chemin,-30);
	echo "<option value='".$row['id_map']."'>$chemin</option>";
}
$result->free();
echo "</td><td align='center'><input type=submit value='"._T('bouton_supprimer')."'>";
echo "<input type='hidden' name='id_action' value='0'>";
echo "<input type='hidden' name='id_article' value=$id_article>";
echo "</td></tr>";
echo "</form>";
echo "<tr><td>&nbsp;</td></tr>";
echo "<tr><td align='right'>"._T('entree_mapping_ajouter_rubriques')."</td><td>";
echo "<FORM ACTION='do_mapping.php3' METHOD='post' name='formulaire'>";
echo "<input type='HIDDEN' name='id_rubrique' value='0'>";
echo "<input type='hidden' name='id_action' value='1'>";
echo "<input type='hidden' name='id_article' value=$id_article>";
echo "<input type='text' class='forml' NAME='lbl_current_rubrique_info' readonly value='' onclick=\"window.open('brouteur_select_rubrique.php3?id_rubrique=0', 'changer_rubrique', 'width=900,height=450, scrollbars=yes');\">";
echo "</td><td align='center'>&nbsp;<input type=submit value=enregistrer>";
echo "</td></tr></table></form>";
fin_cadre_relief();
fin_cadre_formulaire();
fin_page();
?>
