<?php
/******* Fichier Ajout MAPPING guillaume.grason@diplomatie.gouv.fr *******/
include ("inc.php3");

include_ecrire ("inc_documents.php3");


require_once 'inc_presentation.php3';
/* Ajout Clever Age / Antoine Angnieux / Couche mtier */
require_once (dirname(__FILE__)."/include/bd/inc_article_factory.php");
require_once (dirname(__FILE__)."/include/bd/inc_document_factory.php");
/* fin zone de modification Clever Age */

include_ecrire ("inc_barre.php3");

$articles_surtitre = lire_meta("articles_surtitre");
$articles_soustitre = lire_meta("articles_soustitre");
$articles_descriptif = lire_meta("articles_descriptif");
$articles_urlref = lire_meta("articles_urlref");
$articles_chapeau = lire_meta("articles_chapeau");
$articles_ps = lire_meta("articles_ps");
$articles_redac = lire_meta("articles_redac");
$articles_mots = lire_meta("articles_mots");
$articles_modif = lire_meta("articles_modif");

// securite
$id_article = intval($id_article);
$id_rubrique = intval($id_rubrique);
$lier_trad = intval($lier_trad);
unset ($flag_editable);

//
// Creation de l'objet article
//

# -- Edition d'un article existant
if ($id_article) {
	
    //-----------MODIFICATION CLEVER AGE
    $articleMetier = &recuperer_instance_article();
	$loadOK = $articleMetier->load($id_article);
	if(PEAR::isError($loadOK)) {
	    die($loadOK->getMessage());
	}

    $authorization = &recuperer_instance_authorization('isManagedRubriqueByAuteurId', $GLOBALS['connect_id_auteur'], array('rubriqueId' => $articleMetier->getRubriqueId()));
    if (!$authorization->isAuthorizedAction()) {
        echo _T('avis_acces_interdit');
        exit;
    }

    if ( $new_version != 'oui' )
    {
        $authorization = &recuperer_instance_authorization('modifierArticle', $GLOBALS['connect_id_auteur'], array('id_article' => $id_article));
        if (!$authorization->isAuthorizedAction()) {
            echo _T('avis_acces_interdit');
            exit;
        }
    }
    else
    {
        $authorization = &recuperer_instance_authorization('creerVersionArticle', $GLOBALS['connect_id_auteur'], array('id_article' => $id_article));
		if (!$authorization->isAuthorizedAction()) {
			echo _T('avis_acces_interdit');
			exit;
		}
    }

	$maDate = new Date();
	$articleMetier->setModificationDate($maDate->getDate(DATE_FORMAT_ISO));
	$articleMetier->setAuteurModif($connect_id_auteur);
	
	$updateOK = $articleMetier->update();
	if(PEAR::isError($updateOK)) {
	    die($updateOK->getMessage());
	}

	$id_article_bloque = $id_article;	// message pour inc_presentation

	// Recuperer les donnees de l'article

	$id_article = $articleMetier->getArticleId();
	$surtitre = $articleMetier->getSurtitre();
	$titre = $articleMetier->getTitre();
	$soustitre = $articleMetier->getSoustitre();
	$id_rubrique = $articleMetier->getRubriqueId();
	$descriptif = $articleMetier->getDescriptif();

    // TODO : les methodes getNomsSite et getUrlSite semblent ne rien retourner
    $nom_site = $articleMetier->getNomSite();
	$url_site = $articleMetier->getUrlSite();

	$chapo = $articleMetier->getChapo();
	$texte = $articleMetier->getTexte();
	$ps = $articleMetier->getPs();
	$date = $articleMetier->getDate();
	$statut = $articleMetier->getStatut();
	$date_redac = $articleMetier->getRedactionDate();
	if (ereg("([0-9]{4})-([0-9]{2})-([0-9]{2})",$date_redac,$regs)){
        $mois_redac = $regs[2];
        $jour_redac = $regs[3];
        $annee_redac = $regs[1];
        if ($annee_redac > 4000) $annee_redac -= 9000;
    }
    $extra = $articleMetier->getExtra();

    $flag_auteur = $articleMetier->isAuthor($connect_id_auteur);
    $flag_editable = true;
}

# -- Cration d'un nouvel article
else if ($new=='oui') {

    // Cration d'un traduction d'un article existant
	if ($lier_trad) {
	    // Pas de langue choisie par defaut
		$changer_lang = '';

		// Recuperer les donnees de la traduction
		$articleMetier = &recuperer_instance_article();
		$loadOK = $articleMetier->load($lier_trad);
		if(PEAR::isError($loadOK)) {
		    die($loadOK->getMessage());
		}
		else {
			$surtitre = $articleMetier->getSurtitre();
			$titre = filtrer_entites(_T('info_nouvelle_traduction')).' '.$articleMetier->getTitre();
			$soustitre = $articleMetier->getSoustitre();
			$id_rubrique_trad = $articleMetier->getRubriqueId();
			$descriptif = $articleMetier->getDescriptif();
			$nom_site = $articleMetier->getNomSite();
			$url_site = $articleMetier->getUrlSite();
			$chapo = $articleMetier->getChapo();
			$texte = $articleMetier->getTexte();
			$ps = $articleMetier->getPs();
			$date = $articleMetier->getDate();
			$date_redac = $articleMetier->getRedactionDate();
			if (ereg("([0-9]{4})-([0-9]{2})-([0-9]{2})",$date_redac,$regs)) {
				$mois_redac = $regs[2];
				$jour_redac = $regs[3];
				$annee_redac = $regs[1];
				if ($annee_redac > 4000) $annee_redac -= 9000;
			}
			$extra = $articleMetier->getExtra();
		}

		$langues_autorisees = lire_meta('langues_multilingue');
		
		// Regler la langue, si possible
		if (ereg(",$spip_lang,", ",$langues_autorisees,")) {
			if (lire_meta('multi_articles') == 'oui') {
				// Si le menu de langues est autorise sur les articles,
				// on peut changer la langue quelle que soit la rubrique
				$changer_lang = $spip_lang;
			}
			else if (lire_meta('multi_rubriques') == 'oui') {
				// Chercher la rubrique la plus adaptee pour accueillir l'article
				if (lire_meta('multi_secteurs') == 'oui') 
					$id_parent = 0;
				else {
					$rubriqueMetier = &recuperer_instance_rubrique();
            		$loadOK = $rubriqueMetier->load($id_rubrique);
            		if(PEAR::isError($loadOK)) {
            		    die($loadOK->getMessage());
            		}
            		else {					
            		    $id_parent = $rubriqueMetier->getParentId();
            		}
				}
				$rubriqueMetier = &recuperer_instance_rubrique();
        		$rubriques = $rubriqueMetier->getAllForLangAndParentId($spip_lang, $id_parent);
        		if(PEAR::isError($rubriques)) {
        		    die($rubriques->getMessage());
        		}
        		if (list(, $rubrique) = each($rubriques)) {
					$id_rubrique = $id_secteur = $rubrique->getRubriqueId();
					$changer_lang = 'herit';
        		}
			}
		}
	}
	else {
		// Nouvel article : titre par defaut
		$titre = filtrer_entites(_T('art_info_nouvel_article', null, $id_rubrique));
		
	}
	if (!$id_secteur) {
		$rubriqueMetier = &recuperer_instance_rubrique();
		$loadOK = $rubriqueMetier->load($id_rubrique);
		if(PEAR::isError($loadOK)) {
		    $id_secteur = null;
		}
		else {
            $id_secteur = $rubriqueMetier->getSecteurId();
		}
	}
	$flag_editable = true;
}

if (!$flag_editable) {
    die ("<H3>"._T('info_acces_interdit')."</H3>");
}

if ($id_article && $id_document) {
    $flag_document_editable = $articleMetier->hasDocument($id_document);
} else {
    $flag_document_editable = false;
}

$modif_document = $GLOBALS['modif_document'];
if ($modif_document == 'oui' AND $flag_document_editable) {
    $documentMetier = &recuperer_instance_document();
    $loadOK = $documentMetier->load($id_document);

    if (PEAR::isError($loadOK)) {
        die($loadOK->getMessage());
    }
    if ($documentMetier->getMode() == 'document') {
        if ($titre_document != '') {
            $documentMetier->setTitre($titre_document);
        }
        else {
                if ($titre_document == '' && $descriptif_document != '' && $documentMetier->getTitre() == '') {
                    $titre_document_array = explode('/', $documentMetier->getFichier());
                    $titre_document = $titre_document_array[2];
                    $titre_document_array = explode('.', $titre_document);
                    
                    $titre_document = strtr($titre_document_array[0], "_", " ");
                    $documentMetier->setTitre($titre_document);
                }            
        }
    }
    else {
        if (($titre_document == '' && $descriptif_document == '') || ($titre_document != '')) {
                $documentMetier->setTitre($titre_document);
        }
        else {
            if ($titre_document == '' && $descriptif_document != '' && $documentMetier->getTitre() == '') {
                $titre_document_array = explode('/', $documentMetier->getFichier());
                $titre_document = $titre_document_array[2];
                $titre_document_array = explode('.', $titre_document);
                
                $titre_document = strtr($titre_document_array[0], "_", " ");
                $documentMetier->setTitre($titre_document);
            }
        }
    }
    
    $documentMetier->setDescriptif($descriptif_document);
    if ($largeur_document AND $hauteur_document) {
        $documentMetier->setLargeur($largeur_document);
        $documentMetier->setHauteur($hauteur_document);
    }

    $updateOK = $documentMetier->update();
    if (PEAR::isError($updateOK)) {
        die($updateOK->getMessage());
    }
}




//
// Gestion des textes trop longs (limitation brouteurs)
//
function coupe_trop_long($texte){   // utile pour les textes > 32ko
    if (strlen($texte) > 28*1024) {
        $texte = str_replace("\r\n","\n",$texte);
        $pos = strpos($texte, "\n\n\n", 28*1024);   // coupe para > 28 ko
        if ($pos > 0 and $pos < 32 * 1024) {
            $debut = substr($texte, 0, $pos);
            $suite = substr($texte, $pos);
        } else {
            $pos = strpos($texte, " ", 28*1024);    // sinon coupe espace
            if (($pos > 0 and $pos < 32 * 1024)) {
                    $debut = substr($texte,0,$pos);
                  $suite = substr($texte,$pos );
                } else {
                        $pos = 28*1024;                       // au pire
                        $debut = substr($texte,0,$pos);
                        $suite = substr($texte,$pos);
                }
        }
        return (array($debut,$suite));
    }
    else 
        return (array($texte,''));
}

debut_page(_T('titre_page_articles_edit', array('titre' => $titre)), "documents", "articles");

debut_grand_cadre();

afficher_parents($id_rubrique);

$parents="~ <img src='img_pack/racine-site-24.gif' width=24 height=24 align='middle'> <A HREF='naviguer.php3?coll=0'><B>"._T('lien_racine_site')."</B></A> ".aide ("rubhier")."<BR>".$parents;
$parents=ereg_replace("~","&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;",$parents);
$parents=ereg_replace("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; ","",$parents);

echo "$parents";

fin_grand_cadre();
debut_gauche();
debut_droite();
debut_cadre_formulaire();


function mySel($varaut,$variable) {
    $retour= " VALUE=\"$varaut\"";

    if ($variable==$varaut) {
        $retour.= " SELECTED";
    }

    return $retour;
}



function my_sel($num,$tex,$comp){
    if ($num==$comp){
        echo "<OPTION VALUE='$num' SELECTED>$tex\n";
    }else{
        echo "<OPTION VALUE='$num'>$tex\n";
    }

}

function afficher_mois($mois){
    my_sel("01",_T('date_mois_1'),$mois);
    my_sel("02",_T('date_mois_2'),$mois);
    my_sel("03",_T('date_mois_3'),$mois);
    my_sel("04",_T('date_mois_4'),$mois);
    my_sel("05",_T('date_mois_5'),$mois);
    my_sel("06",_T('date_mois_6'),$mois);
    my_sel("07",_T('date_mois_7'),$mois);
    my_sel("08",_T('date_mois_8'),$mois);
    my_sel("09",_T('date_mois_9'),$mois);
    my_sel("10",_T('date_mois_10'),$mois);
    my_sel("11",_T('date_mois_11'),$mois);
    my_sel("12",_T('date_mois_12'),$mois);
}

function afficher_jour($jour){
    for($i=1;$i<32;$i++) {
        if ($i<10){$aff="&nbsp;".$i;}else{$aff=$i;}
        my_sel($i,$aff,$jour);
    }
}





echo "\n<table cellpadding=0 cellspacing=0 border=0 width='100%'>";
echo "<tr width='100%'>";
echo "<td>";
/******* Modification MAPPING guillaume.grason@diplomatie.gouv.fr *******/
// Mod par Johnny Muller
icone(_T('icone_retour'), "mapping_articles.php3?id_article=$id_article", "article-24.gif", "rien.gif");
//	if ($lier_trad) icone(_T('icone_retour'), "articles.php3?id_article=$lier_trad", "article-24.gif", "rien.gif");
//	else icone(_T('icone_retour'), "articles.php3?id_article=$id_article", "article-24.gif", "rien.gif");
/******* Fin Modification MAPPING guillaume.grason@diplomatie.gouv.fr *******/
echo "</td>";
    echo "<td><img src='img_pack/rien.gif' width=10></td>\n";
echo "<td width='100%'>";
echo _T('art_texte_modifier_article', null, $id_rubrique);
gros_titre($titre);
echo "</td></tr></table>";
echo "<p>";

echo "<P><HR><P>";

    $titre = entites_html($titre);
    $soustitre = entites_html($soustitre);
    $surtitre = entites_html($surtitre);

    $descriptif = entites_html($descriptif);
	$nom_site = entites_html($nom_site);
	$url_site = entites_html($url_site);
    $chapo = entites_html($chapo);
    $texte = entites_html($texte);
    $ps = entites_html($ps);


    $lien = 'mapping_articles.php3';
    if ($id_article) $lien .= "?id_article=$id_article";
	echo "<FORM ACTION='$lien' METHOD='post' name='formulaire'>\n";

    if ($id_article) {
        echo "<INPUT TYPE='Hidden' NAME='id_article' VALUE='$id_article'>";
        if ($new_version == 'oui') {
        	echo "<input type='hidden' name='new_version' value='oui'>";
        }
    } else if ($new == 'oui') {
        echo "<INPUT TYPE='Hidden' NAME='new' VALUE='oui'>";
    }
		
	if ($lier_trad) {
		echo "<INPUT TYPE='Hidden' NAME='lier_trad' VALUE='$lier_trad'>";
		echo "<INPUT TYPE='Hidden' NAME='changer_lang' VALUE='$spip_lang'>";
	}
	
	echo "<INPUT TYPE='hidden' NAME='surtitre' VALUE=\"$surtitre\" >";
	
	echo _T('art_texte_titre_obligatoire', null, $id_rubrique);
    echo aide ("arttitre");
    echo "<BR><INPUT TYPE='text' NAME='titre' style='font-weight: bold;' CLASS='formo' VALUE=\"$titre\" SIZE='40'><P>";

    echo "<INPUT TYPE='hidden' NAME='soustitre' VALUE=\"$soustitre\">";


    /// Dans la rubrique....
    
   	$currentRubrique = &recuperer_instance_rubrique();
    $currentRubrique->load($articleMetier->getRubriqueId());
   	echo "<input type='HIDDEN' name='id_rubrique' value='".$currentRubrique->getRubriqueId()."'>";

	if (($options == "avancees" AND $articles_descriptif != "non") OR $descriptif) {
        echo "<P><B>"._T('art_texte_descriptif_rapide', null, $id_rubrique)."</B>";
        echo aide ("artdesc");
        echo "<BR>"._T('art_texte_contenu_article', null, $id_rubrique)."<BR>";
        echo "<TEXTAREA NAME='descriptif' CLASS='forml' ROWS='2' COLS='40' wrap=soft>";
        echo $descriptif;
        echo "</TEXTAREA><P>\n";
    }
    else {
        echo "<INPUT TYPE='hidden' NAME='descriptif' VALUE=\"$descriptif\">";
    }


    echo "<INPUT TYPE='hidden' NAME='chapo' VALUE=\"$chapo\">";

	echo "<INPUT TYPE='hidden' NAME='texte' VALUE=\"$texte\">";

    echo "<INPUT TYPE='hidden' NAME='ps' VALUE=\"$ps\">";

	if ($champs_extra) {
		include_ecrire("inc_extra.php3");
		extra_saisie($extra, 'articles', $id_rubrique);
	}

    if ($date)
        echo "<INPUT TYPE='Hidden' NAME='date' VALUE=\"$date\" SIZE='40'><P>";

    if ($new == "oui")
        echo "<INPUT TYPE='Hidden' NAME='statut_nouv' VALUE=\"prepa\" SIZE='40'><P>";

    echo "<DIV ALIGN='right'>";
    echo "<INPUT CLASS='fondo' TYPE='submit' NAME='Valider' VALUE='"._T('bouton_valider')."'>";
    echo "</DIV></FORM>";
fin_cadre_formulaire();

fin_page();
?>