<?php
//************ Creation de la gestion des utilisateurs de la newsletter  - fxlacroix@clever-age.com **************************/
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Franois Xavier LACROIX <fxlacroix@clever-age.com>           |
// +----------------------------------------------------------------------+
//  $Id$
//  Affiche la liste des utilisateurs pour la newsletter spcifi en entr et permet de grer les
//  utilisateurs en attente et les utilisateurs inscrit
//  Possibilit d'inscrire les gens en attente ou de supprimer n'importe quel utilisateur...

include ("inc.php3");
include_ecrire ("inc_mots.php3");
require_once(dirname(__FILE__)."/inc_draw_api.php");
require_once (dirname(__FILE__)."/include/bd/inc_newsletter_factory.php");
require_once (dirname(__FILE__)."/include/bd/inc_cm_user_groups_factory.php");
require_once (dirname(__FILE__)."/inc_newsletter_constants.php");
require_once (dirname(__FILE__)."/include/bd/inc_subscriber_cm_factory.php");
require_once (dirname(__FILE__)."/include/bd/inc_newsletter_cm_list_factory.php");
require_once (dirname(__FILE__)."/include/bd/inc_subscriber_link_factory.php");
require_once (dirname(__FILE__)."/include/bd/inc_subscriber_pending_factory.php");
//require_once (dirname(__FILE__)."/inc_version.php3");

//Variable de pagination pour grer le nombre d'utilisateur par page
$pagination = 19;

// (dirname(__FILE__)."/include/NestedSet/NestedSet/DB.php");
//$dsn = "mysql://$user:$pass@$host/$db_name";
//$db = DB::connect($dsn, true);
// }}}
//On interdit les majuscules ! ->fxlacroix
if(isset($_POST['email'])&&($_POST['email']!="")){
    $_POST['email'] = strtolower($_POST['email']);
}
//Reception de la valeur de pagination
if(!isset($_GET['page'])) $page = 1;
else $page = $_GET['page'];

//Retourne la liste des initiales de chaque utilisateur  partir d'un tableau d'identification de sub_id    
function returnTabKeys($tab){
       $subscriber = &recuperer_instance_subscriber_cm();
       foreach($tab as $t){
           $subscriber->load($t);
           $mail = $subscriber->getSubEmail();
           $tab_letter[strtolower( substr($mail,0,1))]=1; 
           }
        unset($subscriber);
        if(isset($tab_letter)){
            $keys=array_keys($tab_letter);
            sort($keys);
            }
        return($keys);
     }
     
     // }}}
  // {{{ returnTabKeys()  


if (!$_GET['id_newsletter']) {
    die ("pas de newsletter");
} else {
    $id_newsletter = $_GET['id_newsletter'];
}


//Vrification si l'administrateur a cliqu sur le bouton d'activation d'un compte en attente
if(isset($activate)){
     $subscriber = &recuperer_instance_subscriber_pending();
     $subscriber_new_list = &recuperer_instance_subscriber_link();
     $subscriber->loadSub($activate);
     $subscriber_new_list->setLsrMode($subscriber->getPndMode());
     $subscriber_new_list->setLstId($id_newsletter);
     $subscriber_new_list->setSubId($subscriber->getSubId());
     $subscriber_new_list->create();
     $subscriber->deleteSub();
    unset($subscriber);
    unset($subscriber_new_list);
}

//Verification du cadre, ou on est ? dans la lettre 'a', 'o', 'tous'...
if(isset($search)) $string_search = "&search=$search";
if($inscrits==1) $string_inscrits = "&inscrits=1";
if($non_inscrits==1) $string_non_inscrits = "&non_inscrits=1";
if(isset($id_newsletter)) $string_newsletter = "&id_newsletter=$id_newsletter";

//Vrification du filtre d'utilisateurs demands et dtail de la coche des checkbox
$coche_inscrit="";
$coche_non_inscrit ="";
if(isset($_GET['inscrits'])){
    $inscrits=1;
    $coche_inscrit="CHECKED";
    }
else{
    $_GET['non_inscrits']=1;
    $coche_non_inscrit="CHECKED";    
}
if(isset($_GET['non_inscrits'])){
    $non_inscrits=1;
    $coche_non_inscrit="CHECKED";    
}
if(isset($_GET['searchByUser'])){
    $searchByUser=$_GET['searchByUser'];
    $stringSearchByUser= "&searchByUser=".$_GET['searchByUser'];
}
//echo $stringSearchByUser;

//Vrification de la supression et cration du message de confirmation de suppression
if(isset($suppress)&&isset($id_newsletter)){
   
   if($type==0){
       $subscriber = &recuperer_instance_subscriber_pending();
       $subscriber->loadLstSub($id_newsletter,$suppress);
       $message = $subscriber->deleteUserList($id_newsletter,$suppress)."&nbsp;"._T('supprime')."!";
   }
   else{
       $subscriber = &recuperer_instance_subscriber_link();
       $subscriber->loadLstSub($id_newsletter,$suppress);
       $message = _T('utilisateur')."&nbsp;".$subscriber->deleteUserList($id_newsletter,$suppress)."&nbsp;"._T('supprime')." !";
   }   
   unset($suppress);
   unset($subscriber);  
}

//Verification du bouton de correction des erreurs
if(isset($_POST['verif'])){
    $subscriber = &recuperer_instance_subscriber_link();
    $verifie = $subscriber->verification();
    $situation = $verifie." "._T('situ');
}

//Vrification de le la validation du formulaire (ajout d'un nouvel utilisateur de la NL)
if(isset($_POST['email'])&&($_POST['email']!="")){
    $emailtest = $_POST['email'];
    $emailtest = strtolower($emailtest);
     if (eregi('^([^@ ]+@[^@ ]+\.[^@.; ]+)(;[^;]*)?(;[^;]*)?$', trim($emailtest))){
        //Insertion des donnes du formulaire dans spip cm subscriber
        $subscriber = &recuperer_instance_subscriber_cm();
        $subscriber->setSubEmail($_POST['email']);
        $subscriber->setSubFirstName($_POST['prenom']);
        $subscriber->setSubMiddleName($_POST['deuxieme_prenom']);
        $subscriber->setSubLastName($_POST['nom']);
        $subscriber->setSubTitle($_POST['titre']);
        $id_sub = $subscriber->create($id_newsletter);           
        //die($subscriber->get_sub_id());
        //Liaison dans la table spip_cm_list_subscribers avec la newsletter et le nouvel utilisateur (inscription directe)
        $subscriber2 = &recuperer_instance_subscriber_link();
        //$subscriber->set_lsr_mode();
        //die($id_sub);
        $subscriber2->setLstId($id_newsletter);
        $subscriber2->setSubId($id_sub);
        //$subscriber2->setLsrId($subscriber->getSubProfile());
        $subscriber2->setLsrMode($_POST['cm_sub_mode']);
        //die(var_dump($subscriber));
        $subscriber2->create();
        unset($subscriber);
        unset($subscriber2);
        } 
    else {
        $erreur_mail = _T('erreur_mail');
        }   
    }   
 
//Importation de donnes d'un fichier csv
$Import = false;

if(isset($_POST['Importer'])&&($_POST['Importer']!="")&&isset($_FILES['imfile'])&&($_FILES['imfile']!="")){   
    $Import = true;

    // Upload du fichier CSV choisi
    copy( $_FILES["imfile"]["tmp_name"],
          $_FILES["imfile"]["name"] ) or die( '<b>Unknown error during transfer !</b>' );

    if ( ! $handle = fopen($imfile_name, 'r') ) {
        print "Cannot open file ($filename)";
        $Import = false;
    }else{
       $Import = true;
       while ( ! feof ($handle) ) {
            //Rcupration des donnes pour l'importation du fichier CSV        
           $buffer = fgets($handle, 4096);
           //$pieces = explode(";", $buffer);
           
           list($emailtest, $firstname, $middlename, $lastname, $title,  $lsr_mode, $profile) = explode(",", $buffer);
           if ( eregi('^([^@ ]+@[^@ ]+\.[^@.; ]+)(;[^;]*)?(;[^;]*)?$', trim($emailtest)) ){
                //Insertion des donnes du formulaire dans spip cm subscriber
                $subscriber = &recuperer_instance_subscriber_cm();
                $subscriber->setSubEmail($emailtest);
                $subscriber->setSubFirstName($firstname);
                $subscriber->setSubMiddleName($middlename);
                $subscriber->setSubLastName($lastname);
                $subscriber->setSubTitle($title);
                $subscriber->setSubProfile($profile);
                $id_sub = $subscriber->create($id_newsletter);           
                //Liaison dans la table spip_cm_list_subscribers avec la newsletter et le nouvel utilisateur (inscription directe)
                //Correction apport pour grer le mode inscrit / en attente avec en plus la gestion du mode de lettre
                //A savoir le mode html / texte

                switch ( trim($profile) ) {
                    case 1:
                    case 'inscrit':
                        $subscriber2 = &recuperer_instance_subscriber_link();
                        $subscriber2->setLstId($id_newsletter);
                        $subscriber2->setSubId($id_sub);
                        $subscriber2->setLsrMode($lsr_mode=='html'?1:0);
                        $subscriber2->create($id_newsletter);
                        unset($subscriber2);
                        break;
                        
                     case 0:
					 case 'en attente':
					 default:
                         $subscriber2 = &recuperer_instance_subscriber_pending();
                         $subscriber2->setLstId($id_newsletter);
                         $subscriber2->setSubId($id_sub);
                         $subscriber2->setPndMode($lsr_mode=='html'?1:0);
						 echo $subscriber2->getPndMode();
                         $subscriber2->setPndAction("subscribe");
                         $subscriber2->create();
                         unset($subscriber2);
                         break;
                         
                }
                unset($subscriber);
           }
       }
    } 
}  

//Interface agora classique
$newsletterMetier = &recuperer_instance_newsletter();
$newsletterMetier->load($id_newsletter);
$titreNewsletter = $newsletterMetier->getName();
debut_page("&laquo; Gestion des utilisateurs &raquo;", "administration", "newsletter");
// Ajout Olivier Mansour 
// gestion des authorizations 
$authorization = &recuperer_instance_authorization('configurerLettresInfos', $GLOBALS['connect_id_auteur']);
if (!$authorization->isAuthorizedAction()) {
    echo _T('avis_non_acces_page');
    fin_page();
    exit;
}
// fin ajout
debut_gauche();
debut_boite_info();
echo "<div align='center'>\n";
echo "<font face='Verdana,Arial,Helvetica,sans-serif' size='1'><b>LETTRE D'INFORMATION NUM&Eacute;RO&nbsp;:</b></font>\n";
echo "<br><font face='Verdana,Arial,Helvetica,sans-serif' size='6'><b>$id_newsletter</b></font>\n";
icone_horizontale(_T('retour_info_gabarit'), "newsletter_admin.php3?retour=nav&id_newsletter=$id_newsletter", "newsletter-24.gif", "rien.gif");
icone_horizontale(_T('statistiques'), "newsletter_statistiques.php3?id_newsletter=$id_newsletter", "statistiques-24.gif", "rien.gif");
echo "</div>";
fin_boite_info();

//Panneau d'ajout d'un nouvel utilisateur
debut_boite_info();
echo "<FORM action='?id_newsletter=$id_newsletter".$string_search.$string_inscrits.$string_non_inscrits."' method='post'>";
echo _T('ajout_utilisateur');
//Formulaire d'ajout d'un nouvel utilisateur de la newsletter
if($new != "oui"){
    echo "<input type='hidden' name='id_utilisateur' value='$id_utilisateur' />";
    echo "<input type='hidden' name='mod' value='oui' />";
    } 
else echo "<input type='hidden' name='new' value='oui'>";   
//echo "<p><b>"._T('email')."</b>";
echo "<div style='border: width: 160px'><input type='text' name='email' value='".$email."' /></div>";
echo '<label for="cm_sub_mode_html">HTML</label>';
echo '<input type="radio" name="cm_sub_mode" id="cm_sub_mode_html" value="1" checked="checked" />';
echo '<label for="cm_sub_mode_texte">Texte</label>';
echo '<input type="radio" name="cm_sub_mode" id="cm_sub_mode_texte" value="0" />';
echo "<div style='display: none;'>";
echo "<p><b>"._T('nom')."</b>";
echo "<BR><INPUT TYPE='text' NAME='nom'  VALUE=\"$nom\" SIZE='20'></p>";
echo "<p><b>"._T('prenom')."</b>";
echo "<BR><INPUT TYPE='text' NAME='prenom'  VALUE=\"$prenom\" SIZE='20'></p>";
echo "<p><b>"._T('deuxieme_prenom')."</b>";
echo "<BR><INPUT TYPE='text' NAME='deuxieme_prenom' VALUE=\"$deuxieme_prenom\" SIZE='20'></p>";
echo "<p><b>"._T('titre')."</b>";
echo "<BR><INPUT TYPE='text' NAME='titre' VALUE=\"$titre\" SIZE='20'></p>";
echo "<p><b>"._T('profile')."</b>";
echo "<BR><INPUT TYPE='text' NAME='profile'  VALUE=\"$profile\" SIZE='20'></p>";
echo "</div>";
echo "<DIV ALIGN='right'>";
echo "<INPUT CLASS='fondo' TYPE='submit' NAME='Valider' VALUE='"._T('valider')."'>";
echo "</DIV>";
echo "</FORM>";
fin_boite_info();

//Gestion de la boite d'information, pour indiquer les dtails de la newsletter
$suber = &recuperer_instance_subscriber_link();
$tab_mode = $suber->nbUserHtmlText($id_newsletter);
unset($suber);
$suber2 = &recuperer_instance_subscriber_pending();
$tab_mode2 = $suber2->nbUserHtmlText($id_newsletter);
unset($suber2);
$tot_inscrit = $tab_mode[1]+$tab_mode[0];
$tot_non_inscrit = $tab_mode2[1]+$tab_mode2[0];
$total = $tot_inscrit+$tot_non_inscrit;

debut_boite_info();
echo '<strong>'._T('details').'</strong><br />';
echo "<img src='img_pack/puce-blanche.gif' alt='' width='8' height='9' border='0' />";
echo "&nbsp;&nbsp;"._T('nb_user_tot')."&nbsp;:&nbsp;".$total.'<BR />';
echo "<img src='img_pack/puce-verte.gif' alt='' width='8' height='9' border='0' />";
echo "&nbsp;&nbsp;"._T('nb_user_ins')."&nbsp;:&nbsp;".$tot_inscrit.'<BR />';
if(is_array($tab_mode))
    echo "<div style='padding-left:30px'>Html : ".$tab_mode[0]."<BR />Texte : ".$tab_mode[1].'</div>';
echo "<img src='img_pack/puce-rouge.gif' alt='' width='8' height='9' border='0' />";
echo "&nbsp;&nbsp;"._T('nb_user_att')."&nbsp;:&nbsp;".$tot_non_inscrit.'<BR />';
if(is_array($tab_mode2))
    echo "<div style='padding-left:30px'>Html : ".$tab_mode2[0]."<BR />Texte : ".$tab_mode2[1].'</div>';
fin_boite_info();


//Dbut du container principal
debut_droite();
debut_cadre_relief("newsletter-24.gif");
gros_titre($titreNewsletter);

echo "<div class='contenu_propre' ><a name='liste_des_utilisateurs' />";
if(($inscrits==1)&&($non_inscrits==1)) titre_bloc_contenu(_T('liste_utilisateurs'));
else if($inscrits==1) titre_bloc_contenu("Liste des utilisateurs inscrits");
else if($non_inscrits==1) titre_bloc_contenu("Liste des utilisateurs en attente de validation");
echo "</div>";


unset($subscriber);

//Affichage de la liste des utilisateurs inscrits  la newsletter, et du bouton de suppression
//Affichage des boutons supprimeer et cr"ation des liens avec le bon numro de suppression
$subscriber = &recuperer_instance_subscriber_link(); 
if($inscrits==1){
   if($searchByUser!=""){
   		$tab_retour = $subscriber->searh_mail_inscrit($id_newsletter, $searchByUser);
        $tab_inscrit_new = $tab_retour[0];
        $tab_initial = $tab_retour[1];
	}else{
    	$tab_retour = $subscriber->liste_user_inscrit($id_newsletter);
    	$tab_inscrit_new = $tab_retour[0];
    	$tab_initial = $tab_retour[1];
	}
}
if($non_inscrits==1){
    if($searchByUser!=""){
   		$tab_retour2 = $subscriber->searh_mail_non_inscrit($id_newsletter, $searchByUser);
        $tab_inscrit_new = $tab_retour[0];
        $tab_initial2 = $tab_retour2[1];
	}else{
    	$tab_retour2 = $subscriber->liste_user_non_inscrit($id_newsletter);
        $tab_non_inscrit_new = $tab_retour2[0];
        $tab_initial2 = $tab_retour2[1];
	}
}


$result2 = array_merge($tab_initial, $tab_initial2);
$result = array_merge($tab_non_inscrit_new, $tab_inscrit_new);
$result2 = array_change_key_case($result2, CASE_UPPER);
$result = array_change_key_case($result, CASE_LOWER);
ksort($result2);
ksort($result);



//Gestion de la boite d'information, pour filtrer les utilisateurs recenss pour la newsletter (en attente ou inscrits)
echo '<div style="font-size: 0.9em;"><div style="float:left;margin-bottom: 3px;">';
echo '<a href="?action='._T('chercher').$string_newsletter.$string_search.'&inscrits=1&non_inscrits=1#liste_des_utilisateurs">Tous</a> - ';
echo '<a href="?action='._T('chercher').$string_newsletter.$string_search.'&inscrits=1#liste_des_utilisateurs">'._T('subscribers').'</a> - ';
echo '<a href="?action='._T('chercher').$string_newsletter.$string_search.'&non_inscrits=1#liste_des_utilisateurs">'._T('unsubscribers').'</a> - ';
echo '</div>';
echo '<div style="float:right;">';
if($message!=""){
 //Affichage du message de suppression d'un utilisateur, (creation du message plus haut)
 echo "<div>".$message."</div>";
 unset($message);
}
if ($erreur_mail!=""){
 //Affichage du message si le mail a mal t tapp, ou si l'adresse est fausse
 echo "<div>".$erreur_mail."</div>";
 unset($erreur_mail);
}
echo '</div><br style="clear: both;" />';


if(!isset($_GET['search'])) $search =$result2[0];
else  $search = $_GET['search'];
//var_dump($search);
$result_key = array_keys($result);
echo "<table cellspacing='0' cellpadding='3' width='100%' style='border: solid 1px ".$couleur_foncee.";' ><tr><td colspan='6' style='text-align: center;'><div><div id='raccourcis_initiale' style='display:'>";
echo "<div style='float: right;'><a href='#liste_des_utilisateurs' onClick='affiche_panneau_recherche()'><img src='img_pack/suivi-forum-24.gif' border='0' alt=''></a></div><div style='float: left;'";
//Cration de l'url pour les initiales
if (isset($result2))
   while(list($k,) = each($result2)){
        $gras_deb="";
        $gras_fin="";
		if($search=="") $search = $k;
        $k =strtoupper($k);
        if($search==$k){
            $gras_deb="[";
            $gras_fin="]";
            }
        $chaine_inscrit ="";
        $chaine_non_inscrit ="";
        if(isset($inscrits)) 
            $chaine_inscrit = "inscrits=1&";
        if(isset($non_inscrits)) 
            $chaine_non_inscrit = "non_inscrits=1&";
        if(!is_numeric($k))
            echo "<a href='?id_newsletter=$id_newsletter&".$chaine_inscrit.$chaine_non_inscrit."search=".strtoupper($k).$stringSearchByUser."#liste_des_utilisateurs' style='font-size: 13px;'>".$gras_deb.$k.$gras_fin."</a>&nbsp;&nbsp;";
}
echo "</div></div>";


//Panneau de recherche cf. javascript d'ouverture / fermeture
echo "<div id='panneau_recherche' style='display: none;' >";
echo "<div style='float: right;'><a href='#liste_des_utilisateurs' onClick='affiche_panneau_recherche()'><img src='img_pack/suivi-forum-24.gif' border='0' alt=''></a></div>";
echo "<div style='float: left;'>";
echo "<form method='get' style='padding: 0; margin: 0;' action='#liste_des_utilisateurs'>";
echo "<input type='text' name='searchByUser' value='' />";
echo "<input type='hidden' name='id_newsletter' value='".$id_newsletter."' />";
if(isset($inscrits))
	echo "<input type='hidden' name='inscrits' value='".$inscrits."' />";
if(isset($non_inscrits))
	echo "<input type='hidden' name='non_inscrits' value='".$non_inscrits."' />";
echo "<input type='submit' name='' value='chercher' class='fondo' />";
echo "</form>";
echo "</div></div><br class='nettoyage' />";
echo "<hr /></td></tr>";

$currentPaginationMin = ($page-1) * $pagination;
$currentPaginationMax = $page * $pagination;
$counterPagination = 0;


foreach($result_key as $key){
    if(strtolower(substr($key,0,1))==strtolower($search)){
	  if(($counterPagination>=$currentPaginationMin)&&($counterPagination<$currentPaginationMax)){
		echo("<tr id='rangee".$counterPagination."' onMouseOver='changeColor($counterPagination)' onMouseOut='backColor($counterPagination)'>");
        $res = $result[$key];
        if($res['mode']==0)
            $mode = "Texte";
        else $mode ="Html";
		$user = $res['email'];

		$userComplet =  ereg_replace("(.*)@(.*)", "\\1", $user);				
		$nomReel = str_replace("_"," ",str_replace("."," ",$userComplet));		
		$domaineComplet =  ereg_replace("(.*)@(.*)", "\\2", $user);
		$domaine = eregi_replace("(.*)\.(.*)", "\\1", $domaineComplet);
		$langue = eregi_replace("(.*)\.(.*)", "\\2", $domaineComplet);
		//$refGoogleSearch = "<a href='http://www.google.fr/search?q=".$domaine."&btnG=Recherche+Google' title='chercher avec google' target='_parent'>";
		//$refGoogleSearch = "<a href='https://intranet.clever-age.net/commercial/index.php?name=".$domaine."&address_city=&website=&phone=&action=index&query=true&module=Accounts&button=Search' >";
		//$refgoogleEnd = "</a>";		
		$refGoogleSearch = "";
		$refgoogleEnd = "";

        if($res['statut']=='PENDING'){
            echo "<td ><img src='img_pack/puce-rouge.gif' alt='' width='8' height='9' border='0' ></td>";
            echo "<td ><a href='mailto:".$res['email']."'>".$nomReel."</a></td><td>".$refGoogleSearch."".$domaine."".$refgoogleEnd."</td><td>".$langue."</td><td>".($res['mode']==1?'<img src="img_pack/html.gif" alt="HTML">':'<img src="img_pack/text.gif" alt="Text">')."</td><td><a href='?suppress=".$res['sub_id']."".$string_newsletter.$string_search.$string_inscrits.$string_non_inscrits."&type=0#liste_des_utilisateurs' border='0' title="._T('supprimer').$res['email'].">";
            echo "<img src='img_pack/suppress.gif' height='12' width='12' alt='"._T('supprimer').$res['email']."#liste_des_utilisateurs'></a>&nbsp;&nbsp;";
            echo "<a href='?activate=".$res['sub_id'].$string_newsletter.$string_search.$string_inscrits.$string_non_inscrits."#liste_des_utilisateurs' border='0' title="._T('ajouter_liste').">";
            echo "<img src='img_pack/ajout.gif' height='12' width='12' alt='"._T('ajouter_liste')."$mail'></a></td>";
        }
         else{
            echo "<td><img src='img_pack/puce-verte.gif' alt='' width='8' height='9' border='0' ></td>";
            echo "<td ><a href='mailto:".$res['email']."'>".$nomReel."</a></td><td>".$refGoogleSearch."".$domaine."</a></td><td>".$langue."</td><td>".($res['mode']==1?'<img src="img_pack/html.gif" alt="HTML">':'<img src="img_pack/text.gif" alt="Text">')."</td><td><a href='?suppress=".$res['sub_id'].$string_newsletter.$string_search.$string_inscrits.$string_non_inscrits."&type=1#liste_des_utilisateurs' border='0' title="._T('supprimer').$res['email'].">";
            echo "<img src='img_pack/suppress.gif' height='12' width='12' alt='"._T('supprimer').$res['email']."'></a></td>";
        }
        echo("</tr>");
    }
  $counterPagination++;
  }
}

echo "<tr><td colspan='6'><hr />";
//Creation des fleches de pagination
echo "<div style='float: left;width: 33%;'>&nbsp;";
if($page>1)
	echo "<a href='?".$string_newsletter.$string_search.$stringSearchByUser.$string_inscrits.$string_non_inscrits."&page=".($page-1)."#liste_des_utilisateurs' title='Page prcdente'><img src='img_pack/rew.png' alt='Page prcdente' border='0' /></a>";

$nbTotalPage = (int)($counterPagination/$pagination+1);
if($nbTotalPage==0) $nbTotalPage=1;
echo "</div><div style='float: left;width: 33%;text-align: center;'>".($page)." / ".$nbTotalPage."</div><div style='float: right;width: 33%; text-align: right;'>&nbsp;";

if($page<$nbTotalPage)
	echo "<a href='?".$string_newsletter.$string_search.$stringSearchByUser.$string_inscrits.$string_non_inscrits."&page=".($page+1)."#liste_des_utilisateurs' title='Page suivante'><img src='img_pack/fwd.png' alt='Page suivante' border='0' /></a>";
echo "</div></td></tr>";
echo "</table>";
fin_cadre_relief();


//Choix du fichier  exporter au format CVS dans le fichier exportation.php3
echo "<FORM action='export_newsletter_user_csv.php?id_newsletter=$id_newsletter' method='post' >";
debut_cadre_formulaire();
echo '<strong>'._T('fichier_csv_export').'</strong><br />';
echo "<DIV ALIGN='right'>";
echo "<INPUT align = 'right' CLASS='fondo' TYPE='submit' NAME='Exporter' VALUE='"._T('Exporter')."'>";
echo "</DIV>";
fin_cadre_formulaire();
echo "</FORM>";
echo "<FORM action='?id_newsletter=$id_newsletter&search=tous".$string_inscrits.$string_non_inscrits."' method='post' enctype='multipart/form-data'>";
debut_cadre_formulaire();
echo '<strong>'._T('fichier_csv_import').'</strong><br />';
echo _T('nom_du_fichier_import').'&nbsp;&nbsp;&nbsp;<input type="file" name="imfile" ><br /><br />';
echo "<DIV ALIGN='right'>";
echo "<INPUT align = 'right' CLASS='fondo' TYPE='submit' NAME='Importer' VALUE='"._T('Importer')."'>";
echo "</DIV>";
fin_cadre_formulaire();
echo "</FORM>";
if($Csv==true)fclose($handle);
fin_page();

?>
<script language="JavaScript" type="text/javascript">
<!--

  var countEchange = 0;

  function changeColor(iCount){
   	document.getElementById("rangee" + iCount).style.background = "<?=$couleur_claire ?>";
   }
  
  function backColor(iCount){
  	document.getElementById("rangee" + iCount).style.background = "#FFFFFF"
  
  }

  function affiche_panneau_recherche(){

  	if(countEchange == 0){
        document.getElementById("raccourcis_initiale").style.display = "none"
        document.getElementById("panneau_recherche").style.display = "block"
        countEchange = 1	 										   
	}else{
		document.getElementById("panneau_recherche").style.display = "none"
		document.getElementById("raccourcis_initiale").style.display = "block"
		countEchange = 0  	  
	}
  }
//-->
</script>