<?php
global $nl_preview_path;

if (isset($nl_preview_path)) {
	$GLOBALS['dossier_squelettes']='ecrire/squelettes_newsletter/'.$nl_preview_path;
} else {
	$GLOBALS['dossier_squelettes'] = ($GLOBALS['dossier_squelettes'] ? $GLOBALS['dossier_squelettes'].'/' : '');
}

// Filtre SMILEYS - 23 janvier 2003
// pour toute suggestion, remarque, proposition d'ajout d'un
// smileys, etc ; reprotez vous au forum de l'article :
// http://www.uzine.net/spip_contrib/article.php3?id_article=38

function smileys($chaine) {
	$chemin = '<img alt="binette" src="IMG/binettes/';

	// On peut mettre les smileys-images o l'on veut. Mais il faut
	// penser  modifier la variable $chemin de la fonction en consquence.
	$chaine = str_replace(":->", $chemin . "diable.png\">", $chaine);
	$chaine = str_replace(":-((", $chemin . "en_colere.png\">", $chaine);
	$chaine = str_replace(":-))", $chemin . "mort_de_rire.png\">", $chaine);
	$chaine = str_replace(":-D", $chemin . "mort_de_rire.png\">", $chaine);
	$chaine = str_replace(":-)", $chemin . "sourire.png\">", $chaine);
	$chaine = str_replace(":'-))", $chemin . "pleure_de_rire.png\">", $chaine);
	$chaine = str_replace(":'-D", $chemin . "pleure_de_rire.png\">", $chaine);
	$chaine = str_replace(":o)", $chemin . "rigolo.png\">", $chaine);
	$chaine = str_replace("B-)", $chemin . "lunettes.png\">", $chaine);
	$chaine = str_replace(";-)", $chemin . "clin_d-oeil.png\">", $chaine);
	$chaine = str_replace(":-p", $chemin . "tire_la_langue.png\">", $chaine);
	$chaine = str_replace(":-|", $chemin . "bof.png\">", $chaine);
	$chaine = str_replace(":-/", $chemin . "mouai.png\">", $chaine);
	$chaine = str_replace(":-o", $chemin . "surprit.png\">", $chaine);
	$chaine = str_replace(":-O", $chemin . "surprit.png\">", $chaine);
	$chaine = str_replace(":-(", $chemin . "pas_content.png\">", $chaine);
	$chaine = str_replace(":'-(", $chemin . "triste.png\">", $chaine);

	return $chaine;
}

// Partie dont il faut prvoir l'ajout  l'install
/*
 * Nom du filtre      : QCM
 * Auteur             : Mathieu GIANNECCHINI
 * Date               : 7 Aot 2003
 * Fonction du filtre : Parse le code du QCM tap dans SPIP et stocke
 *                      les questions, rponses et commentaires
 *                      dans un tableau et retourne le code HTML du QCM
 */
function qcm($chaine){

  /* Messages utiliss dans le QCM
   */
  $titreQCM="QCM";
  $reponseJuste="La r&eacute;ponse est juste";
  $reponseFausse="La r&eacute;ponse est fausse";
  $reponseNulle="Vous n'avez pas r&eacute;pondu";

  /* Bascule permettant de grer les points spcifis dans le
   * code du QCM
   */
  $gestionPoint=true;

  /* Boolen permettant de savoir si il y a un QCM dans l'article
   */
  $qcm=false;

  /* Initialisation du score
   */
  $score=0;

  /* On rcupre le code du qcm entre <qcm> et </qcm>
   */
  while(ereg("<qcm>",$chaine)){
  $qcm=true;
  $codeHTML="";
  list($texteAvant,$suite)=explode("<qcm>",$chaine,2);
  list($qcm,$texteApres)=explode("</qcm>",$suite,2);

  /* On isole les questions les rponses et les commentaires
   */
  $ligne=split("\n",$qcm);
  $nbligne=count($ligne);

  $premierequestion=$nbQuestion;

  for($i=0;$i<$nbligne;$i++){
    /* Pour chaque ligne on regarde le premier caractre
     */
    switch($ligne[$i][0]){
      case 'T' : $titreQCM=substr($ligne[$i],1);break;
      case 'Q' :
	$nbQuestion++;
	$question[$nbQuestion]=substr($ligne[$i],1);
        break;

      case 'P' :
	/* On extrait les prcisions de la proposition
  	 */
 	list($reponse,$precis)=explode("|",$ligne[$i]);

	/* On extrait le numro de la proposition et son contenu
  	 */
	ereg("P([0-9]+)(.*)",$reponse,$eregResult1);
	$numPropos=$eregResult1[1];

        /* On extrait les points ventuellement associs
         *  chaque rponse
         */
        if(ereg("[.](-?[0-9]+)(.*)",$eregResult1[2],$eregResult2)){
          $points[$nbQuestion][$numPropos]=$eregResult2[1];
          $choix[$nbQuestion][$numPropos]= $eregResult2[2];
          //$gestionPoint=true;
        }
        /* Si une erreur de syntaxe apparait
         * on passe en mode par dfaut pour la gestion des points
         */
	else{
          $gestionPoint=false;
          $choix[$nbQuestion][$numPropos]= $eregResult1[2];
        }
       	$precision[$nbQuestion][$numPropos]= $precis;
	break;

      case 'R' :
	/* On rcupre le numro de la bonne rponse
 	 */
	ereg("R([0-9]+)(.*)",$ligne[$i],$eregResult);
	$numProposition=$eregResult[1];
	$bonneReponse[$nbQuestion]=$numProposition;
	break;

      default  : break;
    }
  }

  /*
   * Affichage du QCM
   */
  // Si on ne corrige pas on affiche le QCM
  if (!isset($GLOBALS["var_correction"])){
    for($i=$premierequestion+1;$i<=count($question);$i++){
     $nomVarSelect="var_Q".$i;
     $codeHTML.="<div class=\"spip_qcm_question\"><img src=\"puce.gif\" alt=\"-\"> $question[$i]</div>";
     $codeHTML.="<div class=\"spip_qcm_proposition\">";

      // Si il ya plus de 5 choix, on utilise une liste
      if(count($choix[$i])>5){
        $codeHTML.="<select name=\"$nomVarSelect\" class=\"spip_qcm_select\">";
	for($j=1;$j<=count($choix[$i]);$j++){
          $codeHTML.="<option value=\"$j\">";
	  $codeHTML.=$choix[$i][$j]."</option>";
        }
	$codeHTML.="</select>";
      }
      // Sinon des radio boutons
      else{
        for($j=1;$j<=count($choix[$i]);$j++){
          $codeHTML.="
	   <input
              type=\"radio\"
              name=\"$nomVarSelect\"
              value=\"$j\">";
	  $codeHTML.=$choix[$i][$j]."<br />";
         }
       }
       $codeHTML.="</div><br />";

     }// Fin traitement des questions
    }//Fin du cas sans correction

    // Sinon on affiche la correction
    else{

      // Initialisation du code  retourner
      $codeHTML="";

      for($i=$premierequestion+1;$i<=count($question);$i++){
        $nomVarSelect="var_Q".$i;

        /* On comptabilise le maximum de points que l'on peut obtenir
         */
        if($gestionPoint){
          $pointParQuestion=$points[$i][$bonneReponse[$i]];
          $scoreMax+=$pointParQuestion;
        }
        else{
          $pointParQuestion=1;
          $scoreMax+=$pointParQuestion;
        }

        // La rponse choisie
        $codeHTML.="<div class=\"spip_qcm_question\"><img src=\"puce.gif\" alt=\"-\">$question[$i]<span class=\"spip_qcm_point\">($pointParQuestion pt)</span></div>";

        // Si c'est juste
        if($bonneReponse[$i]==$GLOBALS[$nomVarSelect]){
           // Les points par dfaut : 1 par bonne rponse
           if($gestionPoint){
             $score+=$points[$i][$GLOBALS[$nomVarSelect]];
           }
           else{
             $score++;
           }
           $codeHTML.="<div class=\"spip_qcm_reponse\">$introReponse";
           $codeHTML.=$choix[$i][$GLOBALS[$nomVarSelect]];
           $codeHTML.="</div>";
           $codeHTML.="<div class=\"spip_qcm_correction_juste\">$reponseJuste</div>";
           if (isset($precision[$i][$GLOBALS[$nomVarSelect]])){
             $codeHTML.="<center><div class=\"spip_qcm_precision\">";
       	     $codeHTML.=$precision[$i][$GLOBALS[$nomVarSelect]];
	     $codeHTML.="</div></center>";
           }
        }
        // Si c'est faux
        else{
          if(isset($GLOBALS[$nomVarSelect])){
           $score+=$points[$i][$GLOBALS[$nomVarSelect]];
           $codeHTML.="<div class=\"spip_qcm_reponse\">";
           $codeHTML.=$choix[$i][$GLOBALS[$nomVarSelect]];
           $codeHTML.="</div>";
           $codeHTML.="<div class=\"spip_qcm_correction_faux\">$reponseFausse</div>";

           if (isset($precision[$i][$GLOBALS[$nomVarSelect]])){
             $codeHTML.="<center><div class=\"spip_qcm_precision\">";
	     $codeHTML.=$precision[$i][$GLOBALS[$nomVarSelect]];
       	     $codeHTML.="</div></center>";
           }
          }
	  else{
            $codeHTML.="<div class=\"spip_qcm_correction_null\">$reponseNulle</div>";
          }
        }
        $codeHTML.="<br />";
      }

   }
   // On ajoute les balises <HTML> et </HTML>
   $codeHTML="<html>".$codeHTML."</html>";

   $chaine=$texteAvant.$codeHTML.$texteApres;
  }//fin du while
  if($qcm){
    if (!isset($GLOBALS["var_correction"])){
       $teteFormulaire="<form method=\"post\" action=\"\">";
       $piedFormulaire="
       <br>
       <input type=\"hidden\" name=\"var_correction\" value=\"yes\">
       <center><input type=\"submit\" value=\"Corriger\" class=\"spip_qcm_bouton_corriger\"></center>
       </form>";
       $chaine=$teteFormulaire.$chaine.$piedFormulaire;
    }
    else{
      // On ajoute le score final
      $chaine.="<center><div class=\"spip_qcm_score\">Score : $score / $scoreMax<br></div></center>";
      $chaine.="<div class=\"spip_qcm_bouton_corriger\" align=\"right\">[ <a href=\"$PHP_SELF\">R&eacute;initialiser le QCM</a> ]</div>";
      unset($GLOBALS["var_correction"]);
    }

     $chaine="<center><div class=\"spip_qcm\"><div class=\"spip_qcm_titre\">".$titreQCM."<hr /></div>".$chaine."</div></center>";
  }
   return $chaine;
}

/*
 *   +----------------------------------+
 *    Nom du Filtre : decouper_en_page                                               
 *   +----------------------------------+
 *    Date : Vendredi 6 juin 2003
 *    Auteur :  "gpl"  : gpl@macplus.org  
 *              Aurlien PIERARD : aurelien.pierard@sig.premier-ministre.fr
 *   +-------------------------------------+
 *    Fonctions de ce filtre :
 *		Il sert a prsenter un article sur plusieurs pages  
 *   +-------------------------------------+ 
 *  
 * Pour toute suggestion, remarque, proposition d'ajout
 * reportez-vous au forum de l'article :
 * http://www.uzine.net/spip_contrib/article.php3?id_article=62
*/


function decouper_en_page($texte) {
        global $artsuite, $var_recherche, $num_pages;
		
        if (empty($artsuite)) $artsuite = 0;
	
		// on divise la page (sparateur : "-----")        
        $page = split('-----', $texte);
        // Nombre total de pages
        $num_pages = count($page);

        // Si une seule page ou numro illgal, alors retourner tout le texte.
        // Cas spcial : si var_recherche positionn, tout renvoyer pour permettre  la surbrillance de fonctionner correctement.
        if ($num_pages == 1 || !empty($var_recherche) || $artsuite < 0 || $artsuite > $num_pages) {
			// On place les ancres sur les intertitres
			$texte = preg_replace("|\{\{\{(.*)\}\}\}|U","<a name=\"sommaire_#NB_TITRE_DE_MON_ARTICLE#\">$0</a>", $texte);
			$array = explode("#NB_TITRE_DE_MON_ARTICLE#" , $texte);
			$res =count($array);
			$i =1;
			$texte=$array[0];
			while($i<$res){
				$texte=$texte.$i.$array[$i];
				$i++;
			}
			return $texte;
        } 

        $p_prec = $artsuite - 1;
        $p_suiv = $artsuite + 1;
        $uri_art = generer_url_article($GLOBALS['id_article']);
        $uri_art .= strpos($uri_art, '?') ? '&' : '?';

		// On place les ancres sur les intertitres
		$page[$artsuite] = preg_replace("|\{\{\{(.*)\}\}\}|U","<a name=\"sommaire_#NB_TITRE_DE_MON_ARTICLE#\">$0</a>", $page[$artsuite]);
		$array = explode("#NB_TITRE_DE_MON_ARTICLE#" , $page[$artsuite]);
		$res =count($array);
		$i =1;
		$page[$artsuite]=$array[0];
		while($i<$res){
			$page[$artsuite]=$page[$artsuite].$i.$array[$i];
			$i++;
		}
		// Pagination
	    switch (TRUE) {
			case ($artsuite == 0):
				$precedent = "";
				$suivant = "<a href='" . $uri_art . "artsuite=" . $p_suiv . "'>&gt;&gt;</a>";
				break;
			case ($artsuite == ($num_pages-1)):
				$precedent = "<a href='" . $uri_art . "artsuite=" . $p_prec . "'>&lt;&lt;</a>";
				$suivant = "";
				break;
			default:
				$precedent = "<a href='" . $uri_art . "artsuite=" . $p_prec . "'>&lt;&lt;</a>";
				$suivant = "<a href='" . $uri_art . "artsuite=" . $p_suiv . "'>&gt;&gt;</a>";
				break;
        }
    
        for ($i = 0; $i < $num_pages; $i++) {
			$j = $i;
			if ($i == $artsuite) {
				$milieu .= " <strong>" . ++$j . "</strong> ";
            } 
			else {
				$milieu .= " <a href='" . $uri_art . "artsuite=$i'>" . ++$j . "</a> ";
			}
        }

        // Ici, on peut personnaliser la prsentation
        $resultat .= $page[$artsuite];
        $resultat .= "<p class='pagination'><div class='pagination' align='center'>pages : $precedent $milieu $suivant</div></p>";
        return $resultat;
}
// FIN du Filtre decouper_en_page


/*
 *   +----------------------------------+
 *    Nom du Filtre : Sommaire de l'article                                               
 *   +----------------------------------+
 *    Date : Vendredi 6 juin 2003
 *    Auteur :  Noplay (noplay@altern.org) 
 *              Aurlien PIERARD : aurelien.pierard@sig.premier-ministre.fr                                     
 *   +-------------------------------------+
 *    Fonctions de ce filtre :
 *      Cette modification permet d'afficher le sommaire de l'article 
 *      gnr dynamiquement  partir du texte de l'article. Vous pouvez naviguer 
 *      dans l'article en cliquant sur les titres du sommaires. 
 *
 *      Tous ce qui ce trouve entre {{{ et }}} est considr comme un titre  ajouter au sommaire de l'article.
 *   +-------------------------------------+ 
 *  
 * Pour toute suggestion, remarque, proposition d'ajout
 * reportez-vous au forum de l'article :
 * http://www.uzine.net/spip_contrib/article.php3?id_article=76
*/
//SOMMAIRE
function sommaire_article($texte)
{
		$artsuite = 0;
        $page = split('-----', $texte);
        $uri_art = generer_url_article($GLOBALS['id_article']);
        $uri_art .= strpos($uri_art, '?') ? '&' : '?';

	$i=0;
	$texte="";
	while($page[$i]){
		// On ajoute une ancre aux intertitres "{{{ }}}" que l'on utilise pour crer le sommaire
		preg_match_all("|\{\{\{(.*)\}\}\}|U",$page[$i], $regs);
	 	$nb=1;
		for($j=0;$j<count($regs[1]);$j++){
			$p=$i+1;
	    	$texte=$texte."<a href=\"". $uri_art . "artsuite=" .$i. "#sommaire_".$nb."\" title=\"".$regs[1][$j]."\">".$regs[1][$j]."</a>, p$p<br />";
			$nb++;
	    }
		$i++;
	}
		return $texte;
}
// Fin du filtre sommaire

/*
 *   +----------------------------------+
 *    Nom du Filtre :    accord_pluriel
 *   +----------------------------------+
 *    Date : mercredi 16 avril 2003
 *    Auteur :  Roustoubi (roustoubi@tiscali.fr)
 *   +-------------------------------------+
 *    Fonctions de ce filtre :
 *    Accorde le nom singulier pass en paramtre avec le nombre qui le quantifie
 *    Exemple : [#TOTAL_BOUCLE (#TOTAL_BOUCLE|accord_pluriel{article})]
 *   +-------------------------------------+ 
 *  
 * Pour toute suggestion, remarque, proposition d'ajout
 * reportez-vous au forum de l'article :
 * http://www.uzine.net/spip_contrib/article.php3?id_article=111
*/

function accord_pluriel ($nombre, $nom1='', $nom2='') {
	if ($nom1=='') { return "Erreur filtre <b>&laquo; accord_pluriel &raquo;</b> : probl&egrave;me de param&egrave;tre"; }
	if ($nom2!='') {
		$nom2 = " ".$nom2;
		$nom2s = $nom2."s";
	}
	if ($nombre == "0" OR $nombre == "1") {
		$texte = $nombre."&nbsp;".$nom1.$nom2 ;
	}
	else {
		$texte = $nombre."&nbsp;".$nom1."s".$nom2s ;
	}
	return $texte ; 
}
// FIN du Filtre accord_pluriel

// Filtre pour afficher les chiffres en lettre

function chiffre($unites,$genre=''){
	if ($unites==1 AND $genre=='fem'){$retour="une";}
	if ($unites==1 AND $genre!='fem'){$retour="un";}
	if ($unites==2){$retour="deux";}
	if ($unites==3){$retour="trois";}
	if ($unites==4){$retour="quatre";}
	if ($unites==5){$retour="cinq";}
	if ($unites==6){$retour="six";}
	if ($unites==7){$retour="sept";}
	if ($unites==8){$retour="huit";}
	if ($unites==9){$retour="neuf";}

	return $retour;
}

function chiffre_sans($unites){
	if ($unites==2){$retour="deux";}
	if ($unites==3){$retour="trois";}
	if ($unites==4){$retour="quatre";}
	if ($unites==5){$retour="cinq";}
	if ($unites==6){$retour="six";}
	if ($unites==7){$retour="sept";}
	if ($unites==8){$retour="huit";}
	if ($unites==9){$retour="neuf";}

	return $retour;
}

function chiffre_et($unites, $genre=''){
	if ($unites==1 AND $genre=='fem'){$retour=" et une";}
	if ($unites==1 AND $genre!='fem'){$retour=" et un";}
	if ($unites==2){$retour="-deux";}
	if ($unites==3){$retour="-trois";}
	if ($unites==4){$retour="-quatre";}
	if ($unites==5){$retour="-cinq";}
	if ($unites==6){$retour="-six";}
	if ($unites==7){$retour="-sept";}
	if ($unites==8){$retour="-huit";}
	if ($unites==9){$retour="-neuf";}

	return $retour;
}

function chiffre_dix($unites){
	if ($unites==0){$retour="dix";}
	if ($unites==1){$retour="onze";}
	if ($unites==2){$retour="douze";}
	if ($unites==3){$retour="treize";}
	if ($unites==4){$retour="quatorze";}
	if ($unites==5){$retour="quinze";}
	if ($unites==6){$retour="seize";}
	if ($unites==7){$retour="dix-sept";}
	if ($unites==8){$retour="dix-huit";}
	if ($unites==9){$retour="dix-neuf";}

	return $retour;
}

function chiffre_et_dix($unites){
	if ($unites==0){$retour="-dix";}
	if ($unites==1){$retour=" et onze";}
	if ($unites==2){$retour="-douze";}
	if ($unites==3){$retour="-treize";}
	if ($unites==4){$retour="-quatorze";}
	if ($unites==5){$retour="-quinze";}
	if ($unites==6){$retour="-seize";}
	if ($unites==7){$retour="-dix-sept";}
	if ($unites==8){$retour="-dix-huit";}
	if ($unites==9){$retour="-dix-neuf";}

	return $retour;
}


function dizaines($dizaines,$unites,$genre=''){

	if ($dizaines==0){
		$retour=chiffre($unites,$genre);
	}
	if ($dizaines==1){
		$retour=chiffre_dix($unites);
	}
	if ($dizaines==2){
		$retour="vingt".chiffre_et($unites,$genre);
	}
	if ($dizaines==3){
		$retour="trente".chiffre_et($unites,$genre);
	}
	if ($dizaines==4){
		$retour="quarante".chiffre_et($unites,$genre);
	}
	if ($dizaines==5){
		$retour="cinquante".chiffre_et($unites,$genre);
	}
	if ($dizaines==6){
		$retour="soixante".chiffre_et($unites,$genre);
	}
	if ($dizaines==7){
		$retour="soixante".chiffre_et_dix($unites);
	}
	if ($dizaines==8 & $unites>0){
		$retour="quatre-vingt-".chiffre($unites,$genre);
	}
	if ($dizaines==8 & $unites==0){
		$retour="quatre-vingts";
	}
	if ($dizaines==9){
		$retour="quatre-vingt-".chiffre_dix($unites);
	}

	return $retour;

}





function par3($lavaleur,$demille,$genre='masc',$type=''){

	if (strlen($lavaleur)==1){$lavaleur="00".$lavaleur;}
	if (strlen($lavaleur)==2){$lavaleur="0".$lavaleur;}

	$centaines=substr($lavaleur,0,1);
	$dizaines=substr($lavaleur,1,1);
	$unites=substr($lavaleur,2,1);

	if ($centaines>1){
		$cent="cents";
	}

	if ($demille=="mille"){
		$cent="cent";
	}

	if ($dizaines+$unites>0){
		$cent="cent";
	}

	if (($demille=="million" OR $demille=="milliard") AND $centaines+$dizaines+$unites>1){
		$demille=$demille."s";
	}

	if ($centaines+$dizaines+$unites>0){
		$demille=" ".$demille;
	}else{
		$demille="";
	}

	if ($centaines>0){
		$retour=chiffre_sans($centaines)." $cent ".dizaines($dizaines,$unites,$genre);
	}else{
		$retour=dizaines($dizaines,$unites,$genre);
	}

	if (trim($retour)=="un" & trim($demille)=="mille"){
		$retour="";
	}
	if (trim($retour)=="un" AND $type=='date'){
		$retour="premier";
		if($genre=='fem') $retour="premi&egrave;re";
	}

	if($genre=='fem' AND $retour=="un") $retour="une";


	return $retour.$demille;
}



function en_lettres($lavaleur,$genre='masc',$type=''){

	$lavaleur=strrev($lavaleur);

	$unites=par3(strrev(substr($lavaleur,0,3)),"","$genre","$type");
	$milliers=par3(strrev(substr($lavaleur,3,3)),"mille");
	$millions=par3(strrev(substr($lavaleur,6,3)),"million");
	$milliards=par3(strrev(substr($lavaleur,9,3)),"milliard");

	return trim("$milliards $millions $milliers $unites");

}

function jour_en_lettres($lavaleur){
	return en_lettres($lavaleur,'','date');
}

function en_lettres_fem($lavaleur){
	return en_lettres($lavaleur,'fem','');
}




function enlettres($lenombre,$unite='',$unites='',$entre='',$apres='',$apress=''){


	$lenombre=ereg_replace(",",".",$lenombre);
	$lenombre=explode(".",$lenombre);

	$entier=$lenombre[0];

	if ($entier>1 & strlen($unite)>0){
		$unite=$unites;
	}

	$virgule=$lenombre[1];
	if ($virgule>1 & strlen($apres)>0){
		$apres=$apress;
	}

	if ($entier==0 OR $virgule==0){
		$entre="";
	}


	if ($entier==0){
		$unite="";
	}
	$entier=en_lettres($entier);

	if ($virgule==0){
		$apres="";
	}
	$virgule=en_lettres($virgule);


	return trim("$entier $unite $entre $virgule $apres");
}

// Fin du filtre EN LETTRE

/*
 *   +----------------------------------+
 *    Nom du Filtre :    nb_spip2xhtml
 *                       nb_checkparas
 *   +----------------------------------+
 *    Date : jeudi 22 mai 2003
 *    Auteur :  stef      + nospam@notabene.f2o.org
 *              Aurlien
 *   +-------------------------------------+
 *    Fonctions de ces filtres :
 *     Ils rendent conforme  xhtml le contenu gnr par spip
 *   +-------------------------------------+ 
 *  
 * Pour toute suggestion, remarque, proposition d'ajout
 * reportez-vous au forum de l'article :
 * http://www.uzine.net/spip_contrib/article.php3?id_article=164
*/

// FILTRE POUR COMPLIANCE XHTML 1.0

/*
* reformatage des intertitres
* */

$GLOBALS['debut_intertitre'] = "\n<h3>";
$GLOBALS['fin_intertitre'] = "</h3>\n";

/*
* formatage du contenu pour validation xhtml
* */

function nb_spip2xhtml($str) {
    if($str!="") {
        // suppresion des hspace, vspace
        $str = preg_replace( "/(h|v)space='.'|border=0/i" , "" , $str);
        
        // img xhtml <img> -> <img />
        $str = preg_replace( "/<img([^>]*)>/i" , "<img \\1 />" , $str);
        
        // align -> style text-align
        $str = preg_replace( "/align='([a-z]*)'/i" , "style=\"float:\\1;\"" , $str);
        
        // h3 imbrique dans un p
        $str = preg_replace( "/<p class=\"spip\"> <h3>/i" , "<h3>" , $str);
        $str = preg_replace( "/<\/h3>( )*<\/p>/i" , "</h3>" , $str);
        
        // tableaux imbriques dans p
        $str = preg_replace( "/<p class=\"spip\"><table class=\"spip\">/i" , "<table>" , $str);
        $str = preg_replace( "/<\/table>( )*<\/p>/i" , "</table>" , $str);
        
        // ol ou ul imbrique dans p
        $str = preg_replace( "/<p class=\"spip\"><(o|u)l class=\"spip\">/i" , "<\\1l class=\"spip\">" , $str);
        $str = preg_replace( "/<\/(o|u)l>( )*<\/p>/i" , "</\\1l>" , $str);
        
        // <br> -> <br />
        $str = preg_replace( "/<br>/i" , "<br />" , $str);
        
        // <b> -> <strong> et <i> -> <em>
        $str = preg_replace( "/(<b class=\"spip\">|<b>)/i" , "<strong>" , $str);
        $str = preg_replace( "/(<i class=\"spip\">|<i>)/i" , "<em>" , $str);
        $str = preg_replace( "/<\/b>/i" , "</strong>" , $str);
        $str = preg_replace( "/<\/i>/i" , "</em>" , $str);

        // FORMULAIRE
        // passage des balises en minucule
        $str = ereg_replace("<FORM", "<form", "$str");
        $str = ereg_replace("<INPUT", "<input", "$str");
        $str = ereg_replace("<TEXTAREA", "<textarea", "$str");
        $str = ereg_replace("</TEXTAREA>", "</textarea>", "$str");
        $str = preg_replace("/(<.*?)(TYPE=\')(.*?)(\')(.*?>)/", "\\1type=\"\\3\"\\5", "$str");
        $str = ereg_replace("VALUE=", "value=", "$str");
        // Pour le formulaire FORUM cration des attributs id
        $str = preg_replace("/(<.*?)(NAME=')(.*?)(')(.*?>)/", "\\1id=\"\\3\" name=\"\\3\"\\5", "$str");		
        // On remplace name par id dans la balise form
        $str = preg_replace("/(<form.*?)(name=)(.*?>)/", "\\1id=\\3", "$str");
        // on ferme les balises input
        $str = preg_replace("/(<input.*?)(>)/", "\\1 />", "$str");
        // On supprime l'attribut WRAP des zones de texte qui n'est pas valide xhtml
        $str = preg_replace("/(<textarea.*?)( wrap=hard| wrap=soft| wrap=off)(.*?>)/", "\\1\\3", "$str");
        
    }
    
    // renvoyer la chaine corrigee
    return $str;
}
// FIN du filtre nb_spip2xhtml

/*
* les notes ont un petit bug :il manque parfois le <p> de debut
* cette fonction y remedie
* fonction utilisee aussi sur mon site pour la bio des auteurs notamment
* */

function nb_checkparas($str) {
    $str = trim($str);
    if($str!="") {
        if(substr($str, 0, 2)!="<p") {
            $str = "<p>" . $str;
        }
        if(substr($str, strlen($str)-4, 4)!="</p>") {
            $str .= "</p>";
        }
    }
    return $str;
}
// FIN du filtre nb_checkparas

function nettoyer_marqueur($texte) {
	// Enlve la conversion caractres spciaux HTML
	$trans_tbl = get_html_translation_table (HTML_ENTITIES);
	$trans_tbl = array_flip ($trans_tbl);
	$texte=strtr ($texte, $trans_tbl);
	$accents =
			/* A */ chr(192).chr(193).chr(194).chr(195).chr(196).chr(197).
			/* a */ chr(224).chr(225).chr(226).chr(227).chr(228).chr(229).
			/* O */ chr(210).chr(211).chr(212).chr(213).chr(214).chr(216).
			/* o */ chr(242).chr(243).chr(244).chr(245).chr(246).chr(248).
			/* E */ chr(200).chr(201).chr(202).chr(203).
			/* e */ chr(232).chr(233).chr(234).chr(235).
			/* Cc */ chr(199).chr(231).
			/* I */ chr(204).chr(205).chr(206).chr(207).
			/* i */ chr(236).chr(237).chr(238).chr(239).
			/* U */ chr(217).chr(218).chr(219).chr(220).
			/* u */ chr(249).chr(250).chr(251).chr(252).
			/* yNn */ chr(255).chr(209).chr(241);
	$texte = ereg_replace("<[^<]*>", "", $texte);
	$texte = ereg_replace("[\!\?']", " ", $texte);
	$texte = ereg_replace("", "_", $texte);
	$texte = ereg_replace(" ", "_", $texte);
    $texte = str_replace ('&#8217;', '_', $texte);
	return strtolower(strtr($texte,$accents,"AAAAAAaaaaaaOOOOOOooooooEEEEeeeeCcIIIIiiiiUUUUuuuuyNn"));
}

function pdf_first_clean($texte) {
        // $texte = ereg_replace("<p class[^>]*>", "<P>", $texte);
        //Translation des codes iso
        // PB avec l'utilisation de <code>
        $trans = get_html_translation_table(HTML_ENTITIES);
        $trans = array_flip($trans);
        $trans["<br />\n"] = "<BR>";        // Pour viter que le \n ne se tranforme en espace dans les <DIV class=spip_code> (TT, tag SPIP : code)
        $trans["?"] = "oe";
        $trans["?"] = "...";
        $trans["'"] = "'";
        $trans["-"] = "-";
        $trans["'"] = "'";
        $trans['"'] = "\"";
        $trans['"'] = "\"";
        $trans["&ucirc;"] = "";
        $trans['$'] = '\$';
        $trans['->'] = '-';
        $trans['<-'] = '-';
        $texte = strtr($texte, $trans);
                
        // Echappement des "
         $texte = ereg_replace("\"", "\\\"", $texte);

        // Traitement des Espaces
        $texte = ereg_replace("(&nbsp;| )+", " ", $texte);

        // Traitement des cadres
        $trans=array("\n" => '<BR>');
        while (preg_match('/(.*<textarea[^>]*>)(.*\n.*)(<\/textarea>.*)/ims', $texte, $textarea)) {
                $rep=strtr($textarea[2], $trans);
                $texte=$textarea[1].$rep.$textarea[3];
        }

        return $texte;
}

?>
