<?php
//
// +----------------------------------------------------------------------+
// | A better XP test case adapted to Agora project                       |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Maciek Borowka <mborowka@clever-age.com                      |
// +----------------------------------------------------------------------+
//


require_once 'PHPUnit.php';

class CA_TestCase extends PHPUnit_TestCase
{
	var $verboseTest;
	
	/**
	* Asserts that the string representation of two variables are equal.
	* XXX FIXME: Does it work for arrays?
	*
	* @param  mixed
	* @param  mixed
	* @param  string
	* @param  mixed
	* @access public
	*/
	function assertLooselyEquals($expected, $actual, $message = '') 
	{           
		settype($actual, "string");
		settype($expected, "string");
		$actual = str_replace("\r\n", "\n", $actual);
		$expected = str_replace("\r\n", "\n", $expected);
		
		$actual = trim($actual);
		$expected = trim($expected);

		//$this->echo_h1('-'.$actual.'-');
		//$this->echo_h1('-'.$expected.'-');
		if (strcmp($actual, $expected) != 0) {
			//$this->echo_h1("DIFFERENT");
			$message = sprintf(
				'%sOups, expected "%s", actual "%s"',
				!empty($message) ? $message . ' ' : '',
				$expected,
				$actual
				);
			return $this->fail($message);
		}
	}
	/**
	* Debug output of two strings: the reference one and the actual one.
	*/
	function compareTwoStrings($refstr, $actualstr)
	{
		settype($refstr, "string");
		settype($actualstr, "string");
		
		echo "<PRE> REFERENCE: \n";
		echo "---".$refstr."---";
		echo "</PRE>";
		echo "<PRE> ACTUAL: \n";
		echo "---".$actualstr."---";
		echo "</PRE>";
		if ($refstr == $actualstr)
		{
			echo "<p>Equals!</p>";
			
			if (!is_string($refstr))
				echo "<p>Ref is not a string, however.</p>";
			
			if (!is_string($actualstr))
				echo "<p>Actual is not a string, however.</p>";
		}
		else
		{
			echo "<p>WTF?</p>";
			echo strlen($refstr);
			echo "<br/>";
			echo strlen($actualstr);
		}
	}
	
	/** Echoes a string if verbose flag has been set.
	*/	
	function echo_p($texte)
	{
		if ($this->verboseTest)
			echo '<p>'.$texte."</p>\n";
	}
	
	/** Quick hack to get a very visible echo output
	* Works only if the verbose flag has been set.
	*/	
	function echo_h1($texte)
	{
		if ($this->verboseTest)
			echo '<h1>'.$texte."</h1>\n";
	}
}

?>
