<?php
//
// +----------------------------------------------------------------------+
// | The suite of PHPTests for the BD business layer - class document     |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Maciek Borowka <mborowka@clever-age.com                      |
// +----------------------------------------------------------------------+
//


$new_include_dir = dirname(__FILE__)."/../../";
set_include_path(get_include_path() . ":" . $new_include_dir);


require_once (dirname(__FILE__).'../../../ecrire/include/bd/inc_document_factory.php');
require_once (dirname(__FILE__).'../../../tests/CA_TestCase.php');

//quelques constantes
require_once dirname(__FILE__).'/../dxs/inc_test_dxs.php';

define("IDDOC_REFERENCE", 1);


class BD_DocumentTest extends CA_TestCase
{
    //var $refdocument;
        
    function BD_DocumentTest($name) {
        $this->CA_TestCase($name);
    }

    // called before the test functions will be executed
    function setUp() {
        //$this->refdocument = &recuperer_instance_document();
        //$this->refdocument->load(IDDOC_REFERENCE);
    }

    // called after the test functions are executed
    function tearDown() {
        //unset($this->refarticle);
    }

    function testGetFichierContenu() 
    {
        echo "<p>------- TEST: testGetFichierContenu.</p>\n";
        $document = &recuperer_instance_document();
        $document->load(IDDOC_REFERENCE);
        $this->assertEquals($GLOBALS['testunit_dxs_tailledoc'], $document->_taille, "Taille du fichier");
        $actual = $document->getFichierContenu();
        $real = file_get_contents ( dirname(__FILE__).'../../../IMG/sxw/beta.sxw', TRUE);
        $this->assertTrue($real, "Reference file really exists");
        $this->assertTrue($real == $actual, "Binary file read correctly");
        echo "\n<p>------- TEST: testGetFichierContenu END.</p>\n";
    }

    function testTaille()
    {
        $contenu = '1234';
        echo "<p>------- TEST: testTaille.</p>\n";
        $document = &recuperer_instance_document();
        $document->setFichierContenu($contenu);
        $this->assertEquals(4, $document->_taille);
        echo "\n<p>------- TEST: testTaille END.</p>\n";
    }
    
    function testEncodeBase64() 
    {
        echo "<p>------- TEST: testGetFichierContenu.</p>\n";
	$decoded = 'ALA';
	$encoded = 'QUxB';
	
	$document2 = &recuperer_instance_document();
	$document2->setFichierContenuBase64($encoded);
	
        $this->assertEquals(3, $document2->_taille, "Taille du fichier");
        $after = $document2->getFichierContenu();
	
        $this->assertEquals($decoded, $after, "BEFORE = AFTER");
        echo "\n<p>------- TEST: testGetFichierContenu END.</p>\n";
    }

    function testEncodeFichier() 
    {
        echo "<p>------- TEST: testGetFichierContenu.</p>\n";
	
	$document = &recuperer_instance_document();
	$document->load(IDDOC_REFERENCE);
        $before = $document->getFichierContenu();
	
	$document2 = &recuperer_instance_document();
	$document2->setFichier('IMG/arton4.png');
	
        $after = $document2->getFichierContenu();
	
	$this->assertEquals(strlen($before), strlen($after), "BEFORE = AFTER");
        //$this->assertEquals($before, $after, "BEFORE = AFTER");
        echo "\n<p>------- TEST: testGetFichierContenu END.</p>\n";
    }
    
    function testEncodageBase64() 
    {
        echo "<p>------- TEST: testGetFichierContenu.</p>\n";
        //on prend le contenu, on l'encode, on le decode, on compare.
        $document = &recuperer_instance_document();
        $document->load(IDDOC_REFERENCE);
        $before = $document->getFichierContenu();
        
	$dataEncoded = $document->getFichierContenuBase64();
	
	$document2 = &recuperer_instance_document();
	$document2->setFichierContenuBase64($dataEncoded);
	
        $this->assertEquals($GLOBALS['testunit_dxs_tailledoc'], $document2->_taille, "Taille du fichier");
        $after = $document->getFichierContenu();
	
        $this->assertTrue($before == $after, "BEFORE = AFTER");
        echo "\n<p>------- TEST: testGetFichierContenu END.</p>\n";
    }

    
}

{ //main
	$suite  = New PHPUnit_TestSuite('BD_DocumentTest');
	$result = PHPUnit::run($suite);
	echo $result->toHtml();
}

?>
