<?php
//
// +----------------------------------------------------------------------+
// | The suite of PHPTests for the DXS Framework - class article          |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Maciek Borowka <mborowka@clever-age.com                      |
// +----------------------------------------------------------------------+
//



$new_include_dir = dirname(__FILE__)."/../../";
set_include_path(get_include_path() . ":" . $new_include_dir);


require_once 'tests/CA_TestCase.php';

//l'objet a tester
require_once 'ecrire/include/bd/inc_article_factory.php';
require_once 'ecrire/include/dxs/article.php';

//quelques constantes
require_once 'inc_test_dxs.php';

class DXS_ArticleTest extends CA_TestCase
{
	var $refarticle;


	function DXS_ArticleTest($name) {
		$this->CA_TestCase($name);
		
	}

	// called before the test functions will be executed
	function setUp() {
		$this->refarticle = &recuperer_instance_article();
		$this->refarticle->load($GLOBALS['testunit_dxs_idarticle']);
		
		$this->verboseTest = FALSE;

	}

	// called after the test functions are executed
	function tearDown() {
		unset($this->refarticle);
	}

	function testNothing() 
	{
		$this->echo_p("<p>------- TEST: testNothing.</p>\n");
		$this->assertTrue(TRUE);
		$this->echo_p("\n<p>------- TEST: testNothingg END.</p>\n");
	}

	function testWrongFile() {
		$testFile = "certainly_inexistant_file_or_at_least_I_hope_so.xml";
		$this->echo_p("<p>------- TEST: testWrongFile: $testFile.</p>\n");
		$entity = new DXS_Article();
		
		$this->assertFalse($entity->getAgoraEntity($testFile));
		$this->echo_p("\n<p>------- TEST: testWrongFile END.</p>\n");
	} 

	
	function testGetAgoraEntity() {
		$testFile = $GLOBALS['testunit_dxs_urlarticle'];
		$this->echo_p("<p>------- TEST: testGetAgoraEntity (ARTICLE): $testFile</p>\n");
		$entity = new DXS_Article();
		$agoraArticle = $entity->getAgoraEntity($testFile);
		
                //basic verifications
		$this->assertEquals('100/INIT OK', $entity->debugLastError, 'Debug error.');
		$this->assertTrue(isset($agoraArticle), "Agora Article an object");

		if (isset($agoraArticle))
                {
			//$this->assertEquals($this->refarticle->getArticleId(), $agoraArticle->getArticleId());
			$this->assertEquals($this->refarticle->getLang(), $agoraArticle->getLang());
			$this->assertLooselyEquals($this->refarticle->getSurtitre(), $agoraArticle->getSurtitre(), 'Surtitre:');
			$this->assertLooselyEquals($this->refarticle->getTitre(), $agoraArticle->getTitre(), 'Titre:');
			$this->assertLooselyEquals($this->refarticle->getSoustitre(), $agoraArticle->getSoustitre(), 'Soustitre:');
			$this->assertLooselyEquals($this->refarticle->getDescriptif(), $agoraArticle->getDescriptif(), 'Descriptif:');
			$this->assertLooselyEquals($this->refarticle->getChapo(), $agoraArticle->getChapo(), 'Chapo:');
			$this->assertLooselyEquals($this->refarticle->getTexte(), $agoraArticle->getTexte(), 'Texte:');
			$this->assertLooselyEquals($this->refarticle->getPs(), $agoraArticle->getPs(), 'PS:');
			$this->assertEquals($this->refarticle->getDate(), $agoraArticle->getDate());
			$this->assertEquals($this->refarticle->getModificationDate(), $agoraArticle->getModificationDate());
		}
		$this->echo_p("\n<p>------- TEST: testGetAgoraEntity END.</p>\n");
	} 
    
}


{ //main
	$suite  = New PHPUnit_TestSuite('DXS_ArticleTest');
	$result = PHPUnit::run($suite);
	echo $result->toHtml();
}


?>
