<?php
//
// +----------------------------------------------------------------------+
// | The suite of PHPTests for the DXS Framework - class container        |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Maciek Borowka <mborowka@clever-age.com                      |
// +----------------------------------------------------------------------+
//



$new_include_dir = dirname(__FILE__)."/../../";
set_include_path(get_include_path() . ":" . $new_include_dir);


//XXX BUG dans Agora:
require_once (dirname(__FILE__)."../../../ecrire/mes_options.php3");

require_once 'tests/CA_TestCase.php';

//l'objet a tester
require_once 'ecrire/include/bd/inc_rubrique_factory.php';
require_once 'ecrire/include/dxs/container.php';

//quelques constantes
require_once 'inc_test_dxs.php';

class DXS_ContainerTest extends CA_TestCase
{
	function DXS_ContainerTest($name) {
		$this->CA_TestCase($name);
	}

	// called before the test functions will be executed
	function setUp() {
		$this->verboseTest = FALSE;
	}

	// called after the test functions are executed
	function tearDown() {
	}

	function testErrorHandling() {
		$testUrl = "http://localhost/aaaaaaaaaaaaaaaaaaaaarubrique-dxs.php3";
		$this->echo_p("<p>------- TEST: testErrorHandling: $testUrl</p>\n");
		
		$entity = new DXS_Container();
		$agoraRubrique = $entity->getAgoraEntity($testUrl);
		$this->assertTrue(is_null($agoraRubrique), "Error value returned");
		$this->assertFalse($entity->getInitOK(), "InitOK");
		
		$this->echo_p("\n<p>------- TEST: testErrorHandling END.</p>\n");
	} 

	
		
	function testGetAgoraEntity() {
		$testUrl = $GLOBALS['testunit_dxs_urlrubrique'];
		$this->echo_p("<p>------- TEST: testGetAgoraEntity: $testUrl</p>\n");
                
		$refEntity = &recuperer_instance_rubrique();
		$refEntity->load($GLOBALS['testunit_dxs_idrubrique']);
		
		$entity = new DXS_Container();
		$agoraRubrique = $entity->getAgoraEntity($testUrl);
	
                //basic verifications
		$this->assertEquals('100/INIT OK', $entity->debugLastError, 'Debug error.');
                $this->assertTrue(isset($agoraRubrique), "Agora Rubrique an object");
		$this->assertTrue(isset($entity->agoraContainer), "agoraContainer");
		
		if (isset($agoraRubrique) && isset($entity->agoraContainer))
		{
			//field values
			$this->assertEquals($refEntity->getRubriqueId(), $agoraRubrique->getRubriqueId(), "ID Rubrique");
			$this->assertEquals($refEntity->getLang(), $agoraRubrique->getLang(), "Language");
			$this->assertLooselyEquals($refEntity->getTitre(), $agoraRubrique->getTitre(), "Title");
			$this->assertLooselyEquals($refEntity->getTexte(), $agoraRubrique->getTexte(), "Descirption of the container");
			$this->assertEquals($refEntity->getDate(), $agoraRubrique->getDate(), "Creation date");
			
			//item values
			$this->assertEquals(2, count($entity->items), "Number of items");
			$this->assertEquals("spiparticle", $entity->items[0]->_itemType, "First article type");
			$this->assertEquals("10. Un article tres simple (No1)", $entity->items[0]->_titre, "First article name");
		
		}
	
		$this->echo_p("\n<p>------- TEST: testGetAgoraEntity END.</p>\n");
	} 
    
    
}


{ //main
    $suite  = New PHPUnit_TestSuite('DXS_ContainerTest');
    $result = PHPUnit::run($suite);
    echo $result->toHtml();
}


?>
