<?php
//
// +----------------------------------------------------------------------+
// | The suite of PHPTests for the DXS Framework - class document         |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Maciek Borowka <mborowka@clever-age.com                      |
// +----------------------------------------------------------------------+
//



$new_include_dir = dirname(__FILE__)."/../../";
set_include_path(get_include_path() . ":" . $new_include_dir);


require_once 'tests/CA_TestCase.php';

//l'objet a tester
require_once dirname(__FILE__).'/../../ecrire/include/bd/inc_document_factory.php';
require_once dirname(__FILE__).'/../../ecrire/include/dxs/document.php';

//quelques constantes
require_once 'inc_test_dxs.php';

class DXS_DocumentTest extends CA_TestCase
{
	var $refdocument;


	function DXS_DocumentTest($name) {
		$this->CA_TestCase($name);
	}

	function setUp() {
		$this->refdocument = &recuperer_instance_document();
		$this->refdocument->load($GLOBALS['testunit_dxs_iddoc']);
		//$this->refdocument->getFichierContenu();
		//$this->echo_h1("size: ".$this->refdocument->_taille);
		
		$this->verboseTest = FALSE;
	}

	function tearDown() {
		unset($this->refdocument);
	}

	function testGetAgoraEntity() {
		$testFile = $GLOBALS['testunit_dxs_urldoc'];
		$this->echo_p("<p>------- TEST: testGetAgoraEntity (DOCUMENT): $testFile</p>\n");
		$entity = new DXS_Document();
		$agoraDoc = $entity->getAgoraEntity($testFile);
		$this->assertTrue(isset($agoraDoc), "Agora Document an object");
		
		if (isset($agoraDoc))
                {
			$this->assertEquals($this->refdocument->_taille, $agoraDoc->_taille, "Les tailles");
			$this->assertTrue($this->refdocument->getFichierContenu() == $agoraDoc->getFichierContenu(), "Les contenus sont egaux");
		}
		$this->echo_p("\n<p>------- TEST: testGetAgoraEntity END.</p>\n");
	} 
    
}


{ //main
	$suite  = New PHPUnit_TestSuite('DXS_DocumentTest');
	$result = PHPUnit::run($suite);
	echo $result->toHtml();
}


?>
