<?php
//
// +----------------------------------------------------------------------+
// | The suite of PHPTests for the DXS Framework - class factory          |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Maciek Borowka <mborowka@clever-age.com                      |
// +----------------------------------------------------------------------+
//


$new_include_dir = dirname(__FILE__)."/../../";
set_include_path(get_include_path() . ":" . $new_include_dir);


//XXX BUG dans Agora:
//require_once (dirname(__FILE__)."../../../ecrire/mes_options.php3");

require_once 'ecrire/include/dxs/inc_dxs_factory.php';
require_once 'tests/CA_TestCase.php';


class DXS_FactoryTest extends CA_TestCase
{
    var $refValidator;
    var $itemArticleTree;   

    function DXS_FactoryTest($name) {
	$this->CA_TestCase($name);
    }

    function setUp() {
	$this->refValidator = new DXS_TrivialValidatorData("http://www.clever-age.com/DXS:1.1", "item");
	$itemArtileUrl = dirname(__FILE__)."/itemOK.xml";
	$treeObject = new DXS_Object();
	$treeObject->initFromFile($itemArtileUrl, $this->refValidator);
	$this->itemArticleTree = $treeObject->getXMLTree();
	
	$this->verboseTest = FALSE;
    }

    function tearDown() {
    }

    function testCreateItem() {
	$testUrl = dirname(__FILE__)."/itemOK.xml";
	$this->echo_p("<p>------- TEST: testCreateItem: $testUrl</p>\n");
	
	$factory = new DXS_Factory();
	$item = $factory->createItem($this->itemArticleTree->root);
	$this->assertFalse(is_null($item), "Created item null");
	
	$this->echo_p("\n<p>------- TEST: testCreateItem END.</p>\n");
    }
   
    function testIsSupported() {
	$testUrl = dirname(__FILE__)."/itemOK.xml";
	$this->echo_p("<p>------- TEST: testInitObject: $testUrl</p>\n");
	
	$factory = new DXS_Factory();
	$item = $factory->createItem($this->itemArticleTree->root);
	$this->assertFalse(is_null($item), "Created item null:");
	$this->assertTrue($factory->itemTypeSupported($item), "This object is an article");
	
	$rubrItem = new DXS_Item();
	$rubrItem->_itemType = "rubrique";
	$this->assertTrue($factory->itemTypeSupported($item), "This object is an rubrique");
	
	$this->echo_p("\n<p>------- TEST: testInitObject END.</p>\n");
    }
   
    function testCreateObject() {
	$testUrl = dirname(__FILE__)."/itemOK.xml";
	$this->echo_p("<p>------- TEST: testCreateObject: $testUrl</p>\n");
	
	$factory = new DXS_Factory();
	$item = $factory->createItem($this->itemArticleTree->root);
	$this->assertFalse(is_null($item), "Created item null:");
	
	$object = $factory->createObject($item);
	$this->assertFalse(is_null($object), "The object is null:");
	$this->assertEquals("dxs_article", get_class($object), "The type of the object:");
	
	$this->echo_p("\n<p>------- TEST: testCreateObject END.</p>\n");
    }
 
    
}


{ //main
	$suite  = New PHPUnit_TestSuite('DXS_FactoryTest');
	$result = PHPUnit::run($suite);
	echo $result->toHtml();
}


?>
