<?php
//
// +----------------------------------------------------------------------+
// | The suite of PHPTests for the DXS Framework - class item             |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Maciek Borowka <mborowka@clever-age.com                      |
// +----------------------------------------------------------------------+
//



$new_include_dir = dirname(__FILE__)."/../../";
set_include_path(get_include_path() . ":" . $new_include_dir);


require_once 'tests/CA_TestCase.php';

//l'objet a tester
require_once 'ecrire/include/dxs/dxs_object.php';
require_once 'ecrire/include/dxs/item.php';


class DXS_ItemTest extends CA_TestCase
{
        var $refValidator;

	function DXS_ItemTest($name) {
		$this->CA_TestCase($name);
               
	}

	// called before the test functions will be executed
	function setUp() {
            $this->refValidator = new DXS_TrivialValidatorData("http://www.clever-age.com/DXS:1.2", "item");
	    
	    $this->verboseTest = FALSE;
	}

	// called after the test functions are executed
	function tearDown() {
	}

	function testInitItem() {
		$testUrl = dirname(__FILE__)."/itemOK.xml";
		$this->echo_p("<p>------- TEST: testInitItem: $testUrl</p>\n");
                
		$dxsObject = new DXS_Object();
		$this->assertTrue($dxsObject->initFromFile($testUrl, $this->refValidator), "Test suite consistency");
		
		//error code for debug purposes only
		$this->assertEquals('100/INIT OK', $dxsObject->debugLastError, 'Debug error. It does not mean anything!');
		
		if ($dxsObject->getInitOK())
		{
			$entity = new DXS_Item();
			$tree = $dxsObject->getXMLTree();
	
			$this->assertTrue($entity->initItem($tree->root), "Parse result");
			
			//field values
			$this->assertEquals('http://localhost/work/agora/article_dxs.php?id_article=1', $entity->_url, "URL");
			$this->assertEquals('Le titre de cet item est inconnu :+)', $entity->_titre, "Name/title");
			$this->assertLooselyEquals('La description de cet item est, quant a elle,
parfaitement connue', $entity->_description, "Descr.");
			$this->assertEquals('spiparticle', $entity->_itemType, "ItemType");
			$this->assertEquals('2003-08-16T21:10:50Z', $entity->_pubDate, "Creation date");
			$this->assertEquals('2003-08-16T21:12:50Z', $entity->_updateDate, "Creation date");
		}
		$this->echo_p("\n<p>------- TEST: testInitItem END.</p>\n");
                
	} 
    
    
}


{ //main
    $suite  = New PHPUnit_TestSuite('DXS_ItemTest');
    $result = PHPUnit::run($suite);
    echo $result->toHtml();
}


?>
