<?php
//
// +----------------------------------------------------------------------+
// | The suite of PHPTests for the DXS Framework - class object           |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Maciek Borowka <maciek@clever-age.com                        |
// +----------------------------------------------------------------------+
//



$new_include_dir = dirname(__FILE__)."/../../";
set_include_path(get_include_path() . ":" . $new_include_dir);


require_once 'tests/CA_TestCase.php';

//l'objet a tester
require_once 'ecrire/include/dxs/dxs_object.php';

//quelques constantes
require_once 'inc_test_dxs.php';

class DXS_ObjectTest extends CA_TestCase
{
	// contains the object handle of the DSX_ArticleTree class
	var $reference;
        
        var $refValidator;

	function DXS_ObjectTest($name) {
		$this->CA_TestCase($name);
	}

	// called before the test functions will be executed
	function setUp() {
		$this->reference = new DXS_Object();
                $this->refValidator = new DXS_TrivialValidatorData("http://www.clever-age.com/DXS:1.2", "spiparticle");
                //var_dump($this->refValidator);
	}

	// called after the test functions are executed
	function tearDown() {
		unset($this->reference);
	}

	function testParserPHP_XML() {
		$this->echo_p("<p>------- TEST: testParserPHP_XML.</p>\n");
		$aValidator = new DXS_TrivialValidatorData("xx", "ala");
		//$cdata = 'mycdatas\&ection';
		$cdata = 'raz&dwa';
		$xmlData='<ala xmlns="xx"><section><![CDATA['.$cdata.']]></section></ala>';
		
		$entity = new DXS_Object();
		$this->assertTrue($entity->initFromString($xmlData, $aValidator), "initFromString return value");
		$this->assertTrue($entity->getInitOK());
		
		$xmlTree = $entity->getXMLTree();
		$tag = $xmlTree->root->children[0];
		//echo $cdata. ' '.$tag->content;
		$this->assertLooselyEquals($cdata, $tag->content, "content");
		
		$this->echo_p("\n<p>------- TEST: testParserPHP_XML END.</p>\n");
	}
	
	
	function testHandleCDATA() {
		$this->echo_p("<p>------- TEST: testHandleCDATA.</p>\n");
		$aValidator = new DXS_TrivialValidatorData("xx", "ala");
		$xmlData='<ala xmlns="xx"><section><![CDATA[sadfsgjfdsg]]></section></ala>';
		
		$entity = new DXS_Object();
		$this->assertTrue($entity->initFromString($xmlData, $aValidator), "initFromString return value");
		$this->assertTrue($entity->getInitOK());
		unset($entity);
		
		$xmlData='<ala xmlns="xx"><section escape="very_random_string"><![CDATA[sadfvery_random_stringXdgjfdsg]]></section></ala>';
		
		$entity = new DXS_Object();
		$this->assertTrue($entity->initFromString($xmlData, $aValidator), "initFromString return value");
		$this->assertTrue($entity->getInitOK());
		
		//first child of the root:
		$xmlTree = $entity->getXMLTree();
		$tag = $xmlTree->root->children[0];
		$this->assertEquals("sadfvery_random_stringXdgjfdsg", $tag->content, "before call sanity check");
		
		$entity->handleCDATA(&$tag);
		
		$this->assertEquals("sadf]]>Xdgjfdsg", $tag->content, "After call");
		
		$this->echo_p("\n<p>------- TEST: testHandleCDATA END.</p>\n");
	}
	
	function testNoInit() {
		$this->echo_p("<p>------- TEST: testNoInit.</p>\n");
		$entity = new DXS_Object();
		$this->assertFalse($entity->getInitOK());
		$this->echo_p("\n<p>------- TEST: testNoInit END.</p>\n");
	}

	function testBadInit() {
		$testFile = dirname(__FILE__)."/fileKO.xml";
		$this->echo_p("<p>------- TEST testBadInit with content of the file: $testFile.</p>\n");
		$entity = new DXS_Object();
		$this->assertFalse($entity->initFromString(file_get_contents($testFile), $this->refValidator));
		$this->assertFalse($entity->getInitOK());
		$this->echo_p("\n<p>------- TEST testBadInit END.</p>\n");
	}    

		
	function testInitFromString() {
		$testFile = dirname(__FILE__)."/fileOK.xml";
		$this->echo_p("<p>------- TEST: testInitFromString</p>\n");
		
		$entity = new DXS_Object();
		$this->assertTrue($entity->initFromString(file_get_contents($testFile), $this->refValidator), "initFromString return value");
		$this->assertTrue($entity->getInitOK());
		$this->assertNotNull($entity->xmlTree);
		$this->assertNotNull($entity->content);
		
		$this->echo_p("\n<p>------- TEST testInitFromString END.</p>\n");
	}    

	function testInitFromFile() {
		$testFile = dirname(__FILE__)."/fileOK.xml";
		$this->echo_p("<p>------- TEST: testInitFromFile: $testFile</p>\n");
		
		$entity = new DXS_Object();
		$this->assertTrue($entity->initFromFile($testFile, $this->refValidator), "return value");
		$this->assertTrue($entity->getInitOK(), "getInitOK");
		$this->assertNotNull($entity->xmlTree, "xmlTree OK");
		$this->assertNotNull($entity->content, "content OK");

		$this->assertFalse($entity->initFromFile($testFile, new DXS_TrivialValidatorData("ala", "ala")));
		$this->assertFalse($entity->getInitOK());
		
		$this->echo_p("\n<p>------- TEST testInitFromFile END.</p>\n");
	}   
        	
	function testInitFromURL() {
		$testFile = $GLOBALS['testunit_dxs_urlarticle'];
		$this->echo_p("<p>------- TEST: testInitFromURL: $testFile</p>\n");
		
		$entity = new DXS_Object();
		$aValidator = new DXS_TrivialValidatorData("http://www.clever-age.com/DXS:1.2", "article");
		$this->assertTrue($entity->initFromFile($testFile, $aValidator), "initFromFile return value");
		$this->assertTrue($entity->getInitOK(), "getInitOK");
		$this->assertNotNull($entity->xmlTree, "xmlTree OK");
		$this->assertNotNull($entity->content, "content OK");

	
		$this->echo_p("\n<p>------- TEST testInitFromURL END.</p>\n");
	}   
}

{ //main
    $suite  = New PHPUnit_TestSuite('DXS_ObjectTest');
    $result = PHPUnit::run($suite);
    echo $result->toHtml();
}
?>
