<?php
/* Improved Cells for FPDF = ic_fpdf
 *
 * Extends FPDF to define new Cell or MultiCell functions to improve the
 * output composition.
 * Version: 1.0
 * Author: D. Deveaux
 * Licence: FREE
 *
 * The functions use various contributions from :
 */
$dr = $_SERVER['DOCUMENT_ROOT'];
/* for test only
$ip = ini_get('include_path');
ini_set('include_path', "$dr/include:".$ip);
*/

require_once "pdf_doc/ic_fpdf.php";

/** A new abstract class that can be used by inheritance as FPDF.
    Explode Header() and Footer() functions in First... and Next... to have
    different page format for the first page.
    Add several functions to out Cells and MultiCells
 */
class Doc_PES extends IC_FPDF
{

    /** Base constructor */
    function Doc_PES( $orientation='P', $unit='mm', $format='A4') {
	// Call the parent constructor
	$this->IC_FPDF($orientation,$unit,$format);
    }


    /** Header function for the first page
     */
    function FirstHeader() {
        global $dr;
        
	$this->SetDrawColor(170);
	$this->SetTextColor(170);
	$this->SetFont('Arial', '', 11);
	$this->TextWithDirection(5.5, 130, 
                      'Animation Musiques, Danses et Culture de Bretagne', 'U');
	$this->Line(9, 146, 9, O);
        $this->Image("$dr/images/logoPES-small.png", 6, 5, 32);
    }

    /** Header function for the next pages
     */
    function NextHeader() {}

    /** Footer function for the first page
     */
    function FirstFooter() {
	$hpg = 295;
	$this->SetDrawColor(170);
	$this->SetTextColor(170);
	$this->Line(0, $hpg-3.4, 111, $hpg-3.4);
	$this->SetFillColor(170);
	$this->Rect(111, $hpg-8.4, 111, 8.4, 'F');
	$this->SetDrawColor(255);
	$this->SetTextColor(255);
	$this->Line(111, $hpg-3.4, 210, $hpg-3.4);
	$this->SetFont('Arial', 'I', 12);
	$this->Text(122.5, $hpg-4, 'Association Culturelle "Pouvr\'et Seu"');
	$this->SetTextColor(90);
	$this->SetFont('Arial', '', 7);
	$this->Text(13, $hpg-13,
	             "Toute correspondance doit tre adresse  :");
	$this->SetFont('Arial', 'B', 7);
	$this->Text(13, $hpg-8.9, 'Association "Pouvr\'et Seu"');
	$this->SetFont('Arial', '', 7);
	$this->Text(53, $hpg-8.9, "Le Houssais -- 44390 SAFFRE");
	$this->Text(13, $hpg-6.4, "Tlphones: 02 40 77 20 24 - 02 97 46 05 00");
	$this->SetFont('Courier', 'B', 7);
	$this->Text(13, $hpg-3.9, "mailto:pouevretseu@free.fr --- http://pouevretseu.free.fr/");
	$this->SetDrawColor(0);
	$this->SetTextColor(0);
    }

    /** Footer function for the next pages
     */
    function NextFooter() {
	$hpg = 295;
	$this->SetDrawColor(170);
	$this->SetTextColor(170);
	$this->Line(0, $hpg-2, 111, $hpg-2);
	$this->SetFillColor(170);
	$this->Rect(111, $hpg-7, 111, 7, 'F');
	$this->SetDrawColor(255);
	$this->SetTextColor(255);
	$this->Line(111, $hpg-2, 210, $hpg-2);
	$this->SetFont('Arial', 'I', 12);
	$this->Text(122.5, $hpg-2.2, 'Association Culturelle "Pouvr\'et Seu"');
	$this->SetDrawColor(0);
	$this->SetTextColor(0);
	$this->SetFont('Arial', '', 6);
	$this->Text(199, $hpg-2.2, 'Page '.$this->PageNo().'/{nb}');
    }


}

/*
$html='Vous pouvez maintenant imprimer facilement du texte mlangeant diffrents styles : <B>gras</B>, <I>italique</I>, <U>soulign</U>, ou <B><I><U>tous  la fois</U></I></B> !<BR>
Vous pouvez aussi insrer des liens sous forme textuelle, comme <A HREF="http://www.fpdf.org">www.fpdf.org</A>, ou bien sous forme d\'image : cliquez sur le logo.';

$pdf=new Doc_PES();

$txt = 'Pour voir!';
$pdf->TextWithDirection (80, 80, $txt, 'R');
$pdf->TextWithDirection (80, 80, $txt, 'U');
$pdf->TextWithDirection (80, 80, $txt, 'D');
$pdf->TextWithDirection (80, 80, $txt, 'L');
$pdf->TextWithRotation (120, 80, $txt, 45, -45);
$pdf->SetXY (100, 100);
$pdf->Cell (40, 10, $txt.$txt.$txt.$txt, 1, 1);
$pdf->HCell (40, 10, $txt.$txt.$txt.$txt, 1);
$pdf->VCell (10, 40, $txt."\n".$txt, 1);
$pdf->SetXY (30, 150);
for ( $i = 0 ; $i < 30 ; $i++ ) {
    $pdf->Justify (4.5, $html);
}
$pdf->MultiCellBlt (0, 4.5, chr (192), $html);
$pdf->MultiCellBlt (0, 4.5, "<> ", $html);
for ( $i = 1 ; $i < 4 ; $i++ ) {
    $pdf->MultiCellBlt (0, 4.5, "$i.", $html);
}

$pdf->WriteOutput ('test.pdf');
*/
?>
