<?php
/*
 * Package: xml/collection
 * Version: 0.01
 * Date: 20020907
 * Author: Daniel Deveaux
 * Licence: GPL (see the file 'COPYING' and 'GNU_LICENSE' in distribution)
 *
 */ 
// chemins de base
    $lib = (dirname(dirname(__FILE__));
    $ip = ini_get ('include_path');
    ini_set ('include_path', "$lib:".$ip);

    include_once "info/func.php";

require_once "xml/collection.php";
require_once 'Text/MiniWiki.php';

if ( strcmp(PHP_VERSION, '4.3.0') < 0 )
{
    include_once "Compat/Function/html_entity_decode.php";
}
set_magic_quotes_runtime(0);

$jscr = "<script type='text/javascript'>
function retToList() {
    window.opener.location.reload();
    close();
    }
</script>\n\n";

$wikidoc = "$phpurl/MiniWikiDoc.php?mode=help";
$txtwiki = "<div style='margin: 3em 5em 1em 5em; padding: 0.3ex 2ex;
background-color: #d9e9e9; border: 1px solid black;'>
<p style='text-align: center'>Merci de <b style='color: red;'>ne pas faire de
copier/coller</b> depuis une page d'dition ou de visualisation de HTML, Word ou
OO <em>(par contre, un copier/coller depuis un xterm ou un diteur texte
fonctionne bien).</em><br />
Vous pouvez employer des <a href='$wikidoc' target='_new'><b>constructions 
Wiki</b></a> pour remplir et structurer les champs de ce formulaire.<br />
<em>Les champs griss ne sont pas modifiables par vous</em>.</p> </div>\n";

/** function to constrain a coding in manipulated strings
 */
function _recode_entry($txt, $coding = 'ISO-8859-15')
{
    //convert all types of single quotes
    $fin = str_replace(chr(145), "'", $txt);
    $fin = str_replace(chr(146), "'", $fin);

    //convert all types of double quotes
    $fin = str_replace(chr(147), chr(34), $fin);
    $fin = str_replace(chr(148), chr(34), $fin);
    $fin = htmlspecialchars($fin, ENT_NOQUOTES, $coding);
    $fin = str_replace(" ", "", $fin);
    $fin = str_replace("?", "", $fin);
    $fin = str_replace("&rsquo;", "'", $fin);
    //$fin = str_replace("&euro;", "", $fin);
    return $fin;
}

/** A class to manage all the creation modification and deletion dialogs
 */
class CollHandler
{

    var $buffer = '';           // text buffer to prepare HTML page
    var $args = array();        // the actual args
    var $collec = null;         // reference to the actual collection
    var $curelt = null;         // reference to the current Coll Element
    var $action = '';           // current action launched by forms

    /** CollHandler constructor
     */
    function CollHandler()
    {}

    /** add to  output buffer (unoptimized)
     */
    function _add_to_buffer($txt)
    {
        $this->buffer .= $txt;
    }

    function init($act)
    {
        global $jscr;
        $this->action = $act;
        $this->buffer = '';
        $this->args = array();
        foreach (array_keys($_POST) as $k) {
            $this->args[$k] = _recode_entry(stripslashes($_POST[$k]));
        }
        // print_r($this->args);
        $this->collec = new XmlCollection($this->args['cfile'],
                                          $this->args['mode']);
        if ( $this->args['todo'] == 'add') {
            $this->curelt = null;
            $title = "Cration d'lment ". $this->collec->name;
        }
        elseif ( $this->args['todo'] == 'mod' ) {
            $this->curelt = $this->collec->getAnElt ($this->args['key']);
            $title = "Modification d'lment ". $this->collec->name;
        }
        elseif ( $this->args['todo'] == 'valid' ) {
            $this->curelt = $this->collec->getAnElt ($this->args['key']);
            $title = "Validation ". $this->collec->name;
        }
        elseif ( $this->args['todo'] == 'send' ) {
            $this->curelt = $this->collec->getAnElt ($this->args['key']);
            $title = "Elment enregistr ". $this->collec->name;
        }
        elseif ( $this->args['todo'] == 'del' ) {
            $this->curelt = $this->collec->getAnElt ($this->args['key']);
            $title = "Supression d'lment ". $this->collec->name;
        }
        elseif ( $this->args['todo'] == 'exdel' ) {
            $this->curelt = $this->collec->getAnElt ($this->args['key']);
            $title = "Elment dtruit ". $this->collec->name;
        }
        else {  // action 'valid'
            ; // ici ce doit tre une erreur
        }
        $this->_add_to_buffer("<html>\n<head>\n". $jscr ."</head>\n<body>\n".
                              "<center><h2>". $title ."</h2></center>");
        // print_r($this->args);
    } // --------------------------------------------------------------- init()

    /** Show the current values in a HTML table
     */
    function show() {
        $values = array();
        for ($i = 0 ; $i < $this->collec->items_count() ; $i++) {
            $values[$i] = $this->args["item$i"];
        }
	$wiki =& new MiniWiki();
        $in_table = false; 
        $style = "background-color: #ddd; border: solid 1pt;";
	for ($i = 0 ; $i < $this->collec->items_count() ; $i++) {
            $key = $this->collec->template->index[$i];
	    $value = $values[$i];
            $n = preg_match('/\d+,\d+/', $this->collec->template->chps[$key]);
            if ( $n == 0 ) {
                // the current field is not a textarea
		if ( ! $in_table ) {
		    $in_table = true;
                    $this->_add_to_buffer("<table border='0' width='100%'>\n".
                           "<colgroup><col width='35%'/><col width='65%'/>".
                           "</colgroup>\n");
                }
                $this->_add_to_buffer(" <tr>\n  <td>".
                        $this->collec->template->labels[$key]." :</td>\n");
            //     if ( $this->collec->template->extref[$key] ) {
            //         $value = $this->ref->tags[$i]->get_attribute('ref');
                    // to be adapted with args 
            //    }
                $val = $wiki->transform($value);
                $this->_add_to_buffer("  <td style='$style'>".$val."</td>\n");
            } else {                    // the current field is a textarea
		if ( $in_table ) {
		    $this->_add_to_buffer("</table>\n<hr/>\n");
		    $in_table = false;
		}
		$this->_add_to_buffer("<p><b>".
                                      $this->collec->template->labels[$key].
                                      "</b>:<br/>\n");
                $val = $wiki->transform($value);
                $this->_add_to_buffer("<div class='text' style='$style'>".$val.
                                      "</div>\n");
            }
	}
        if ( $in_table ) {
            $this->_add_to_buffer(" </tr>\n</table>\n");
        }
    }

    /** place an hidden form in the page to transmit data to next step
     *  the only shown elements are buttons
     */
    function hidden_form($state, $message) {
        $this->_add_to_buffer("<hr/>
                              <!-- $state button with all parameters -->
                              <form action='". $this->action ."' method='POST'>
                              <input type='hidden' name='todo' value='".$state."'>\n");
        for ( reset($this->args) ; list($key, $val) = each($this->args) ;) {
            //print "$key<br/>";
            if ( $key != 'todo' ) {
                $this->_add_to_buffer("<input type='hidden' name='$key' ".
                                      "value=\"".addslashes(htmlspecialchars($val)).
                                      "\">\n");
            }
        }
        $this->_add_to_buffer("<input type='submit' value=\"".$message."\">".
                              "</form>\n");
    }

    /** reverse function of php function htmlspecialchars()
     */
    function unhtmlspecialchars( $string ) {
	$string = str_replace( '&#039;', '\'', $string );
	$string = str_replace( '&quot;', '\"', $string );
	$string = str_replace( '&lt;', '<', $string );
	$string = str_replace( '&gt;', '>', $string );
	$string = str_replace( '&amp;', '&', $string );
	return $string;
    }

    /** save an html page if required
     */
    function save_page() {
        global $dr;
        $txt = (isset($this->args['opheader'])) ? 
                   $this->unhtmlspecialchars(
                       $this->unhtmlspecialchars(
                              stripslashes($this->args['opheader']))) : '';
        if ( isset($this->args['ophidden']) ) {
            $hidden = split(',', $this->args['ophidden']);
        } else {
            $hidden = array();
        }
        $txt .= $this->curelt->show($hidden);
        if ( isset($this->args['opfooter']) ) {
            $txt .= $this->unhtmlspecialchars(
                          $this->unhtmlspecialchars(
                                 stripslashes($this->args['opfooter'])));
        }
        $filename = $this->curelt->substTemplateLine($this->args['opage']);
        $this->_add_to_buffer("<p>Fabrication de '$filename' ..... ");
        $fp = fopen("$dr$filename", "w");
        fwrite($fp, $txt);
        fclose($fp);
        $this->_add_to_buffer("Ok</p>\n");
    }
    
    /** display the form to back to calling page
     */
    function back_to_caller($message) {
        $this->_add_to_buffer("<center>\n<p>".
            "<form name='b2c' method='post' action=''>".
            "<input type='button' name='exit' onclick='retToList()' ".
            "value=\"". $message ."\"></form>".
            "</p>\n</center>\n</div>\n</div>\n");
    }

    /** display the acquisition page
     */
    function acquisition($empty = true) {
        global $txtwiki;
        $this->_add_to_buffer($txtwiki);
        $this->_add_to_buffer("<p>&nbsp;</p>\n<form method='post' ".
                              "action='". $this->action ."' target='_self'>\n".
                              "<center>\n<input type='hidden' name='parent' ".
                              "value='". $this->args['parent'] ."'>\n".
                              "<input type='hidden' name='mode' value='".
                              $this->args['mode'] ."'>\n".
                              "<input type='hidden' name='todo' ".
                              "value='valid'>\n");
        foreach (array('opage', 'opheader', 'opfooter', 'ophidden') as $key) {
            if ( isset($this->args[$key])) {
                $this->_add_to_buffer("<input type='hidden' name='$key' ".
                                      "value=\"".$this->args[$key]."\" />\n");
            }
        }
        if ( $empty ) {
            $this->_add_to_buffer(
                $this->collec->template ->form($this->args['cfile']))
            ;
        } else {
            $this->_add_to_buffer(
                            $this->collec->template ->form($this->args['cfile'],
                               $this->curelt, $this->args, $this->args['pre']));
        }
        $this->_add_to_buffer("<input type='reset' value='RAZ' name='Reset'>\n".
                              "<input type='submit' value='Valider'>\n".
                              "</center>\n</form>\n");
    }

    /** display the validation page
     */
    function control_display($mode) {
        $this->_add_to_buffer("<div style='margin: 1ex 5em;'>\n<p>".
                    "L'enregistrement slectionn est :</p>\n");
        if ( $mode == 'valid' ) {
            $this->_add_to_buffer($this->show());
            $this->hidden_form('send', 'Sauvegarder');
            $this->hidden_form('mod', 'Modifier  nouveau');
        } else {        // 'del' mode
            $this->_add_to_buffer($this->curelt->show());
            $this->hidden_form('exdel', 'Confirmer la destruction');
            $this->back_to_caller("Annuler la destruction");
        }
    }
    
    /** save the element and display report page
     */
    function save_element() {
        $items = array();
        for ( $i = 0 ; $i < $this->collec->items_count() ; $i++ ) {
            $k = $this->args['pre']."item$i";
            if ( ! isset ($this->args[$k]) ) { $item[$i] = ''; } 
            else { $items[$i] = stripslashes($this->args[$k]); }
        }
        //print_r($items);
        if ($this->args['key']) {
            $this->collec->updateElt($this->args['key'], $items);
            $this->_add_to_buffer("<div style='margin: 1ex 2em;'>\n".
                                  "<p>&nbsp;&nbsp;lment mis  jour:</p>\n");
        } else {
            $newkey = $this->collec->build_key($items);
            //print "===== $newkey<br />\n";
            //print_r($items);
            $this->collec->createElt($newkey, $items);
            $this->args['key'] = $newkey;
            $this->_add_to_buffer("<div style='margin: 1ex 2em;'>\n".
                                  "<p>&nbsp;&nbsp;lment cr:</p>\n");
        }
        if ( isset($this->args['opage']) && $this->args['opage'] ) {
            $this->save_page();
        }
        $this->collec->saveFile();
        $this->_add_to_buffer("<hr>\n<p>Fichier '".$this->collec->name.
                              "' sauvegard</p>\n");
        $this->back_to_caller("Retour  la page d'appel");
    }
    
    /** del the element and display report page
     */
    function del_element() {
        $this->collec->removeElt($this->args['key']);
        $this->_add_to_buffer("<div style='margin: 1ex 2em;'>\n".
                              "<p>L'lment de cl '". $this->args['key'] .
                              "' a t supprim.</p>\n");
        $this->collec->saveFile();
        $this->_add_to_buffer("<hr>\n<p>Fichier '".$this->collec->name.
                              "' sauvegard</p>\n");
        $this->back_to_caller("Retour  la page d'appel");
    }
    
    function go($act) {
        $this->init($act);
        if ( $this->args['todo'] == 'add') {
            $this->acquisition(true);
        }
        elseif ( $this->args['todo'] == 'mod' ) {
            $this->acquisition(false);
        }
        elseif ( $this->args['todo'] == 'valid' ) {
            $this->control_display('valid');
        }
        elseif ( $this->args['todo'] == 'send' ) {
            $this->save_element();
        }
        elseif ( $this->args['todo'] == 'del' ) {
            $this->control_display('del');
        }
        elseif ( $this->args['todo'] == 'exdel' ) {
            $this->del_element();
        }
        else { 
	    print "<h2>Bug!</h2>
	    Le formulaire est dans un tat inconnu : '".
	    $this->param['state'] ."<br />
	    Merci de signaler ce problme...";
        }
        $this->_add_to_buffer("</body>\n</html>\n");
        print $this->buffer;
    }
}

$ch = new CollHandler();
$ch->go($self);
?>
