<?xml version="1.0" encoding="iso-8859-1"?>
<!-- cours2xml.xsl : Convert a XHTML course document to XML fragment
     $Id: cours2xml.xsl,v 1.1.1.1 2005/06/13 00:26:10 deveaux Exp $
     -->

<xsl:stylesheet
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:html="http://www.w3.org/1999/xhtml"
  version="1.0"
>


  <xsl:output method="xml" encoding="iso-8859-1"
   indent="yes" media-type="text/xml" />

  <xsl:strip-space elements="xsl:*" />
  <xsl:strip-space elements="*" />
  <xsl:preserve-space elements="html:pre" />

  <xsl:param name="figdir">./fig</xsl:param>

  <!--  start of document recursion 	-->
  <xsl:template match="/">
    <xsl:text>%% Dbut de fiche</xsl:text>
    <xsl:value-of select="$newline" />
    <xsl:apply-templates />
    <xsl:value-of select="$newline" />
    <xsl:text>\clearpage</xsl:text>
    <xsl:value-of select="$newline" />
    <xsl:text>%% Fin de fiche</xsl:text>
    <xsl:value-of select="$newline" />
  </xsl:template>

  <!-- meta-data processing: produce latex preamble -->


  <xsl:template match="html:head" />

  <xsl:template match='html:body'>
   <xsl:apply-templates />
  </xsl:template>

  <xsl:template match='html:div[@id="title"]'/>
  <xsl:template match='html:div[@id="navig"]'/>

  <xsl:template match='html:h1'>
    <xsl:element name="titre">
    </xsl:element>
    <xsl:text>\begin{center}\LARGE\textbf{</xsl:text>
    <xsl:apply-templates mode='h1' />
    <xsl:text>}\end{center}</xsl:text><xsl:value-of select="$newline" />
    <xsl:value-of select="$newline" />
  </xsl:template>


  <xsl:template match='html:div[@id="header"]' />
  <xsl:template match='html:div[@class="noprint"]' />
  <xsl:template match='html:div[@id="navig"]' />
  <xsl:template match='html:div[@id="toc"]' />
  <xsl:template match='html:div[@id="foot"]' />

  <xsl:template match='html:div[@id="meta"]'>
      <xsl:apply-templates />
  </xsl:template>

  <xsl:template match='html:div[@id="main"]'>
      <xsl:apply-templates />
  </xsl:template>

  <xsl:template match='html:div[@class="sec"]'>
    <xsl:apply-templates />
  </xsl:template>

  <xsl:template match='html:h2'>
    <xsl:value-of select="$newline" />
    <xsl:text>~\\{\Large\textbf{</xsl:text>
    <xsl:apply-templates />
    <xsl:text>}}</xsl:text>
    <xsl:value-of select="$newline" />
    <xsl:value-of select="$newline" />
  </xsl:template>


</xsl:stylesheet>
